/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.w3c.dom.Node;

public class TestAgentElement
extends MainTagElement {
    public TestAgentElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public TestAgentElement(Node node, TagElement parent, List references) {
        super(node, parent, references);
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_TEST_AGENT_SERVICE;
    }

    public String getSuperClass() {
        if (this.getAttribute("superclass") != null) {
            return this.getAttribute("superclass");
        }
        return DeviceKitGenerationConstants.CLASS_TEST_AGENT;
    }

    public int getTagCode() {
        return 87;
    }

    public String getUserMessageBase() {
        return this.getAttribute("usermessagebase");
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("testcase".equals(childNodeName)) {
            this.handleTestCase(childNode);
        } else if ("profile".equals(childNodeName)) {
            this.handleProfile(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleProfile(Node node) {
        ProfileElement ese = new ProfileElement(node, this);
        this.addChild(ese);
    }

    protected void handleTestCase(Node childNode) {
        TestCaseElement element = new TestCaseElement(childNode, this);
        this.addChild(element);
    }
}

