/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.preference.jre.DeviceKitJREConstants;

public class DeviceKitPreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String VALIDATE_SCHEMA_KEY = "schema";
    public static final String[] DEF_DEV_SUPERS = new String[0];
    public static final String[] DEF_TRAN_SUPERS = new String[0];
    public static final String[] DEF_TRAN_SERVICES = new String[]{"matrix.example.matrix.lcd.transport.service.MatrixLcdTransportService"};
    public static final String[] DEF_TRAN_IMPLS = new String[]{"matrix.example.matrix.lcd.transport.MatrixLcdTransport"};

    public static String[] buildSuperClassList() {
        return DEF_DEV_SUPERS;
    }

    public static String[] buildTransportImplementationList() {
        return DEF_TRAN_IMPLS;
    }

    public static String[] buildTransportServiceList() {
        return DEF_TRAN_SERVICES;
    }

    public static String fixSlashes(String string) {
        return string.replace('\\', '/');
    }

    public static String[] getDefault(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        String value = store.getDefaultString(key);
        if (value != null) {
            return DeviceKitPreferenceInitializer.parsePrefArray(value);
        }
        return new String[0];
    }

    public static boolean getDefaultBoolean(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        boolean value = store.getDefaultBoolean(key);
        return value;
    }

    public static String[] getDefaultClasspathLocations() {
        String[] variables = JavaCore.getClasspathVariableNames();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < variables.length) {
            String varName = variables[i];
            IPath path = JavaCore.getClasspathVariable((String)varName);
            if (path != null && path.toFile().exists()) {
                File bundleFiles;
                String pathString = path.makeAbsolute().toString();
                list.add(DeviceKitPreferenceInitializer.fixSlashes(pathString));
                File file = new File(pathString);
                if (file.exists() && (bundleFiles = new File(file, "bundlefiles")).exists()) {
                    list.add(DeviceKitPreferenceInitializer.fixSlashes(bundleFiles.getAbsolutePath()));
                }
            }
            ++i;
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static Map getDefaultPreferencesMap() {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("packagebase", "org.eclipse.soda.dk");
        map.put("vendor", "IBM");
        map.put("vendortwo", "");
        map.put("name", "");
        map.put("lastused.name", "");
        map.put("provider", "Eclipse.org");
        map.put("version", "1.1.0");
        map.put("incubation", Boolean.FALSE);
        map.put("multiplex", Boolean.FALSE);
        map.put("generateold", Boolean.FALSE);
        map.put("generate.java", Boolean.TRUE);
        map.put("generate.manifest", Boolean.TRUE);
        map.put("generate.metadata", Boolean.TRUE);
        map.put("generate.properties", Boolean.TRUE);
        map.put("format", Boolean.TRUE);
        map.put("organizeImports", Boolean.TRUE);
        map.put(VALIDATE_SCHEMA_KEY, Boolean.TRUE);
        map.put("iveattrs", Boolean.FALSE);
        map.put("iveRes", Boolean.FALSE);
        map.put("connection.superclass", DeviceKitPreferenceInitializer.makePrefString(new String[]{"org.eclipse.soda.dk.connection.StreamConnection"}));
        map.put("device.superclass", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.buildSuperClassList()));
        map.put("transport.superclass", DeviceKitPreferenceInitializer.makePrefString(DEF_TRAN_SUPERS));
        map.put("transport.service", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.buildTransportServiceList()));
        map.put("transport.implementation", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.buildTransportImplementationList()));
        map.put("create.test", Boolean.TRUE);
        map.put("create.testcase", Boolean.TRUE);
        map.put("abstract", Boolean.FALSE);
        map.put("create.bundle", Boolean.TRUE);
        map.put("create.managed.bundle", Boolean.TRUE);
        map.put("create.managed.factory.bundle", Boolean.TRUE);
        map.put("device.superclass", DeviceKitPreferenceInitializer.makePrefString(DEF_DEV_SUPERS));
        map.put("classpath.locations", DeviceKitPreferenceInitializer.makePrefString(DeviceKitPreferenceInitializer.getDefaultClasspathLocations()));
        map.put("classpath.search.projects", Boolean.TRUE);
        map.put("usermessagebase", "1000");
        map.put(DeviceKitJREConstants.KEY_CLASSPATH_JRE_DEFAULT, DeviceKitJREConstants.JRE_IN_CLASSPATH_DEFAULT);
        map.put(DeviceKitJREConstants.KEY_EXECUTION_ENVIRONMENTS_DEFAULT, DeviceKitPreferenceInitializer.makePrefString(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_DEFAULT));
        map.put(DeviceKitJREConstants.KEY_CLASSPATH_JRE_TEST, DeviceKitJREConstants.JRE_IN_CLASSPATH_TEST_DEFAULT);
        map.put(DeviceKitJREConstants.KEY_EXECUTION_ENVIRONMENTS_TEST, DeviceKitPreferenceInitializer.makePrefString(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_TEST_DEFAULT));
        map.put(DeviceKitJREConstants.KEY_CLASSPATH_JRE_TESTAGENT, DeviceKitJREConstants.JRE_IN_CLASSPATH_TESTAGENT_DEFAULT);
        map.put(DeviceKitJREConstants.KEY_EXECUTION_ENVIRONMENTS_TESTAGENT, DeviceKitPreferenceInitializer.makePrefString(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_TESTAGENT_DEFAULT));
        map.put("need.device", Boolean.TRUE);
        map.put("need.transport", Boolean.TRUE);
        map.put("need.connection", Boolean.TRUE);
        map.put("need.adapter", Boolean.TRUE);
        return map;
    }

    public static String getDefaultString(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        return store.getDefaultString(key);
    }

    public static boolean getPreferenceBoolean(String key) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        if (store != null) {
            return store.getBoolean(key);
        }
        Map map = DeviceKitPreferenceInitializer.getDefaultPreferencesMap();
        Object value = map.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static String getPreferenceDefaultString(String key) {
        if (DeviceKitPlugin.getDefault() != null) {
            IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
            return store.getDefaultString(key);
        }
        return "";
    }

    public static String getPreferenceString(String key) {
        if (DeviceKitPlugin.getDefault() != null) {
            IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
            return store.getString(key);
        }
        return "";
    }

    public static IPreferenceStore getStore() {
        if (DeviceKitPlugin.getDefault() != null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    public static String makePrefString(String[] entries) {
        StringBuffer buffer = new StringBuffer(entries.length * 30);
        int i = 0;
        while (i < entries.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(entries[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] parsePrefArray(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        String[] result = new String[tokenizer.countTokens() + 1];
        int count = 1;
        result[0] = "";
        while (tokenizer.hasMoreTokens()) {
            String token;
            result[count] = token = tokenizer.nextToken();
            ++count;
        }
        return result;
    }

    public static void setPreference(String key, boolean value) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        store.setValue(key, value);
    }

    public static void setPreference(String key, String value) {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        store.setValue(key, value);
    }

    public static void setPreference(String key, String[] values) {
        DeviceKitPreferenceInitializer.setPreference(key, DeviceKitPreferenceInitializer.makePrefString(values));
    }

    public static final boolean validateAgainstSchema() {
        return DeviceKitPreferenceInitializer.getPreferenceBoolean(VALIDATE_SCHEMA_KEY);
    }

    public void initializeDefaultPreferences() {
        IPreferenceStore store = DeviceKitPreferenceInitializer.getStore();
        Map map = DeviceKitPreferenceInitializer.getDefaultPreferencesMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                store.setDefault(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                store.setDefault(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                store.setDefault(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                store.setDefault(key, ((Float)value).floatValue());
                continue;
            }
            store.setDefault(key, value.toString());
        }
    }
}

