/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.inventory.profile;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.barcode.reader.inventory.profile.service.BarcodeReaderInventoryProfileService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class BarcodeReaderInventoryProfile
extends RfidInventoryProfile
implements ProfileService,
BarcodeReaderInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.barcode.reader.inventory.profile.BarcodeReaderInventoryProfile";
    protected SignalService barcodeReaderDeviceServiceBarcodeReport;
    private AdapterService adapter;
    protected boolean reading = false;

    public BarcodeReaderInventoryProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null && this.barcodeReaderDeviceServiceBarcodeReport != null) {
            this.barcodeReaderDeviceServiceBarcodeReport.removeSignalListener((SignalListener)this);
        }
        if (device != null) {
            this.barcodeReaderDeviceServiceBarcodeReport = device.getSignal("BarcodeReport");
            this.initializeSignal(this.barcodeReaderDeviceServiceBarcodeReport);
        }
        super.setDevice(device);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.barcodeReaderDeviceServiceBarcodeReport == source) {
            this.handleBarcodeReaderDeviceServiceBarcodeReport(source, timestamp, data);
            return;
        }
        super.signalOccurred(source, timestamp, data);
    }

    public String getDefaultKey() {
        return "BarcodeReaderInventoryProfile";
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)BarcodeReaderInventoryProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.barcode.reader.device.BarcodeReaderDevice");
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    private void initialize() {
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    protected boolean autonomousModeOff() {
        this.setReading(false);
        return false;
    }

    protected boolean autonomousModeOn() {
        this.setReading(true);
        return false;
    }

    public void handleBarcodeReaderDeviceServiceBarcodeReport(SignalService source, Object timestamp, Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Map value = (Map)entry.getValue();
                value.put("reader", this.getId());
                value.put("timestampFirst", timestamp);
                value.put("timestampLast", timestamp);
                value.put("count", BarcodeReaderInventoryProfile.createInteger((int)1));
                value.put("tagType", "barcode");
            }
            this.notifyTagRead(map);
        } else {
            this.tagReport.fireErrorOccurred(timestamp, data);
        }
    }

    public boolean isReading() {
        return this.reading;
    }

    public void setReading(boolean reading) {
        this.reading = reading;
    }
}

