/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection;

import java.io.IOException;
import java.util.Dictionary;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.connection.ConnectionResourceBundle;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;

public abstract class Connection
extends EscObject
implements ConnectionService {
    protected static final int OPEN_RESOURCE = 1001;
    protected static final int CLOSE_RESOURCE = 1002;
    protected static final int CLOSED_RESOURCE = 1003;
    protected static final int OPENFAILED_RESOURCE = 1004;
    protected static final int READ_BYTES_RESOURCE = 1005;
    protected static final int WRITE_BYTES_RESOURCE = 1006;
    protected static final int CLIENT_WAIT_RESOURCE = 1007;
    protected static final int CHANNEL_DEAD_STATE_RESOURCE = 1008;
    protected static final int CHANNEL_CREATED_STATE_RESOURCE = 1009;
    public static final int CHANNEL_ALIVE_STATE_RESOURCE = 1010;
    public static final int CHANNEL_CONNECTED_STATE_RESOURCE = 1011;
    protected static final int CHANNEL_ACTIVE_STATE_RESOURCE = 1012;
    protected static final int CHANNEL_STARTED_STATE_RESOURCE = 1013;
    public static final int CHANNEL_OPENFAILED_RESOURCE = 1014;
    public static final int CHANNEL_CLOSED_RESOURCE = 1015;
    protected static final int CHANNEL_OPEN = 1016;
    protected static final int CHANNEL_READ_BYTES_RESOURCE = 1017;
    protected static final int CHANNEL_WRITE_BYTES_RESOURCE = 1018;
    private static ResourceBundle DefaultResourceBundle;
    private boolean isOpen = false;
    protected ConfigurationService configurationService = null;
    protected long readByteCount = 0L;
    protected long writeByteCount = 0L;
    protected int logLevel = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.connection.ConnectionResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public static String getDefaultResource(int resourceId) {
        return DefaultResourceBundle.getString(ConnectionResourceBundle.getKey(resourceId));
    }

    protected Connection() {
    }

    protected Connection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
    }

    protected Connection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        if (errorNumber == 1004) {
            return false;
        }
        return super.attemptRecoveryFromError(errorNumber, error);
    }

    public void close() throws IOException {
        this.setOpen(false);
    }

    public void exit() throws IOException {
        this.close();
    }

    protected void finalize() throws Throwable {
        this.exit();
    }

    public void flush() throws IOException {
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 1005: 
            case 1006: {
                return 5;
            }
            case 1001: 
            case 1002: {
                return 3;
            }
            case 1003: 
            case 1004: 
            case 1007: {
                return 4;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public Object getLogDetails4() {
        return String.valueOf((Object)this);
    }

    public Object getLogDetails5() {
        return String.valueOf(this.getOutputName());
    }

    public int getLogLevel() {
        if (this.logLevel == 0) {
            return super.getLogLevel();
        }
        return this.logLevel;
    }

    public long getReadByteCount() {
        return this.readByteCount;
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(ConnectionResourceBundle.getKey(resourceId));
        }
        catch (RuntimeException runtimeException) {
            return super.getResource(resourceId);
        }
    }

    public long getWriteByteCount() {
        return this.writeByteCount;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized void open() throws IOException {
        this.setOpen(true);
        this.report(null, 1001, this.getConfigurationService());
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        if (configurationInformation != null) {
            this.configurationService = new EscConfiguration(configurationInformation);
            this.setLogLevel(this.getInt("loglevel", 0));
        } else {
            this.configurationService = null;
        }
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public void setReadByteCount(long readCount) {
        this.readByteCount = readCount;
    }

    public void setWriteByteCount(long writeCount) {
        this.writeByteCount = writeCount;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(",open=");
        buffer.append(this.isOpen());
        if (this.getReadByteCount() > 0L) {
            buffer.append(",readbytecount=");
            buffer.append(this.getReadByteCount());
        }
        if (this.getWriteByteCount() > 0L) {
            buffer.append(",writebytecount=");
            buffer.append(this.getWriteByteCount());
        }
    }

    public void updateReadByteCount(long readCount) {
        this.readByteCount += readCount;
    }

    public void updateWriteByteCount(long writeCount) {
        this.writeByteCount += writeCount;
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }
}

