/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection;

import java.io.IOException;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.nls.Nls;

public class TraceConnection
extends Connection
implements ConnectionService {
    private ConnectionService connectionService;

    public TraceConnection(ConnectionService connectionService) {
        this.setConnectionService(connectionService);
    }

    public synchronized void close() throws IOException {
        this.connectionService.close();
    }

    public void exit() throws IOException {
        if (this.connectionService != null) {
            this.connectionService.exit();
            this.connectionService = null;
        }
    }

    public void flush() throws IOException {
        this.connectionService.flush();
    }

    public ConnectionService getConnectionService() {
        return this.connectionService;
    }

    public boolean isOpen() {
        return this.connectionService.isOpen();
    }

    public void open() throws IOException {
        this.connectionService.open();
    }

    public int read(byte[] bytes) throws IOException {
        int result = this.connectionService.read(bytes);
        if (result > 0 && TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)result);
            this.report(null, 1005, details);
        }
        return result;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int result = this.connectionService.read(bytes, offset, length);
        if (result > 0 && TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)result);
            this.report(null, 1005, details);
        }
        return result;
    }

    public void setConnectionService(ConnectionService connectionService) throws IllegalArgumentException {
        if (connectionService == null) {
            throw new IllegalArgumentException();
        }
        this.connectionService = connectionService;
    }

    public String toString() {
        if (this.connectionService != null) {
            return this.connectionService.toString();
        }
        return super.toString();
    }

    public void write(byte[] bytes) throws IOException {
        this.connectionService.write(bytes);
        if (TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
            this.report(null, 1006, details);
        }
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
        this.connectionService.write(bytes, offset, count);
        if (TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)count);
            this.report(null, 1006, details);
        }
    }
}

