/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class BitOffsetParameter
extends Parameter {
    public static final int[] MASKS = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private int offset;

    public BitOffsetParameter(String key, int offset) {
        this(key, null, offset, BitOffsetParameter.getDefaultStyle());
    }

    public BitOffsetParameter(String key, int offset, short style) {
        this(key, null, offset, style);
    }

    public BitOffsetParameter(String key, TransformService transform, int offset, short style) {
        super(key, transform, style);
        this.setOffset(offset);
    }

    protected Object decodeMessage(MessageService message, ParameterCursorService cursor) {
        int returnValue = 0;
        int startOffset = this.getOffset() % 8;
        if (this.isLittleEndian()) {
            returnValue = message.getByte(this.getIndex() + this.getSize() - 1) & this.getMask();
            int i = this.getSize() - 2;
            while (i >= 0) {
                returnValue <<= 8;
                returnValue += message.getByte(this.getIndex() + i) & 0xFF;
                --i;
            }
        } else {
            returnValue = startOffset == 0 ? message.getByte(this.getIndex()) & this.getMask() : (this.isUnsigned() ? message.getByte(this.getIndex()) & MASKS[startOffset] : (byte)(message.getByte(this.getIndex()) << startOffset) >> startOffset);
            int endOffset = (this.getOffset() + this.getLength()) % 8;
            int size = this.getSize();
            if (endOffset > 0) {
                --size;
            }
            int i = 1;
            while (i < size) {
                returnValue <<= 8;
                returnValue += message.getByte(this.getIndex() + i) & 0xFF;
                ++i;
            }
            if (endOffset > 0) {
                if (endOffset > startOffset) {
                    returnValue >>= 8 - endOffset;
                } else {
                    returnValue <<= endOffset;
                    int temp = message.getByte(this.getIndex() + this.getSize()) & 0xFF;
                    returnValue += (temp >>= 8 - endOffset);
                }
            }
        }
        return EscObject.createInteger(returnValue);
    }

    public MessageService encodeMessage(MessageService message, Object value, int offset, ParameterCursorService cursor) {
        if (value instanceof Number) {
            int startOffset = this.getOffset() % 8;
            int endOffset = startOffset + this.getLength();
            int tempValue = ((Number)value).intValue();
            int temp = message.getByte(this.getIndex());
            int shift = 8 - endOffset;
            tempValue &= MASKS[8 - this.getLength()];
            if (shift > 0) {
                tempValue <<= shift;
            }
            int mask = MASKS[8 - shift];
            message.setByte(this.getIndex(), (byte)(tempValue |= (temp &= (mask |= ~MASKS[startOffset]))));
        }
        return message;
    }

    protected int getIndex() {
        return this.getOffset() >> 3;
    }

    public int getLength() {
        return 1;
    }

    protected int getMask() {
        if (this.isUnsigned()) {
            return 255;
        }
        return -1;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected int getSize() {
        return this.getLength() + 7 >> 3;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }
}

