/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.factory;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.factory.CoreFactory;
import org.eclipse.soda.dk.device.Container;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class DeviceFactory
extends CoreFactory
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        this.validateConfigurationIds(pid, properties);
        String interestServiceName = this.getInterestServiceName();
        TransportService transport = interestServiceName != null && interestServiceName.length() > 0 ? (TransportService)manager.getImportedService(interestServiceName) : null;
        DeviceService device = this.createService(transport);
        if (device != null) {
            if (device instanceof Device) {
                ((Container)device).setBundleContext(this.getBundleContext());
            }
            device.setConfigurationInformation(properties);
            Object notificationService = manager.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService");
            if (notificationService instanceof NotificationService) {
                device.setNotificationService((NotificationService)notificationService);
            }
            try {
                device.start();
            }
            catch (RuntimeException exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, null, properties, manager), (Object)device, (Dictionary)serviceProperties);
        }
        return device;
    }

    public abstract DeviceService createService(TransportService var1);

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            DeviceService device = (DeviceService)object;
            device.exit();
            int count = 0;
            while (count < 20 && device.getState() != 0) {
                Thread.sleep(100L);
                ++count;
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        super.destroy(pid, object, properties, manager);
    }

    public String getInterestServiceName() {
        return this.getTransportServiceName();
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return OPTIONAL_SERVICES;
    }

    public String getServiceName() {
        return DeviceService.SERVICE_NAME;
    }

    public String getTransportServiceName() {
        return "";
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof DeviceService) {
            DeviceService device = (DeviceService)object;
            if (importedService instanceof NotificationService) {
                device.setNotificationService((NotificationService)importedService);
            }
        }
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof DeviceService) {
            DeviceService device = (DeviceService)object;
            if (importedService instanceof NotificationService) {
                device.setNotificationService(null);
            }
        }
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        DeviceService device = (DeviceService)object;
        int compareLevel = this.compare(oldProperties, properties, this.getMinorProperties());
        switch (compareLevel) {
            case 0: {
                return object;
            }
            case 1: {
                device.setConfigurationInformation(properties);
                return object;
            }
            case 2: {
                try {
                    manager.removeExportedService(this.getServiceName(), object);
                    Thread.yield();
                    device.exit();
                }
                catch (Exception e) {
                    EscObject.handleStaticException((Throwable)e);
                }
                return this.create(pid, properties, manager);
            }
        }
        return object;
    }
}

