/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.CommandListeners;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Command
extends Control
implements CommandService,
SignalListener,
MeasurementListener {
    private transient CommandListener commandListener;

    public Command(String key) {
        super(key);
    }

    public synchronized void addCommandListener(CommandListener commandListener) {
        this.setCommandListener(CommandListeners.add(this.getCommandListener(), commandListener));
    }

    public void execute() {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireCommandExecuted(commandListener, Command.getCurrentTimestamp());
        }
    }

    public void execute(Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireCommandExecuted(commandListener, EscObject.getCurrentTimestamp(), data);
        }
    }

    public void fireCommandExecuted(CommandListener commandListener, Object timestamp) {
        try {
            commandListener.commandExecuted((CommandService)this, timestamp, null);
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireCommandExecuted(CommandListener commandListener, Object timestamp, Object data) {
        try {
            commandListener.commandExecuted((CommandService)this, timestamp, data);
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 1);
        }
    }

    protected void fireErrorOccurred(CommandListener commandListener, Object timestamp, Object data) {
        try {
            commandListener.errorOccurred((Object)this, timestamp, data);
        }
        catch (RuntimeException exception) {
            this.log(exception, 1);
        }
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireErrorOccurred(commandListener, Command.getCurrentTimestamp(), data);
        }
    }

    public CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.execute(newValue);
    }

    public synchronized void removeCommandListener(CommandListener commandListener) {
        this.setCommandListener(CommandListeners.remove(this.getCommandListener(), commandListener));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        super.reportError(errorNumber, error, errorObjects);
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireErrorOccurred(commandListener, Command.getCurrentTimestamp(), error);
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.execute();
    }
}

