/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.measurement.UnitsMeasurement;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class DataMeasurement
extends UnitsMeasurement {
    private TransformService transform;

    public DataMeasurement(String key, Object value, UnitsService units, TransformService transform) {
        super(key, value, units);
        this.setTransform(transform);
    }

    public TransformService getTransform() {
        return this.transform;
    }

    public void setRawValue(Object value, Object timestamp) {
        try {
            TransformService transform = this.getTransform();
            if (transform == null) {
                this.setValue(value, timestamp);
            } else {
                this.setValue(transform.decode(value), timestamp);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 3018);
        }
    }

    protected void setTransform(TransformService transform) {
        this.transform = transform;
    }
}

