/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;

public class MeasurementFieldMeasurement
extends Measurement
implements MeasurementListener {
    protected String fieldName = "";
    protected MeasurementService measurement;

    public MeasurementFieldMeasurement(String key) {
        super(key);
    }

    public MeasurementFieldMeasurement(String key, Object value, MeasurementService measurement, String fieldName) {
        super(key);
        this.setMeasurement(measurement);
        this.setFieldName(fieldName);
        this.setValue(value, MeasurementFieldMeasurement.getCurrentTimestamp());
    }

    public MeasurementFieldMeasurement(String key, MeasurementService measurement, String fieldName) {
        super(key);
        this.setMeasurement(measurement);
        this.setFieldName(fieldName);
    }

    public MeasurementFieldMeasurement(String key, Object value) {
        super(key, value);
    }

    public void executeRead() {
        if (this.getMeasurement() != null) {
            this.getMeasurement().executeRead();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MeasurementService getMeasurement() {
        return this.measurement;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        Map map;
        Object value;
        if (newValue instanceof Map && (value = (map = (Map)newValue).get(this.getFieldName())) != null) {
            this.setValue(value, timestamp);
        }
    }

    public Object read(long timeout) {
        if (this.getMeasurement() != null) {
            this.getMeasurement().read(timeout);
        }
        return super.read(timeout);
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setMeasurement(MeasurementService measurement) {
        if (this.measurement != null) {
            this.measurement.removeMeasurementListener((MeasurementListener)this);
        }
        this.measurement = measurement;
        if (this.measurement != null) {
            this.measurement.addMeasurementListener((MeasurementListener)this);
        }
    }

    public void setValue(Object value, Object timestamp) {
        Object currentValue = this.getValue();
        if (this.equalsValue(currentValue, value)) {
            this.setTimestamp(timestamp);
        } else {
            String key;
            Map map;
            Object currentMapValue;
            Object currentParentValue;
            super.setValue(value, timestamp);
            if (this.measurement != null && (currentParentValue = this.measurement.getValue()) instanceof Map && !this.equalsValue(currentMapValue = (map = (Map)currentParentValue).get(key = this.getKey()), value)) {
                HashMap<String, Object> mapNew = new HashMap<String, Object>(map);
                mapNew.put(key, value);
                if (this.measurement instanceof Measurement) {
                    ((Measurement)this.measurement).setValue(value, timestamp);
                } else {
                    this.measurement.setValue(mapNew);
                }
            }
        }
    }
}

