/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;

public class ParameterFactory {
    public static final Map ROSPECID_REPOSITORY = new HashMap();
    public static Map ACESSSPECID_REPOSITORY = new HashMap();
    public static Map ADDACCESSSPECCOMMAND_REPOSITORY = new HashMap();
    public static Map ADDROSPECCOMMAND_REPOSITORY = new HashMap();

    public static Map getAISpecParameter(int[] antennaIds, Map aISpecStopTriggerParameter, List inventoryParameterSpecParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Vector<Integer> antennaIdList = new Vector<Integer>();
        int i = 0;
        while (i < antennaIds.length) {
            antennaIdList.add(EscObject.createInteger((int)antennaIds[i]));
            ++i;
        }
        parameters.put("AntennaIDs", antennaIdList);
        parameters.put("AISpecStopTriggerParameter", aISpecStopTriggerParameter);
        parameters.put("InventoryParameterSpecParameter", inventoryParameterSpecParameters);
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("AISpecParameter", parameters);
        return result;
    }

    public static Map getAISpecStopTriggerParameter(int type, int duration, Map gPITriggerValueParameter, Map tagObservationTriggerParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("AISpecStopTriggerType", EscObject.createInteger((int)type));
        parameters.put("DurationTrigger", EscObject.createInteger((int)duration));
        if (gPITriggerValueParameter != null) {
            parameters.put("GPITriggerValueParameter", gPITriggerValueParameter);
        }
        if (tagObservationTriggerParameter != null) {
            parameters.put("TagObservationTriggerParameter", tagObservationTriggerParameter);
        }
        return parameters;
    }

    public static Map getAccessCommandParameter(List airProtocolTagSpecChoice, List accessCommandOpSpecChoice) {
        HashMap<String, List> parameters = new HashMap<String, List>();
        parameters.put("AirProtocolTagSpecChoice", airProtocolTagSpecChoice);
        parameters.put("AccessCommandOpSpecChoice", accessCommandOpSpecChoice);
        return parameters;
    }

    public static Map getAccessCommandParameter(Map airProtocolTagSpecChoice, List accessCommandOpSpecChoiceList) {
        ArrayList<Map> airProtocolTagSpecChoiceList = new ArrayList<Map>();
        airProtocolTagSpecChoiceList.add(airProtocolTagSpecChoice);
        return ParameterFactory.getAccessCommandParameter(airProtocolTagSpecChoiceList, accessCommandOpSpecChoiceList);
    }

    public static Map getAccessCommandParameter(Map airProtocolTagSpecChoice, Map accessCommandOpSpecChoice) {
        ArrayList<Map> airProtocolTagSpecChoiceList = new ArrayList<Map>();
        airProtocolTagSpecChoiceList.add(airProtocolTagSpecChoice);
        ArrayList<Map> accessCommandOpSpecChoiceList = new ArrayList<Map>();
        accessCommandOpSpecChoiceList.add(accessCommandOpSpecChoice);
        return ParameterFactory.getAccessCommandParameter(airProtocolTagSpecChoiceList, accessCommandOpSpecChoiceList);
    }

    public static Map getAccessReportSpecParameter(int accessReportTrigger) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("AccessReportTrigger", EscObject.createInteger((int)accessReportTrigger));
        return parameters;
    }

    public static Map getAccessSpecIDParameter(int accessSpecId) {
        Map accessSpecIdMap = (Map)ACESSSPECID_REPOSITORY.get(EscObject.createInteger((int)accessSpecId));
        if (accessSpecIdMap != null) {
            return accessSpecIdMap;
        }
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("AccessSpecID", EscObject.createInteger((int)accessSpecId));
        ACESSSPECID_REPOSITORY.put(EscObject.createInteger((int)accessSpecId), parameters);
        return parameters;
    }

    public static Map getAccessSpecParameter(int accessSpecId, int antennaId, int protocolId, int currentState, int ROSpecId, Map accessSpecStopTriggerParameter, Map accessCommandParameter, Map accessReportSpecParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("AccessSpecID", EscObject.createInteger((int)accessSpecId));
        parameters.put("AntennaID", EscObject.createInteger((int)antennaId));
        parameters.put("ProtocolID", EscObject.createInteger((int)protocolId));
        parameters.put("AccessSpec_CurrentState", EscObject.createInteger((int)currentState));
        parameters.put("ROSpecID", EscObject.createInteger((int)ROSpecId));
        parameters.put("AccessSpecStopTriggerParameter", accessSpecStopTriggerParameter);
        parameters.put("AccessCommandParameter", accessCommandParameter);
        if (accessReportSpecParameter != null) {
            parameters.put("AccessReportSpecParameter", accessReportSpecParameter);
        }
        return parameters;
    }

    public static Map getAccessSpecStopTriggerParameter(int accessSpecStopTrigger, int operationCountValue) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("AccessSpecStopTrigger", EscObject.createInteger((int)accessSpecStopTrigger));
        parameters.put("OperationCountValue", EscObject.createInteger((int)operationCountValue));
        return parameters;
    }

    public static Map getAddAccessSpecCommandParameters(int accessSpecId, int antennaId, int protocolId, int currentState, int rospecId, Map accessSpecStopTriggerParameter, Map accessCommandParameter, Map accessReportSpecParameter) {
        return ParameterFactory.getAddAccessSpecCommandParameters(ParameterFactory.getAccessSpecParameter(accessSpecId, antennaId, protocolId, currentState, rospecId, accessSpecStopTriggerParameter, accessCommandParameter, accessReportSpecParameter));
    }

    public static Map getAddAccessSpecCommandParameters(Map accessSpecParameter) {
        Map addAccessSpecCommandParam = (Map)ADDACCESSSPECCOMMAND_REPOSITORY.get(accessSpecParameter);
        if (addAccessSpecCommandParam != null) {
            return addAccessSpecCommandParam;
        }
        HashMap<String, Map> parameters = new HashMap<String, Map>();
        parameters.put("AccessSpecParameter", accessSpecParameter);
        ADDACCESSSPECCOMMAND_REPOSITORY.put(accessSpecParameter, parameters);
        return parameters;
    }

    public static Map getAddROSpecCommandParameters(int rospecId, int priority, int currentState, Map rOBoundarySpecParameter, List specParameterChoice, Map rOReportSpecParameter) {
        return ParameterFactory.getAddROSpecCommandParameters(ParameterFactory.getROSpecParameter(rospecId, priority, currentState, rOBoundarySpecParameter, specParameterChoice, rOReportSpecParameter));
    }

    public static Map getAddROSpecCommandParameters(Map roSpecParameter) {
        Map addROSpecCommandParam = (Map)ADDROSPECCOMMAND_REPOSITORY.get(roSpecParameter);
        if (addROSpecCommandParam != null) {
            return addROSpecCommandParam;
        }
        HashMap<String, Map> parameters = new HashMap<String, Map>();
        parameters.put("ROSpecParameter", roSpecParameter);
        ADDROSPECCOMMAND_REPOSITORY.put(roSpecParameter, parameters);
        return parameters;
    }

    public static Map getAntennaConfigurationParameter(int antennaId, Map rFReceiverParameter, Map rFTransmitterParameter, List airProtocolnventoryCommandSettingsParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("AntennaID", EscObject.createInteger((int)antennaId));
        if (rFReceiverParameter != null) {
            parameters.put("RFReceiverParameter", rFReceiverParameter);
        }
        if (rFTransmitterParameter != null) {
            parameters.put("RFTransmitterParameter", rFTransmitterParameter);
        }
        if (airProtocolnventoryCommandSettingsParameter != null) {
            parameters.put("AirProtocolInventoryCommandSettingsChoice", airProtocolnventoryCommandSettingsParameter);
        }
        return parameters;
    }

    public static Map getC1G2BlockEraseParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, int wordCount) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        parameters.put("AccessPassword", EscObject.createInteger((int)accessPassword));
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("WordPointer", EscObject.createInteger((int)wordPointer));
        parameters.put("WordCount", EscObject.createInteger((int)wordCount));
        HashMap<String, HashMap<String, Integer>> result = new HashMap<String, HashMap<String, Integer>>();
        result.put("C1G2BlockEraseParameter", parameters);
        return result;
    }

    public static Map getC1G2BlockWriteParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, String writeData) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        parameters.put("AccessPassword", EscObject.createInteger((int)accessPassword));
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("WordPointer", EscObject.createInteger((int)wordPointer));
        parameters.put("WriteDatas", LLRPUtils.str2wordList(writeData));
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("C1G2BlockWriteParameter", parameters);
        return result;
    }

    public static Map getC1G2EPCMemorySelectorParameter(int enableCRC, int enablePCBits) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("EnableCRC", EscObject.createInteger((int)enableCRC));
        parameters.put("EnablePCBits", EscObject.createInteger((int)enablePCBits));
        HashMap<String, HashMap<String, Integer>> result = new HashMap<String, HashMap<String, Integer>>();
        result.put("C1G2EPCMemorySelectorParameter", parameters);
        return result;
    }

    public static Map getC1G2FilterParameter(int truncate, Map c1G2TagInventoryMaskParameter, Map c1G2TagInventoryStateAwareFilterActionParameter, Map c1G2TagInventoryStateUnawareFilterActionParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("C1G2Filter_T", EscObject.createInteger((int)truncate));
        parameters.put("C1G2TagInventoryMaskParameter", c1G2TagInventoryMaskParameter);
        if (c1G2TagInventoryStateAwareFilterActionParameter != null) {
            parameters.put("C1G2TagInventoryStateAwareFilterActionParameter", c1G2TagInventoryStateAwareFilterActionParameter);
        }
        if (c1G2TagInventoryStateUnawareFilterActionParameter != null) {
            parameters.put("C1G2TagInventoryStateUnawareFilterActionParameter", c1G2TagInventoryStateUnawareFilterActionParameter);
        }
        return parameters;
    }

    public static Map getC1G2FilterParameter(Map c1G2TagInventoryMaskParameter) {
        return ParameterFactory.getC1G2FilterParameter(1, c1G2TagInventoryMaskParameter, null, null);
    }

    public static Map getC1G2InventoryCommandParameter(boolean tagInventoryStateAware, List c1G2FilterParameters, Map c1G2RFControlParameter, Map c1G2SingulationControlParameter, List customParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("TagInventoryStateAware", tagInventoryStateAware ? Boolean.TRUE : Boolean.FALSE);
        if (c1G2FilterParameters != null) {
            parameters.put("C1G2FilterParameter", c1G2FilterParameters);
        }
        if (c1G2RFControlParameter != null) {
            parameters.put("C1G2RFControlParameter", c1G2RFControlParameter);
        }
        if (c1G2SingulationControlParameter != null) {
            parameters.put("C1G2SingulationControlParameter", c1G2SingulationControlParameter);
        }
        if (customParameters != null) {
            parameters.put("CustomParameter", customParameters);
        }
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("C1G2InventoryCommandParameter", parameters);
        return result;
    }

    public static Map getC1G2InventoryCommandParameter(List c1G2FilterParameters) {
        return ParameterFactory.getC1G2InventoryCommandParameter(false, c1G2FilterParameters, null, null, null);
    }

    public static Map getC1G2KillParameter(int OpSpecId, int killPassword) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        parameters.put("KillPassword", EscObject.createInteger((int)killPassword));
        HashMap<String, HashMap<String, Integer>> result = new HashMap<String, HashMap<String, Integer>>();
        result.put("C1G2KillParameter", parameters);
        return result;
    }

    public static Map getC1G2LockParameter(int OpSpecId, int accessPassword, List c1g2LockPayload) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        parameters.put("AccessPassword", EscObject.createInteger((int)accessPassword));
        parameters.put("C1G2LockPayloadParameter", c1g2LockPayload);
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("C1G2LockParameter", parameters);
        return result;
    }

    public static Map getC1G2LockPayloadParameter(int privilege, int datafield) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("Privilege", EscObject.createInteger((int)privilege));
        parameters.put("DataField", EscObject.createInteger((int)datafield));
        return parameters;
    }

    public static Map getC1G2ReadParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, int wordCount) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        parameters.put("AccessPassword", EscObject.createInteger((int)accessPassword));
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("WordPointer", EscObject.createInteger((int)wordPointer));
        parameters.put("WordCount", EscObject.createInteger((int)wordCount));
        HashMap<String, HashMap<String, Integer>> result = new HashMap<String, HashMap<String, Integer>>();
        result.put("C1G2ReadParameter", parameters);
        return result;
    }

    public static Map getC1G2TagInventoryMaskParameter(int memoryBank, int pointer, byte[] tagMask) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("Pointer", EscObject.createInteger((int)pointer));
        parameters.put("TagMask", tagMask);
        return parameters;
    }

    public static Map getC1G2TagSpecParameter() {
        return ParameterFactory.getC1G2TagSpecParameter(ParameterFactory.getC1G2TargetTagParameter(1, true, 32, "00,00,00,00,00,00,00,00,00,00,00,00", "00,00,00,00,00,00,00,00,00,00,00,00"));
    }

    public static Map getC1G2TagSpecParameter(Map c1G2TargetTagParameter) {
        HashMap<String, Map> parameters = new HashMap<String, Map>();
        parameters.put("C1G2TargetTagParameter", c1G2TargetTagParameter);
        HashMap<String, HashMap<String, Map>> result = new HashMap<String, HashMap<String, Map>>();
        result.put("C1G2TagSpecParameter", parameters);
        return result;
    }

    public static Map getC1G2TagSpecParameter(Map c1G2TargetTagParameter, Map c1G2TargetTagParameter2) {
        HashMap<String, Map> parameters = new HashMap<String, Map>();
        parameters.put("C1G2TargetTagParameter", c1G2TargetTagParameter);
        parameters.put("C1G2TargetTagParameter2", c1G2TargetTagParameter2);
        HashMap<String, HashMap<String, Map>> result = new HashMap<String, HashMap<String, Map>>();
        result.put("C1G2TagSpecParameter", parameters);
        return result;
    }

    public static Map getC1G2TargetTagParameter(int memoryBank, boolean match, int pointer, String tagMask, String tagData) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("Match", match ? EscObject.createInteger((int)1) : EscObject.createInteger((int)0));
        parameters.put("Pointer", EscObject.createInteger((int)pointer));
        if (ParameterFactory.isAllZeroString(tagMask) && ParameterFactory.isAllZeroString(tagData)) {
            parameters.put("TagMask", LLRPUtils.str2byteArray(""));
            parameters.put("TagData", LLRPUtils.str2byteArray(""));
        } else {
            parameters.put("TagMask", LLRPUtils.str2byteArray(tagMask));
            parameters.put("TagData", LLRPUtils.str2byteArray(tagData));
        }
        return parameters;
    }

    public static Map getC1G2WriteParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, String writeData) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        parameters.put("AccessPassword", EscObject.createInteger((int)accessPassword));
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("WordPointer", EscObject.createInteger((int)wordPointer));
        parameters.put("WriteDatas", LLRPUtils.str2wordList(writeData));
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("C1G2WriteParameter", parameters);
        return result;
    }

    public static Map getC1G2WriteParameterAddId(int OpSpecId, Map c1G2WriteParameterNoId) {
        Map parameters = (Map)c1G2WriteParameterNoId.get("C1G2WriteParameter");
        parameters.put("OpSpecID", EscObject.createInteger((int)OpSpecId));
        return c1G2WriteParameterNoId;
    }

    public static Map getC1G2WriteParameterNoId(int accessPassword, int memoryBank, int wordPointer, String writeData) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("AccessPassword", EscObject.createInteger((int)accessPassword));
        parameters.put("MB", EscObject.createInteger((int)memoryBank));
        parameters.put("WordPointer", EscObject.createInteger((int)wordPointer));
        parameters.put("WriteDatas", LLRPUtils.str2wordList(writeData));
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("C1G2WriteParameter", parameters);
        return result;
    }

    public static Map getEventNotificationStateParameter(int eventType, boolean enable) {
        HashMap<String, Constable> parameters = new HashMap<String, Constable>();
        parameters.put("EventNotificationState_EventType", EscObject.createInteger((int)eventType));
        parameters.put("NotificationState", enable ? Boolean.TRUE : Boolean.FALSE);
        return parameters;
    }

    public static Map getGPIPortCurrentStateParameter(int gpiPortNum, boolean enable) {
        HashMap<String, Constable> parameters = new HashMap<String, Constable>();
        parameters.put("GPIPortNum", EscObject.createInteger((int)gpiPortNum));
        parameters.put("Config", enable ? Boolean.TRUE : Boolean.FALSE);
        parameters.put("State", EscObject.createInteger((int)0));
        return parameters;
    }

    public static Map getGPOWriteDataParameter(int gpoPortNum, boolean gpoPortState) {
        HashMap<String, Constable> parameters = new HashMap<String, Constable>();
        parameters.put("GPOPortNumber", EscObject.createInteger((int)gpoPortNum));
        parameters.put("GPOData", gpoPortState ? Boolean.TRUE : Boolean.FALSE);
        return parameters;
    }

    public static Map getInventoryParameterSpecParameter(int inventoryParameterSpecID, int protocolID) {
        return ParameterFactory.getInventoryParameterSpecParameter(inventoryParameterSpecID, protocolID, null);
    }

    public static Map getInventoryParameterSpecParameter(int inventoryParameterSpecID, int protocolID, List antennaConfigurationParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("InventoryParameterSpecID", EscObject.createInteger((int)inventoryParameterSpecID));
        parameters.put("ProtocolID", EscObject.createInteger((int)protocolID));
        if (antennaConfigurationParameters != null) {
            parameters.put("AntennaConfigurationParameter", antennaConfigurationParameters);
        }
        return parameters;
    }

    public static Map getROBoundarySpecParameter(Map rOSpecStartTriggerParameter, Map ROSpecStopTriggerParameter) {
        HashMap<String, Map> parameters = new HashMap<String, Map>();
        parameters.put("ROSpecStartTriggerParameter", rOSpecStartTriggerParameter);
        parameters.put("ROSpecStopTriggerParameter", ROSpecStopTriggerParameter);
        return parameters;
    }

    public static Map getROReportSpecParameter(int trigger, int tagNum, Map tagReportContentSelectorParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ROReportTrigger", EscObject.createInteger((int)trigger));
        parameters.put("ROReportSpec_N", EscObject.createInteger((int)tagNum));
        parameters.put("TagReportContentSelectorParameter", tagReportContentSelectorParameter);
        return parameters;
    }

    public static Map getROSpecIDParameter(int rospecId) {
        Map roSpecIdMap = (Map)ROSPECID_REPOSITORY.get(EscObject.createInteger((int)rospecId));
        if (roSpecIdMap != null) {
            return roSpecIdMap;
        }
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("ROSpecID", EscObject.createInteger((int)rospecId));
        ROSPECID_REPOSITORY.put(EscObject.createInteger((int)rospecId), parameters);
        return parameters;
    }

    public static Map getROSpecParameter(int rospecId, int priority, int currentState, Map rOBoundarySpecParameter, List specParameterChoice, Map rOReportSpecParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ROSpecID", EscObject.createInteger((int)rospecId));
        parameters.put("Priority", EscObject.createInteger((int)priority));
        parameters.put("ROSpec_CurrentState", EscObject.createInteger((int)currentState));
        parameters.put("ROBoundarySpecParameter", rOBoundarySpecParameter);
        parameters.put("SpecParameterChoice", specParameterChoice);
        if (rOReportSpecParameter != null) {
            parameters.put("ROReportSpecParameter", rOReportSpecParameter);
        }
        return parameters;
    }

    public static Map getROSpecStartTriggerParameter(int type) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("ROSpecStartTriggerType", EscObject.createInteger((int)type));
        return parameters;
    }

    public static Map getROSpecStopTriggerParameter(int type, int duration) {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("ROSpecStopTriggerType", EscObject.createInteger((int)type));
        parameters.put("DurationTriggerValue", EscObject.createInteger((int)duration));
        return parameters;
    }

    public static Map getReaderEventNotificationSpecParameter(List eventNotificationStates) {
        HashMap<String, List> parameters = new HashMap<String, List>();
        parameters.put("EventNotificationStateParameter", eventNotificationStates);
        return parameters;
    }

    public static Map getSetGPOWriteDataParameter(List gpoWriteDatas) {
        HashMap<String, List> parameters = new HashMap<String, List>();
        parameters.put("GPOWriteDataParameter", gpoWriteDatas);
        return parameters;
    }

    public static Map getSetReaderConfig_ReaderEventNotificationSpecParameter(boolean reset, Map readerEventNotificationSpecParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ResetToFactoryDefault", reset ? Boolean.TRUE : Boolean.FALSE);
        parameters.put("ReaderEventNotificationSpecParameter", readerEventNotificationSpecParameter);
        return parameters;
    }

    public static Map getSetReaderGPICurrentStateParameter(boolean reset, List gpiCurrentStates) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ResetToFactoryDefault", reset ? Boolean.TRUE : Boolean.FALSE);
        parameters.put("GPIPortCurrentStateParameter", gpiCurrentStates);
        return parameters;
    }

    public static Map getTagReportContentSelectorParameter() {
        ArrayList<Map> airProtocolEPCMemorySelectorChoice = new ArrayList<Map>();
        airProtocolEPCMemorySelectorChoice.add(ParameterFactory.getC1G2EPCMemorySelectorParameter(1, 1));
        return ParameterFactory.getTagReportContentSelectorParameter(1, 1, 1, 1, 1, 1, 1, 1, 1, airProtocolEPCMemorySelectorChoice);
    }

    public static Map getTagReportContentSelectorParameter(int enableROSpecID, int enableSpecIndex, int enableInventoryParameterSpecID, int enableChannelIndex, int enablePeakRSSI, int enableFirstSeenTimestamp, int enableLastSeenTimestamp, int enableTagSeenCount, int enableAccessSpecID, List airProtocolEPCMemorySelectorChoice) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("EnableROSpecID", EscObject.createInteger((int)enableROSpecID));
        parameters.put("EnableSpecIndex", EscObject.createInteger((int)enableSpecIndex));
        parameters.put("EnableInventoryParameterSpecID", EscObject.createInteger((int)1));
        parameters.put("EnableAntennaID", EscObject.createInteger((int)enableInventoryParameterSpecID));
        parameters.put("EnableChannelIndex", EscObject.createInteger((int)enableChannelIndex));
        parameters.put("EnablePeakRSSI", EscObject.createInteger((int)enablePeakRSSI));
        parameters.put("EnableFirstSeenTimestamp", EscObject.createInteger((int)enableFirstSeenTimestamp));
        parameters.put("EnableLastSeenTimestamp", EscObject.createInteger((int)enableLastSeenTimestamp));
        parameters.put("EnableTagSeenCount", EscObject.createInteger((int)enableTagSeenCount));
        parameters.put("EnableAccessSpecID", EscObject.createInteger((int)enableAccessSpecID));
        if (airProtocolEPCMemorySelectorChoice != null && airProtocolEPCMemorySelectorChoice.size() > 0) {
            parameters.put("AirProtocolEPCMemorySelectorChoice", airProtocolEPCMemorySelectorChoice);
        }
        return parameters;
    }

    private static boolean isAllZeroString(String string) {
        if (string == null) {
            return true;
        }
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ',' && string.charAt(i) != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

