/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.inventory.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.adapter.EpcglobalLlrpAdapter;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPConfigParser;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPDefaultParameters;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;
import org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager.IIdManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.AbstractKeyTaskPool;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.ILLRPCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_Array;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DISABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DISABLE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_ACCESSSPECS;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_ROSPECS;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_SET_READER_CONFIG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_START_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_STOP_ROSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskManager;
import org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.service.EpcglobalLlrpInventoryProfileService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class EpcglobalLlrpInventoryProfile
extends RfidInventoryProfile
implements ProfileService,
EpcglobalLlrpInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.EpcglobalLlrpInventoryProfile";
    private final MethodMeasurement lLRPConfiguration = new MethodMeasurement("LLRPInventoryProfile/LLRPConfiguration", (Object)"");
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration;
    protected CommandService epcglobalLlrpDeviceServiceGetRospecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteRospec;
    protected CommandService epcglobalLlrpDeviceServiceAddRospec;
    protected CommandService epcglobalLlrpDeviceServiceEnableRospec;
    protected CommandService epcglobalLlrpDeviceServiceDisableRospec;
    protected CommandService epcglobalLlrpDeviceServiceStartRospec;
    protected CommandService epcglobalLlrpDeviceServiceStopRospec;
    protected CommandService epcglobalLlrpDeviceServiceGetAccessspecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceAddAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceEnableAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceDisableAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec;
    protected SignalService epcglobalLlrpDeviceServiceSetReaderConfigResponse;
    protected SignalService epcglobalLlrpDeviceServiceGetRospecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStartRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStopRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceRoAccessReport;
    protected SignalService epcglobalLlrpDeviceServiceGetAccessspecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceReaderEventNotification;
    private AdapterService adapter;
    private int rOSpecID = 1;
    private int accessSpecID = 1;
    private static final String TASKARRAY_START_ROSPEC = "TaskArray_Start_ROSPEC";
    private static final String TASKARRAY_END_ROSPEC = "TaskArray_End_ROSPEC";
    private static final String TASKARRAY_ENABLE_ACCESSSPEC = "TaskArray_Enable_ACCESSSPEC";
    private static final String TASKARRAY_END_ACCESSSPEC = "TaskArray_End_ACCESSSPEC";
    private List rOSpecParameters;
    private List accessSpecParameters;
    private boolean autonomousModeOn = false;
    private Byte autonomousModeMonitor = new Byte(0);
    private ITaskListener taskListener = new ITaskListener(){

        public void taskNotice(String taskName, int status, Object result) {
            if (status == 2) {
                EpcglobalLlrpInventoryProfile.this.handleError(new RuntimeException(result.toString()), 1);
                return;
            }
            if (status == 0) {
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_END_ROSPEC)) {
                    int rOSpecId = (Integer)((Map)result).get("ROSpecID");
                    EpcglobalLlrpInventoryProfile.this.rOSpecEnded(rOSpecId);
                    return;
                }
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_END_ACCESSSPEC)) {
                    int accessSpecId = (Integer)((Map)result).get("AccessSpecID");
                    EpcglobalLlrpInventoryProfile.this.accessSpecEnded(accessSpecId);
                    return;
                }
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_START_ROSPEC)) {
                    int rOSpecId = (Integer)((Map)result).get("ROSpecID");
                    EpcglobalLlrpInventoryProfile.this.retryStartROSpec(rOSpecId);
                    return;
                }
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_ENABLE_ACCESSSPEC)) {
                    int accessSpecId = (Integer)((Map)result).get("AccessSpecID");
                    EpcglobalLlrpInventoryProfile.this.retryEnableAccessSpec(accessSpecId);
                    return;
                }
                String errorMsg = LLRPUtils.handleErrorResponse((String)taskName, (Map)((Map)result));
                EpcglobalLlrpInventoryProfile.this.handleError(new RuntimeException(errorMsg), 1);
                return;
            }
            if (status == 1) {
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_START_ROSPEC)) {
                    return;
                }
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_END_ROSPEC)) {
                    return;
                }
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_ENABLE_ACCESSSPEC)) {
                    int accessSpecId = (Integer)((Map)result).get("AccessSpecID");
                    EpcglobalLlrpInventoryProfile.this.accessSpecEnabled(accessSpecId);
                    return;
                }
                if (taskName.equals(EpcglobalLlrpInventoryProfile.TASKARRAY_END_ACCESSSPEC)) {
                    int accessSpecId = (Integer)((Map)result).get("AccessSpecID");
                    EpcglobalLlrpInventoryProfile.this.accessSpecEnded(accessSpecId);
                    return;
                }
            }
        }
    };
    private AbstractKeyTaskPool taskPool = new AbstractKeyTaskPool(){

        public Task_ADD_ACCESSSPEC createAddAccessSpecTask() {
            return new Task_ADD_ACCESSSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceAddAccessspec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceAddAccessspecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_ADD_ROSPEC createAddROSpecTask() {
            return new Task_ADD_ROSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceAddRospec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceAddRospecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_DELETE_ACCESSSPEC createDeleteAccessSpecTask() {
            return new Task_DELETE_ACCESSSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDeleteAccessspec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_DELETE_ROSPEC createDeleteROSpecTask() {
            return new Task_DELETE_ROSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDeleteRospec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDeleteRospecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_DISABLE_ACCESSSPEC createDisableAccessSpecTask() {
            return new Task_DISABLE_ACCESSSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDisableAccessspec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDisableAccessspecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_DISABLE_ROSPEC createDisableROSpecTask() {
            return new Task_DISABLE_ROSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDisableRospec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceDisableRospecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_ENABLE_ACCESSSPEC createEnableAccessSpecTask() {
            return new Task_ENABLE_ACCESSSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceEnableAccessspec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceEnableAccessspecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public ITask createEnableAccessSpecTaskArray() {
            Task_Array enableAccessSpecTaskArray = new Task_Array(EpcglobalLlrpInventoryProfile.TASKARRAY_ENABLE_ACCESSSPEC, null);
            enableAccessSpecTaskArray.addTaskListener(EpcglobalLlrpInventoryProfile.this.getTaskListener());
            enableAccessSpecTaskArray.setTaskOwner(EpcglobalLlrpInventoryProfile.this.getOwner());
            return enableAccessSpecTaskArray;
        }

        public Task_ENABLE_ROSPEC createEnableROSpecTask() {
            return new Task_ENABLE_ROSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceEnableRospec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceEnableRospecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public ITask createEndAccessSpecTaskArray() {
            Task_Array deleteAccessSpecTaskArray = new Task_Array(EpcglobalLlrpInventoryProfile.TASKARRAY_END_ACCESSSPEC, null);
            deleteAccessSpecTaskArray.addTaskListener(EpcglobalLlrpInventoryProfile.this.getTaskListener());
            deleteAccessSpecTaskArray.setTaskOwner(EpcglobalLlrpInventoryProfile.this.getOwner());
            return deleteAccessSpecTaskArray;
        }

        public ITask createEndROSpecTaskArray() {
            Task_Array endROSpecTaskArray = new Task_Array(EpcglobalLlrpInventoryProfile.TASKARRAY_END_ROSPEC, null);
            endROSpecTaskArray.addTaskListener(EpcglobalLlrpInventoryProfile.this.getTaskListener());
            endROSpecTaskArray.setTaskOwner(EpcglobalLlrpInventoryProfile.this.getOwner());
            return endROSpecTaskArray;
        }

        public Task_GET_ACCESSSPECS createGetAccessSpecsTask() {
            return new Task_GET_ACCESSSPECS(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceGetAccessspecs, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceGetAccessspecsResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_GET_ROSPECS createGetROSpecsTask() {
            return new Task_GET_ROSPECS(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceGetRospecs, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceGetRospecsResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public Task_START_ROSPEC createStartROSpecTask() {
            return new Task_START_ROSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceStartRospec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceStartRospecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }

        public ITask createStartROSpecTaskArray() {
            Task_Array startROSpecTaskArray = new Task_Array(EpcglobalLlrpInventoryProfile.TASKARRAY_START_ROSPEC, null);
            startROSpecTaskArray.addTaskListener(EpcglobalLlrpInventoryProfile.this.getTaskListener());
            startROSpecTaskArray.setTaskOwner(EpcglobalLlrpInventoryProfile.this.getOwner());
            return startROSpecTaskArray;
        }

        public Task_STOP_ROSPEC createStopROSpecTask() {
            return new Task_STOP_ROSPEC(EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceStopRospec, null, EpcglobalLlrpInventoryProfile.this.epcglobalLlrpDeviceServiceStopRospecResponse, EpcglobalLlrpInventoryProfile.this.getLLRPCommandTimeout());
        }
    };

    public EpcglobalLlrpInventoryProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecs != null) {
                this.epcglobalLlrpDeviceServiceGetRospecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospec != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospec != null) {
                this.epcglobalLlrpDeviceServiceAddRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospec != null) {
                this.epcglobalLlrpDeviceServiceEnableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospec != null) {
                this.epcglobalLlrpDeviceServiceDisableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospec != null) {
                this.epcglobalLlrpDeviceServiceStartRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospec != null) {
                this.epcglobalLlrpDeviceServiceStopRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecs != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspec != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfigResponse != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfigResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetRospecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStartRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStopRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceRoAccessReport != null) {
                this.epcglobalLlrpDeviceServiceRoAccessReport.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceReaderEventNotification != null) {
                this.epcglobalLlrpDeviceServiceReaderEventNotification.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory = device.getCommand("SetReaderConfig_ForInventory");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration = device.getCommand("SetReaderConfig_AntennaConfiguration");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration);
            this.epcglobalLlrpDeviceServiceGetRospecs = device.getCommand("GetRospecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetRospecs);
            this.epcglobalLlrpDeviceServiceDeleteRospec = device.getCommand("DeleteRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteRospec);
            this.epcglobalLlrpDeviceServiceAddRospec = device.getCommand("AddRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddRospec);
            this.epcglobalLlrpDeviceServiceEnableRospec = device.getCommand("EnableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableRospec);
            this.epcglobalLlrpDeviceServiceDisableRospec = device.getCommand("DisableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableRospec);
            this.epcglobalLlrpDeviceServiceStartRospec = device.getCommand("StartRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStartRospec);
            this.epcglobalLlrpDeviceServiceStopRospec = device.getCommand("StopRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStopRospec);
            this.epcglobalLlrpDeviceServiceGetAccessspecs = device.getCommand("GetAccessspecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetAccessspecs);
            this.epcglobalLlrpDeviceServiceDeleteAccessspec = device.getCommand("DeleteAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteAccessspec);
            this.epcglobalLlrpDeviceServiceAddAccessspec = device.getCommand("AddAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddAccessspec);
            this.epcglobalLlrpDeviceServiceEnableAccessspec = device.getCommand("EnableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableAccessspec);
            this.epcglobalLlrpDeviceServiceDisableAccessspec = device.getCommand("DisableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableAccessspec);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec = device.getCommand("SetReaderConfig_ReaderEventNotificationSpec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec);
            this.epcglobalLlrpDeviceServiceSetReaderConfigResponse = device.getSignal("SetReaderConfigResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceSetReaderConfigResponse);
            this.epcglobalLlrpDeviceServiceGetRospecsResponse = device.getSignal("GetRospecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetRospecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteRospecResponse = device.getSignal("DeleteRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteRospecResponse);
            this.epcglobalLlrpDeviceServiceAddRospecResponse = device.getSignal("AddRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddRospecResponse);
            this.epcglobalLlrpDeviceServiceEnableRospecResponse = device.getSignal("EnableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableRospecResponse);
            this.epcglobalLlrpDeviceServiceDisableRospecResponse = device.getSignal("DisableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableRospecResponse);
            this.epcglobalLlrpDeviceServiceStartRospecResponse = device.getSignal("StartRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStartRospecResponse);
            this.epcglobalLlrpDeviceServiceStopRospecResponse = device.getSignal("StopRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStopRospecResponse);
            this.epcglobalLlrpDeviceServiceRoAccessReport = device.getSignal("RoAccessReport");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceRoAccessReport);
            this.epcglobalLlrpDeviceServiceGetAccessspecsResponse = device.getSignal("GetAccessspecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetAccessspecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse = device.getSignal("DeleteAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse);
            this.epcglobalLlrpDeviceServiceAddAccessspecResponse = device.getSignal("AddAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
            this.epcglobalLlrpDeviceServiceEnableAccessspecResponse = device.getSignal("EnableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableAccessspecResponse);
            this.epcglobalLlrpDeviceServiceDisableAccessspecResponse = device.getSignal("DisableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableAccessspecResponse);
            this.epcglobalLlrpDeviceServiceReaderEventNotification = device.getSignal("ReaderEventNotification");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceReaderEventNotification);
        }
        super.setDevice(device);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.epcglobalLlrpDeviceServiceReaderEventNotification == source) {
            this.handleReaderEventNotification(data);
        }
        if (this.epcglobalLlrpDeviceServiceRoAccessReport == source) {
            this.handleEpcglobalLlrpDeviceServiceRoAccessReport(source, timestamp, data);
            return;
        }
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpInventoryProfile";
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)EpcglobalLlrpInventoryProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice");
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    public int getControlCapacity() {
        return 3;
    }

    public int getMessageCapacity() {
        return 2;
    }

    private void initialize() {
        MethodMeasurement lLRPConfiguration = this.lLRPConfiguration;
        this.put((ControlService)lLRPConfiguration);
    }

    public void setROSpecID(int ROSpecID) {
        this.rOSpecID = ROSpecID;
    }

    public int getROSpecID() {
        return this.rOSpecID;
    }

    public void setAccessSpecID(int AccessSpecID) {
        this.accessSpecID = AccessSpecID;
    }

    public int getAccessSpecID() {
        return this.accessSpecID;
    }

    public void setup() {
        super.setup();
        this.setROSpecID(this.getInt("epcgloballlrpinventoryprofile.ROSpecID", this.getROSpecID()));
        this.setAccessSpecID(this.getInt("epcgloballlrpinventoryprofile.AccessSpecID", this.getAccessSpecID()));
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    private static Number convert2MilliSecond(Number microSecond) {
        if (microSecond == null) {
            return null;
        }
        long microSecondValue = microSecond.longValue();
        long milliSecondValue = microSecondValue / 1000L;
        return new Long(milliSecondValue);
    }

    protected void accessSpecEnabled(int accessSpecId) {
        if (this.isLogging(4)) {
            this.log(4, "AccessSpec " + accessSpecId + " enabled.");
        }
        this.getAccessSpecIdManager().setIdStatus(accessSpecId, this.getOwner(), 11);
    }

    protected void accessSpecEnded(int accessSpecId) {
        if (this.isLogging(4)) {
            this.log(4, "AccessSpec " + accessSpecId + " ended.");
        }
        this.getAccessSpecIdManager().setIdStatus(accessSpecId, this.getOwner(), 12);
    }

    public void activate() {
        super.activate();
        if (this.isLogging(4)) {
            this.log(4, "org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.EpcglobalLlrpInventoryProfile activate.");
        }
        ((Measurement)this.getAntennaCount()).setValue((Object)EpcglobalLlrpInventoryProfile.createInteger((int)this.getSupportedAntennaCount()), EpcglobalLlrpInventoryProfile.getCurrentTimestamp());
        this.enableROSpecEvent();
        this.initROSpecs();
        this.initAccessSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean autonomousModeOff() {
        if (this.isLogging(4)) {
            this.log(4, "AutonomousModeOff");
        }
        if (this.getDevice() != null && this.getDevice().isStarted() && this.isAutonomousModeOn()) {
            this.getAdapterTaskManager().clearTasksByOwner(this.getOwner());
            this.endROSpecs();
            Byte by = this.autonomousModeMonitor;
            synchronized (by) {
                if (this.isAutonomousModeOn()) {
                    if (this.isLogging(4)) {
                        this.log(4, "Waiting for ROSpecs to stop.");
                    }
                    try {
                        this.autonomousModeMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.isLogging(4)) {
                        this.log(4, "All ROSpecs have stopped.");
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean autonomousModeOn() {
        if (this.isLogging(4)) {
            this.log(4, "AutonomousModeOn");
        }
        if (this.getDevice() != null && this.getDevice().isStarted()) {
            this.getAdapterTaskManager().clearTasksByOwner(this.getOwner());
            if (this.registerROSpecIds()) {
                this.startROSpecs();
                Byte by = this.autonomousModeMonitor;
                synchronized (by) {
                    if (!this.isAutonomousModeOn()) {
                        if (this.isLogging(4)) {
                            this.log(4, "Waiting for ROSpecs to start.");
                        }
                        try {
                            this.autonomousModeMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (this.isLogging(4)) {
                            this.log(4, "All ROSpecs have started.");
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void clearAccessSpecs() {
        List accessSpecs = this.getAccessSpecParameters();
        int i = 0;
        while (i < accessSpecs.size()) {
            Map accessSpecParam = (Map)accessSpecs.get(i);
            int accessSpecId = (Integer)accessSpecParam.get("AccessSpecID");
            Map accessSpecIdParameter = ParameterFactory.getAccessSpecIDParameter((int)accessSpecId);
            Task_DELETE_ACCESSSPEC deleteAccessSpec = this.taskPool.getDeleteAccessSpecTask(i, accessSpecIdParameter);
            deleteAccessSpec.start();
            ++i;
        }
    }

    private void clearROSpecs() {
        List rOSpecs = this.getROSpecParameters();
        int i = 0;
        while (i < rOSpecs.size()) {
            Map rOSpecParam = (Map)rOSpecs.get(i);
            int rOSpecId = ((Number)rOSpecParam.get("ROSpecID")).intValue();
            Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
            Task_DELETE_ROSPEC deleteROSpec = this.taskPool.getDeleteROSpecTask(i, rOSpecIdParameter);
            deleteROSpec.start();
            ++i;
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.isLogging(4)) {
            this.log(4, "org.eclipse.soda.dk.epcglobal.llrp.inventory.profile.EpcglobalLlrpInventoryProfile deactivate.");
        }
        this.clearROSpecs();
        this.clearAccessSpecs();
    }

    protected void disableAccessSpecs() {
        List currentAccessSpecIds = this.getAccessSpecIdManager().getIds(this.getOwner());
        int i = 0;
        while (i < currentAccessSpecIds.size()) {
            Map accessSpecIdParameter = (Map)currentAccessSpecIds.get(i);
            int status = this.getAccessSpecIdManager().getIdStatus((Object)accessSpecIdParameter, this.getOwner());
            if (status == 11) {
                ITask disableAccessSpecTasksArray = this.taskPool.getEndAccessSpecTaskArray(i, accessSpecIdParameter);
                disableAccessSpecTasksArray.start(this.getAdapterTaskManager());
            }
            ++i;
        }
    }

    protected void enableAccessSpecs() {
        List accessSpecs = this.getAccessSpecParameters();
        int i = 0;
        while (i < accessSpecs.size()) {
            Map accessSpecParam = (Map)accessSpecs.get(i);
            int accessSpecId = (Integer)accessSpecParam.get("AccessSpecID");
            int accessSpec_status = this.getAccessSpecIdManager().getIdStatus(accessSpecId, this.getOwner());
            if (accessSpec_status == 10) {
                this.initAccessSpec(i, accessSpecParam);
            }
            Map accessSpecIdParameter = ParameterFactory.getAccessSpecIDParameter((int)accessSpecId);
            this.taskPool.getEnableAccessSpecTaskArray(i, accessSpecIdParameter, null).start(this.getAdapterTaskManager());
            ++i;
        }
    }

    private void enableROSpecEvent() {
        ArrayList<Map> enableROSpecEvent = new ArrayList<Map>();
        Map readerEventNotificationSpecStateParameter = ParameterFactory.getEventNotificationStateParameter((int)2, (boolean)true);
        enableROSpecEvent.add(readerEventNotificationSpecStateParameter);
        Map readerEventNotificationSpecParameter = ParameterFactory.getReaderEventNotificationSpecParameter(enableROSpecEvent);
        Map readerConfigROSpecEventParameter = ParameterFactory.getSetReaderConfig_ReaderEventNotificationSpecParameter((boolean)false, (Map)readerEventNotificationSpecParameter);
        Task_SET_READER_CONFIG setReaderConfig_ReaderEventNotificationSpecTask = new Task_SET_READER_CONFIG(this.epcglobalLlrpDeviceServiceSetReaderConfig_ReaderEventNotificationSpec, readerConfigROSpecEventParameter, this.epcglobalLlrpDeviceServiceSetReaderConfigResponse, "ReaderEventNotificationSpec");
        setReaderConfig_ReaderEventNotificationSpecTask.start();
    }

    protected void endROSpecs() {
        List currentROSpecIds = this.getROSpecIdManager().getIds(this.getOwner());
        int i = 0;
        while (i < currentROSpecIds.size()) {
            boolean includeStop;
            Map rOSpecIdParameter = (Map)currentROSpecIds.get(i);
            Map rOSpecParameter = this.getROSpecParameter(rOSpecIdParameter);
            boolean bl = includeStop = LLRPUtils.extractROSpecStopTrigger((Map)rOSpecParameter) == 0;
            if (includeStop) {
                Task_STOP_ROSPEC stopROSpec = this.taskPool.getStopROSpecTask(i, rOSpecIdParameter);
                stopROSpec.start(this.getAdapterTaskManager());
            }
            ++i;
        }
    }

    private List extractCustomParameters(Map data) {
        if (data != null) {
            return (List)data.get("CustomParameter");
        }
        return null;
    }

    private Object extractLLRPTagReportData(Map tagReportData, String paramKey, String valueKey) {
        Map param = (Map)tagReportData.get(paramKey);
        if (param != null) {
            return param.get(valueKey);
        }
        return null;
    }

    protected Map getAISpecParameter(int[] antennaIds) {
        ArrayList<Map> inventoryParameterSpecParameters = new ArrayList<Map>();
        inventoryParameterSpecParameters.add(ParameterFactory.getInventoryParameterSpecParameter((int)12345, (int)1));
        return ParameterFactory.getAISpecParameter((int[])antennaIds, (Map)ParameterFactory.getAISpecStopTriggerParameter((int)0, (int)0, null, null), inventoryParameterSpecParameters);
    }

    protected Map getAccessOpParameter(Number accessSpecId, int opId) {
        if (this.accessSpecParameters == null || accessSpecId == null) {
            return null;
        }
        int i = 0;
        while (i < this.accessSpecParameters.size()) {
            Map accessSpec = (Map)this.accessSpecParameters.get(i);
            if (accessSpec != null) {
                Map accessCommand;
                List opSpecChoices;
                int specId = (Integer)accessSpec.get("AccessSpecID");
                if (accessSpecId.intValue() == specId && (opSpecChoices = (List)(accessCommand = (Map)accessSpec.get("AccessCommandParameter")).get("AccessCommandOpSpecChoice")) != null && opSpecChoices.size() > 0) {
                    int j = 0;
                    while (j < opSpecChoices.size()) {
                        int id;
                        Map choiceMap = (Map)opSpecChoices.get(j);
                        Map opMap = (Map)choiceMap.values().toArray()[0];
                        if (opMap != null && opId == (id = ((Integer)opMap.get("OpSpecID")).intValue())) {
                            return opMap;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected IIdManager getAccessSpecIdManager() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getAccessSpecIdManager();
    }

    protected List getAccessSpecParameters() {
        if (this.accessSpecParameters == null) {
            this.accessSpecParameters = new ArrayList();
        }
        return this.accessSpecParameters;
    }

    protected ITaskManager getAdapterTaskManager() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getTaskManager();
    }

    public long getLLRPCommandTimeout() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getLLRPCommandTimeout();
    }

    protected Object getLLRPConfigurationValue() {
        String value = (String)this.lLRPConfiguration.getValueRaw();
        if (value != null && value.trim().length() > 0) {
            return value;
        }
        Hashtable<String, List> lLRPConfigMap = new Hashtable<String, List>();
        lLRPConfigMap.put("ROSpecParameter", this.getROSpecParameters());
        lLRPConfigMap.put("AccessSpecParameter", this.getAccessSpecParameters());
        String configStr = Nls.formatData(lLRPConfigMap);
        this.lLRPConfiguration.setValue((Object)configStr, EpcglobalLlrpInventoryProfile.getCurrentTimestamp());
        return configStr;
    }

    protected Object getOwner() {
        return this;
    }

    protected IIdManager getROSpecIdManager() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getROSpecIdManager();
    }

    protected Map getROSpecParameter(Map rOSpecIdParameter) {
        List rOSpecParams = this.getROSpecParameters();
        int rOSpecId = ((Number)rOSpecIdParameter.get("ROSpecID")).intValue();
        int i = 0;
        while (i < rOSpecParams.size()) {
            Map rOSpecParam = (Map)rOSpecParams.get(i);
            if (rOSpecId == ((Number)rOSpecParam.get("ROSpecID")).intValue()) {
                return rOSpecParam;
            }
            ++i;
        }
        return null;
    }

    protected List getROSpecParameters() {
        if (this.rOSpecParameters == null) {
            if (this.isLogging(4)) {
                this.log(4, "Apply default LLRPConfiguration");
            }
            this.rOSpecParameters = new ArrayList();
            this.rOSpecParameters.add(LLRPDefaultParameters.getDefaultROSpecParameter((int)this.getROSpecID()));
        }
        return this.rOSpecParameters;
    }

    public int getSupportedAntennaCount() {
        ILLRPCapabilities capabilities = ((EpcglobalLlrpAdapter)this.getAdapter()).getLLRPCapabilities();
        if (capabilities != null) {
            return capabilities.getMaxNumberOfAntennaSupported();
        }
        return 0;
    }

    protected ITaskListener getTaskListener() {
        return this.taskListener;
    }

    /*
     * Unable to fully structure code
     */
    private void handleEpcglobalLlrpDeviceServiceRoAccessReport(SignalService source, Object timestamp, Object data) {
        block25: {
            paramMap = (Map)data;
            customParams1 = this.extractCustomParameters(paramMap);
            tagReportDataParams = (List)paramMap.get("TagReportDataParameter");
            tagReportMap = new HashMap<String, HashMap<K, V>>();
            if (tagReportDataParams == null) break block25;
            i = 0;
            while (i < tagReportDataParams.size()) {
                tagReportData = (Map)tagReportDataParams.get(i);
                tag = LLRPUtils.extractTag((Map)((Map)tagReportData.get("EPCParameterChoice")));
                if (tag == null) {
                    this.handleError(new NullPointerException("EPC is null"), 3008);
                }
                if ((rOSpecId = (Number)this.extractLLRPTagReportData(tagReportData, "ROSpecIDParameter", "ROSpecID")) == null) ** GOTO lbl-1000
                status = this.getROSpecIdManager().getIdStatus(rOSpecId.intValue(), this.getOwner());
                switch (status) {
                    case -13: {
                        break;
                    }
                    case 12: {
                        this.handleError(new RuntimeException("Receive tag report after the ROSpec is stopped."), 3008);
                        return;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (this.isLogging(4)) {
                            this.log(4, "LLRP Inventory profile, tag report: " + tag);
                        }
                        readData = new HashMap<K, V>();
                        this.setTagReportData(readData, "llrpROSpecId", rOSpecId);
                        this.setTagReportData(readData, "reader", this.getId());
                        specIndex = (Number)this.extractLLRPTagReportData(tagReportData, "SpecIndexParameter", "SpecIndex");
                        this.setTagReportData(readData, "llrpSpecIndex", specIndex);
                        inventoryParameterSpecId = (Number)this.extractLLRPTagReportData(tagReportData, "InventoryParameterSpecIDParameter", "InventoryParameterSpecID");
                        this.setTagReportData(readData, "llrpInventoryParameterSpecId", inventoryParameterSpecId);
                        antennaId = (Number)this.extractLLRPTagReportData(tagReportData, "AntennaIDParameter", "AntennaID");
                        this.setTagReportData(readData, "antenna", antennaId);
                        peakRSSI = (Number)this.extractLLRPTagReportData(tagReportData, "PeakRSSIParameter", "PeakRSSI");
                        this.setTagReportData(readData, "peakRSSI", peakRSSI);
                        channelIndex = (Number)this.extractLLRPTagReportData(tagReportData, "ChannelIndexParameter", "ChannelIndex");
                        this.setTagReportData(readData, "channelIndex", channelIndex);
                        firstSeenTimestampUTC = (Number)this.extractLLRPTagReportData(tagReportData, "FirstSeenTimestampUTCParameter", "Microseconds");
                        this.setTagReportData(readData, "timestampFirst", EpcglobalLlrpInventoryProfile.convert2MilliSecond(firstSeenTimestampUTC));
                        firstSeenTimestampUptime = (Number)this.extractLLRPTagReportData(tagReportData, "FirstSeenTimestampUptimeParameter", "Microseconds");
                        this.setTagReportData(readData, "timestampFirstUptime", EpcglobalLlrpInventoryProfile.convert2MilliSecond(firstSeenTimestampUptime));
                        lastSeenTimestampUTC = (Number)this.extractLLRPTagReportData(tagReportData, "LastSeenTimestampUTCParameter", "Microseconds");
                        this.setTagReportData(readData, "timestampLast", EpcglobalLlrpInventoryProfile.convert2MilliSecond(lastSeenTimestampUTC));
                        lastSeenTimestampUptime = (Number)this.extractLLRPTagReportData(tagReportData, "LastSeenTimestampUptimeParameter", "Microseconds");
                        this.setTagReportData(readData, "timestampLastUptime", EpcglobalLlrpInventoryProfile.convert2MilliSecond(lastSeenTimestampUptime));
                        tagSeenCount = (Number)this.extractLLRPTagReportData(tagReportData, "TagSeenCountParameter", "TagCount");
                        this.setTagReportData(readData, "count", tagSeenCount);
                        accessSpecId = (Number)this.extractLLRPTagReportData(tagReportData, "AccessSpecIDParameter", "AccessSpecID");
                        this.setTagReportData(readData, "llrpAccessSpecId", accessSpecId);
                        customParams2 = this.extractCustomParameters(tagReportData);
                        if (customParams1 != null) {
                            if (customParams2 != null) {
                                customParams1.addAll(customParams2);
                            }
                            if (customParams1.size() > 0) {
                                this.setTagReportData(readData, "vendorExtensions", customParams1);
                            }
                        } else if (customParams2 != null && customParams2.size() > 0) {
                            this.setTagReportData(readData, "vendorExtensions", customParams2);
                        }
                        if ((airProtocolTagData = (List)tagReportData.get("AirProtocolTagDataChoice")) != null && airProtocolTagData.size() > 0) {
                            j = 0;
                            while (j < airProtocolTagData.size()) {
                                tagData = (Map)airProtocolTagData.get(j);
                                if (tagData != null) {
                                    key = (String)tagData.get("key");
                                    if ("C1G2_PCParameter".equals(key)) {
                                        pcBits = (Number)tagData.get("PC_Bits");
                                        this.setTagReportData(readData, "C1G2PC", pcBits);
                                    } else if ("C1G2_CRCParameter".equals(key)) {
                                        crc = (Number)tagData.get("CRC");
                                        this.setTagReportData(readData, "C1G2CRC", crc);
                                    }
                                }
                                ++j;
                            }
                        }
                        if ((accessCommandOpSpecResultChoices = (List)tagReportData.get("AccessCommandOpSpecResultChoice")) != null && accessCommandOpSpecResultChoices.size() > 0) {
                            opResults = new HashMap<String, HashMap<K, V>>();
                            j = 0;
                            while (j < accessCommandOpSpecResultChoices.size()) {
                                opResult = new HashMap<String, Object>();
                                resultParam = (Map)accessCommandOpSpecResultChoices.get(j);
                                key = (String)resultParam.get("key");
                                opSpecId = ((Number)resultParam.get("OpSpecID")).intValue();
                                resultCode = LLRPUtils.getAccessOpResultCode((Map)resultParam);
                                opResult.put("llrpOpSpecResultCode", EpcglobalLlrpInventoryProfile.createInteger((int)resultCode));
                                if ("C1G2ReadOpSpecResultParameter".equals(key)) {
                                    readDatas = (List)resultParam.get("ReadDatas");
                                    readDataBytes = LLRPUtils.convertIntListToBytes((List)readDatas);
                                    opResult.put("llrpOpSpecReadData", readDataBytes);
                                    opParamMap = this.getAccessOpParameter(accessSpecId, opSpecId);
                                    if (opParamMap != null) {
                                        accessReportId = (String)opParamMap.get("AccessOpReportKey");
                                        if (accessReportId != null && accessReportId.trim().length() > 0) {
                                            this.setTagReportData(readData, accessReportId.trim(), readDataBytes);
                                        }
                                        mb = (Integer)opParamMap.get("MB");
                                        wordPointer = (Integer)opParamMap.get("WordPointer") * 16;
                                        wordCount = (Integer)opParamMap.get("WordCount") * 16;
                                        reportKey = mb + "." + wordPointer + "." + wordCount;
                                        this.setTagReportData(readData, reportKey, readDataBytes);
                                    }
                                } else if ("C1G2WriteOpSpecResultParameter".equals(key) || "C1G2BlockWriteOpSpecResultParameter".equals(key)) {
                                    numWordsWritten = (Number)resultParam.get("NumWordsWritten");
                                    opResult.put("llrpOpSpecNumWordsWritten", numWordsWritten);
                                }
                                opResults.put(String.valueOf(opSpecId), opResult);
                                ++j;
                            }
                            this.setTagReportData(readData, "llrpOpSpecResult", opResults);
                        }
                        if (tag == null) break;
                        tagReportMap.put(tag, readData);
                    }
                }
                ++i;
            }
            this.notifyTagRead(tagReportMap, timestamp);
        }
    }

    public Object handleMethodLLRPConfiguration(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return this.getLLRPConfigurationValue();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetLLRPConfiguration(measurement, data);
            }
        }
        return null;
    }

    private void handleReaderEventNotification(Object data) {
        Map rospecEventParams;
        Map params = (Map)data;
        Map readerEventNotificationParams = (Map)params.get("ReaderEventNotificationDataParameter");
        if (readerEventNotificationParams != null && (rospecEventParams = (Map)readerEventNotificationParams.get("ROSpecEventParameter")) != null) {
            int rospecId = ((Number)rospecEventParams.get("ROSpecID")).intValue();
            int eventType = ((Number)rospecEventParams.get("ROSpecEvent_EventType")).intValue();
            switch (eventType) {
                case 0: {
                    this.rOSpecStarted(rospecId);
                    break;
                }
                case 1: {
                    this.rOSpecEnded(rospecId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSetLLRPConfiguration(Measurement measurement, Object data) {
        Byte by = this.autonomousModeMonitor;
        synchronized (by) {
            if (this.isAutonomousModeOn()) {
                this.handleError(new RuntimeException("Can't set the LLRP configuration during the tag reading."), 3008);
                return;
            }
        }
        measurement.setValue(data, EpcglobalLlrpInventoryProfile.getCurrentTimestamp());
        String configStr = (String)data;
        if (configStr != null && configStr.trim().length() > 1) {
            Map llrpConfig;
            Object roSpecObjs;
            if (this.isLogging(4)) {
                this.log(4, "Apply LLRPConfiguration from edge.");
            }
            if ((roSpecObjs = (llrpConfig = (Map)LLRPConfigParser.parseConfig((String)configStr)).get("ROSpecParameter")) instanceof List) {
                List roSpecParameters = (List)roSpecObjs;
                if (roSpecParameters.size() > 0) {
                    this.getROSpecParameters().clear();
                    this.getROSpecParameters().addAll(roSpecParameters);
                } else {
                    this.handleError(new RuntimeException("No ROSpecParameter in LLRP configuration."), 3008);
                }
            } else if (roSpecObjs instanceof Map) {
                this.getROSpecParameters().clear();
                this.getROSpecParameters().add(roSpecObjs);
            } else if (roSpecObjs == null) {
                this.handleError(new RuntimeException("No ROSpecParameter in LLRP configuration."), 3008);
            }
            Object accessSpecObjs = llrpConfig.get("AccessSpecParameter");
            if (accessSpecObjs instanceof List) {
                List accessSpecParameters = (List)accessSpecObjs;
                if (accessSpecParameters.size() > 0) {
                    this.getAccessSpecParameters().clear();
                    this.getAccessSpecParameters().addAll(accessSpecParameters);
                }
            } else if (accessSpecObjs instanceof Map) {
                this.getAccessSpecParameters().clear();
                this.getAccessSpecParameters().add(accessSpecObjs);
            } else if (accessSpecObjs == null) {
                this.getAccessSpecParameters().clear();
            }
            this.initROSpecs();
            this.initAccessSpecs();
        }
    }

    protected void initAccessSpec(int i, Map accessSpecParam) {
        int accessSpecId = (Integer)accessSpecParam.get("AccessSpecID");
        Map accessSpecIdParameter = ParameterFactory.getAccessSpecIDParameter((int)accessSpecId);
        Task_DELETE_EXIST_ACCESSSPEC deleteExistAccessSpec = this.taskPool.getDeleteExistAccessSpecTask(i, accessSpecIdParameter);
        deleteExistAccessSpec.setTaskOwner(this.getOwner());
        deleteExistAccessSpec.start(this.getAdapterTaskManager());
        Task_ADD_ACCESSSPEC addAccessSpec = this.taskPool.getAddAccessSpecTask(i, ParameterFactory.getAddAccessSpecCommandParameters((Map)accessSpecParam));
        addAccessSpec.setTaskOwner(this.getOwner());
        addAccessSpec.start(this.getAdapterTaskManager());
        this.getAccessSpecIdManager().setIdStatus(accessSpecId, this.getOwner(), 12);
    }

    protected void initAccessSpecs() {
        if (this.registerAccessSpecIds()) {
            List accessSpecs = this.getAccessSpecParameters();
            int i = 0;
            while (i < accessSpecs.size()) {
                Map accessSpecParam = (Map)accessSpecs.get(i);
                this.initAccessSpec(i, accessSpecParam);
                ++i;
            }
        }
    }

    protected void initROSpec(int i, Map rOSpecParam) {
        int rOSpecId = ((Number)rOSpecParam.get("ROSpecID")).intValue();
        Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
        Task_DELETE_EXIST_ROSPEC deleteExistROSpec = this.taskPool.getDeleteExistROSpecTask(i, rOSpecIdParameter);
        deleteExistROSpec.start(this.getAdapterTaskManager());
        Task_ADD_ROSPEC addROSpec = this.taskPool.getAddROSpecTask(i, ParameterFactory.getAddROSpecCommandParameters((Map)rOSpecParam));
        addROSpec.start(this.getAdapterTaskManager());
        Task_ENABLE_ROSPEC enableROSpec = this.taskPool.getEnableROSpecTask(i, rOSpecIdParameter);
        enableROSpec.start(this.getAdapterTaskManager());
        this.getROSpecIdManager().setIdStatus(rOSpecId, this.getOwner(), 12);
    }

    protected void initROSpecs() {
        if (this.registerROSpecIds()) {
            List rOSpecs = this.getROSpecParameters();
            int i = 0;
            while (i < rOSpecs.size()) {
                Map rOSpecParam = (Map)rOSpecs.get(i);
                this.initROSpec(i, rOSpecParam);
                ++i;
            }
        }
    }

    public boolean isAutonomousModeOn() {
        return this.autonomousModeOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rOSpecEnded(int rOSpecId) {
        if (this.getROSpecIdManager().getOwner(rOSpecId) == this.getOwner()) {
            if (this.isLogging(4)) {
                this.log(4, "ROSpec " + rOSpecId + " ended.");
            }
            this.getROSpecIdManager().setIdStatus(rOSpecId, this.getOwner(), 12);
            if (this.getROSpecIdManager().isAllIdsStopped(this.getOwner())) {
                Byte by = this.autonomousModeMonitor;
                synchronized (by) {
                    Map rOSpecParam = this.getROSpecParameter(ParameterFactory.getROSpecIDParameter((int)rOSpecId));
                    int rOSpecStopTrigger = LLRPUtils.extractROSpecStopTrigger((Map)rOSpecParam);
                    if (rOSpecStopTrigger != 0) {
                        this.tagReading.setValue((Object)Boolean.FALSE, EpcglobalLlrpInventoryProfile.getCurrentTimestamp());
                    }
                    this.autonomousModeMonitor.notifyAll();
                    this.setAutonomousModeOn(false);
                }
            }
        }
        this.disableAccessSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rOSpecStarted(int rOSpecId) {
        if (this.getROSpecIdManager().getOwner(rOSpecId) == this.getOwner()) {
            if (this.isLogging(4)) {
                this.log(4, "ROSpec " + rOSpecId + " started.");
            }
            this.getROSpecIdManager().setIdStatus(rOSpecId, this.getOwner(), 11);
            Byte by = this.autonomousModeMonitor;
            synchronized (by) {
                if (!this.isAutonomousModeOn()) {
                    this.setAutonomousModeOn(true);
                    Map rOSpecParam = this.getROSpecParameter(ParameterFactory.getROSpecIDParameter((int)rOSpecId));
                    int rOSpecStartTrigger = LLRPUtils.extractROSpecStartTrigger((Map)rOSpecParam);
                    if (rOSpecStartTrigger != 0) {
                        this.tagReading.setValue((Object)Boolean.TRUE, EpcglobalLlrpInventoryProfile.getCurrentTimestamp());
                    }
                    this.autonomousModeMonitor.notifyAll();
                }
            }
            if (this.registerAccessSpecIds()) {
                this.enableAccessSpecs();
            }
        }
    }

    protected boolean registerAccessSpecIds() {
        List accessSpecs = this.getAccessSpecParameters();
        int i = 0;
        while (i < accessSpecs.size()) {
            Map accessSpecParam = (Map)accessSpecs.get(i);
            int accessSpecId = (Integer)accessSpecParam.get("AccessSpecID");
            Map accessSpecIdParameter = ParameterFactory.getAccessSpecIDParameter((int)accessSpecId);
            int idResult = this.getAccessSpecIdManager().registerId((Object)accessSpecIdParameter, this.getOwner());
            switch (idResult) {
                case 0: {
                    if (!this.isLogging(4) || !this.isLogging(4)) break;
                    this.log(4, "AccessSpecID " + accessSpecId + " is registered.");
                    break;
                }
                case -1: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpInventoryProfile.getCurrentTimestamp(), (Object)("AccessSpecID " + accessSpecId + " is being used by another AccessSpec."));
                    if (this.isLogging(4)) {
                        this.log(4, "AccessSpecID " + accessSpecId + " is being used by another AccessSpec.");
                    }
                    return false;
                }
                case -3: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpInventoryProfile.getCurrentTimestamp(), (Object)("AccessSpecID " + accessSpecId + " is not valid."));
                    if (this.isLogging(4)) {
                        this.log(4, "AccessSpecID " + accessSpecId + " is not valid.");
                    }
                    return false;
                }
                case -2: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpInventoryProfile.getCurrentTimestamp(), (Object)("Fail to start AccessSpecID " + accessSpecId + ", Maximum number of supported AccessSpec has been reached."));
                    if (this.isLogging(4)) {
                        this.log(4, "Fail to start AccessSpecID " + accessSpecId + ", Maximum number of supported AccessSpec has been reached.");
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean registerROSpecIds() {
        List rOSpecs = this.getROSpecParameters();
        int i = 0;
        while (i < rOSpecs.size()) {
            Map rOSpecParam = (Map)rOSpecs.get(i);
            int rOSpecId = ((Number)rOSpecParam.get("ROSpecID")).intValue();
            Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
            int idResult = this.getROSpecIdManager().registerId((Object)rOSpecIdParameter, this.getOwner());
            switch (idResult) {
                case 0: {
                    if (!this.isLogging(4)) break;
                    this.log(4, "ROSpecID " + rOSpecId + " is registered.");
                    break;
                }
                case -1: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpInventoryProfile.getCurrentTimestamp(), (Object)("ROSpecID " + rOSpecId + " is being used by another ROSpec."));
                    if (this.isLogging(4)) {
                        this.log(4, "ROSpecID " + rOSpecId + " is being used by another ROSpec.");
                    }
                    return false;
                }
                case -3: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpInventoryProfile.getCurrentTimestamp(), (Object)("ROSpecID " + rOSpecId + " is not valid."));
                    if (this.isLogging(4)) {
                        this.log(4, "ROSpecID " + rOSpecId + " is not valid.");
                    }
                    return false;
                }
                case -2: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpInventoryProfile.getCurrentTimestamp(), (Object)("Fail to start ROSpecID " + rOSpecId + ", Maximum number of supported ROSpec has been reached."));
                    if (this.isLogging(4)) {
                        this.log(4, "Fail to start ROSpecID " + rOSpecId + ", Maximum number of supported ROSpec has been reached.");
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void retryEnableAccessSpec(int accessSpecId) {
        List accessSpecs = this.getAccessSpecParameters();
        Map accessSpecParam = null;
        int serialNo = -1;
        int i = 0;
        while (i < accessSpecs.size()) {
            Map param = (Map)accessSpecs.get(i);
            if (accessSpecId == ((Number)param.get("AccessSpecID")).intValue()) {
                accessSpecParam = param;
                serialNo = i;
            }
            ++i;
        }
        if (accessSpecParam != null) {
            Map accessSpecIdParameter = ParameterFactory.getAccessSpecIDParameter((int)accessSpecId);
            this.taskPool.getEnableAccessSpecTaskArray(serialNo, accessSpecIdParameter, ParameterFactory.getAddAccessSpecCommandParameters(accessSpecParam)).start(this.getAdapterTaskManager());
        }
    }

    protected void retryStartROSpec(int rOSpecId) {
        List rOSpecs = this.getROSpecParameters();
        Map rOSpecParam = null;
        int serialNo = -1;
        int i = 0;
        while (i < rOSpecs.size()) {
            Map param = (Map)rOSpecs.get(i);
            if (rOSpecId == ((Number)param.get("ROSpecID")).intValue()) {
                rOSpecParam = param;
                serialNo = i;
            }
            ++i;
        }
        if (rOSpecParam != null) {
            Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
            Task_START_ROSPEC startROSpec = this.taskPool.getStartROSpecTask(serialNo, rOSpecIdParameter);
            startROSpec.start(this.getAdapterTaskManager());
        }
    }

    public void setAutonomousModeOn(boolean autonomousModeOn) {
        if (this.isLogging(4)) {
            this.log(4, "AutonumousMode set to " + autonomousModeOn);
        }
        this.autonomousModeOn = autonomousModeOn;
    }

    private void setTagReportData(Map reportData, String key, Object value) {
        if (value != null) {
            reportData.put(key, value);
        }
    }

    protected void startROSpecs() {
        List rOSpecs = this.getROSpecParameters();
        int i = 0;
        while (i < rOSpecs.size()) {
            int rOSpecStartTrigger;
            boolean includeStart;
            Map rOSpecParam = (Map)rOSpecs.get(i);
            int rOSpecId = ((Number)rOSpecParam.get("ROSpecID")).intValue();
            int rOSpec_status = this.getROSpecIdManager().getIdStatus(rOSpecId, this.getOwner());
            if (rOSpec_status == 10) {
                this.initROSpec(i, rOSpecParam);
            }
            boolean bl = includeStart = (rOSpecStartTrigger = LLRPUtils.extractROSpecStartTrigger((Map)rOSpecParam)) == 0;
            if (includeStart) {
                Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
                Task_START_ROSPEC startROSpec = this.taskPool.getStartROSpecTask(i, rOSpecIdParameter);
                startROSpec.start(this.getAdapterTaskManager());
            }
            ++i;
        }
    }
}

