/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.file.connection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.file.connection.service.FileConnectionService;

public class FileConnection
extends StreamConnection
implements ConnectionService,
FileConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.file.connection.FileConnection";
    private File inputFile;
    private File outputFile;

    public FileConnection() {
        this("", "input", "", "output");
    }

    public FileConnection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
    }

    public FileConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public FileConnection(File inputFile, File outputFile) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
    }

    public FileConnection(String inputPath, String inputFilename, String outputPath, String outputFilename) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("inputpath", inputPath);
        table.put("inputname", inputFilename);
        table.put("outputpath", outputPath);
        table.put("outputname", outputFilename);
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        boolean closed = this.getInputStream() == null && this.getOutputStream() == null;
        super.close();
        if (!closed) {
            this.handleError(null, 1002, this.toString());
        }
    }

    public void exit() throws IOException {
        try {
            this.close();
        }
        catch (Exception exception) {}
        this.inputFile = null;
        this.outputFile = null;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public synchronized void open() throws IOException {
        String inputPath = this.getString("inputpath", "");
        String inputFilename = this.getString("inputname", "input");
        String outputPath = this.getString("outputpath", "");
        String outputFilename = this.getString("outputname", "output");
        if (inputFilename != null) {
            if (inputPath != null && inputPath.length() > 0) {
                this.setInputFile(new File(inputPath, inputFilename));
            } else {
                this.setInputFile(new File(inputFilename));
            }
        }
        if (outputFilename != null) {
            if (outputPath != null && outputPath.length() > 0) {
                this.setOutputFile(new File(outputPath, outputFilename));
            } else {
                this.setOutputFile(new File(outputFilename));
            }
        }
        if (this.getInputFile() != null) {
            this.setInputStream(new FileInputStream(this.getInputFile()));
        }
        if (this.getOutputFile() != null) {
            this.setOutputStream(new FileOutputStream(this.getOutputFile()));
        }
        super.open();
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        if (this.inputFile != null) {
            buffer.append(',');
            buffer.append(this.inputFile);
        }
        if (this.outputFile != null) {
            buffer.append(',');
            buffer.append(this.outputFile);
        }
    }
}

