/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.agent;

import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.agent.ClassLibraryValidationTestCase;
import org.eclipse.soda.dk.platform.validation.test.agent.PlatformValidationTestAgent;
import org.eclipse.soda.dk.platform.validation.test.agent.service.OSGiValidationService;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.framework.ConfiguredTestCase;

public class OSGiValidationTestCase
extends ConfiguredTestCase {
    public static final String DEFAULT_REQUIRED_OSGI_PACKAGES = "";
    public static final String DEFAULT_REQUIRED_OSGI_SERVICES = "";
    private OSGiValidationService osgiValidationService;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.platform.validation.test.agent.OSGiValidationTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    public OSGiValidationTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        PlatformValidationTestAgent agent = (PlatformValidationTestAgent)this.getContext().getTestAgent();
        this.osgiValidationService = agent.getOSGiValidationService();
    }

    public void test000_ValidateOsgiPackages() {
        String requiredPackages = this.getString("required.osgi.packages", "");
        StringTokenizer tokenizer = new StringTokenizer(requiredPackages, ",");
        int requiredCount = tokenizer.countTokens();
        if (requiredCount > 0) {
            OSGiValidationTestCase.assertNotNull((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7407)), (Object)this.osgiValidationService);
            int passedCount = 0;
            while (tokenizer.hasMoreTokens()) {
                String minimumVersion;
                String packageName;
                String packageNameAndVersion = tokenizer.nextToken().trim();
                int pos = packageNameAndVersion.indexOf(59);
                if (pos == -1) {
                    packageName = packageNameAndVersion;
                    minimumVersion = null;
                } else {
                    packageName = packageNameAndVersion.substring(0, pos).trim();
                    minimumVersion = packageNameAndVersion.substring(pos + 1).trim();
                }
                try {
                    String actualVersion = this.osgiValidationService.getPackageVersion(packageName);
                    if (actualVersion == null) {
                        this.getContext().log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7408)), (Object)packageName));
                        continue;
                    }
                    if (ClassLibraryValidationTestCase.checkVersion(actualVersion, minimumVersion)) {
                        ++passedCount;
                        continue;
                    }
                    Object[] parms = new Object[]{packageName, actualVersion, minimumVersion};
                    this.getContext().log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7409)), (Object[])parms));
                }
                catch (Exception e) {
                    this.getContext().log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7410)), (Object)packageNameAndVersion), (Throwable)e);
                }
            }
            Object[] parms = new Object[]{Integer.toString(passedCount), Integer.toString(requiredCount)};
            this.getContext().log(3, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7411)), (Object[])parms));
            OSGiValidationTestCase.assertEquals((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7412)), (int)requiredCount, (int)passedCount);
        }
    }

    public void test001_ValidateOsgiServices() throws IOException, ClassNotFoundException {
        String requiredServices = this.getString("required.osgi.services", "");
        StringTokenizer tokenizer = new StringTokenizer(requiredServices, ",");
        int requiredCount = tokenizer.countTokens();
        if (requiredCount > 0) {
            OSGiValidationTestCase.assertNotNull((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7407)), (Object)this.osgiValidationService);
            int passedCount = 0;
            while (tokenizer.hasMoreTokens()) {
                String filter;
                String serviceClass;
                String serviceClassAndFilter = tokenizer.nextToken().trim();
                int pos = serviceClassAndFilter.indexOf(59);
                if (pos == -1) {
                    serviceClass = serviceClassAndFilter;
                    filter = null;
                } else {
                    serviceClass = serviceClassAndFilter.substring(0, pos).trim();
                    filter = serviceClassAndFilter.substring(pos + 1).trim();
                }
                try {
                    if (this.osgiValidationService.isServiceAvailable(serviceClass, filter)) {
                        ++passedCount;
                        continue;
                    }
                    this.getContext().log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7413)), (Object)serviceClassAndFilter));
                }
                catch (Exception e) {
                    this.getContext().log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7414)), (Object)serviceClassAndFilter), (Throwable)e);
                }
            }
            Object[] parms = new Object[]{Integer.toString(passedCount), Integer.toString(requiredCount)};
            this.getContext().log(3, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7415)), (Object[])parms));
            OSGiValidationTestCase.assertEquals((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7416)), (int)requiredCount, (int)passedCount);
        }
    }
}

