/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.profile.testcases;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.rfid.inventory.profile.testcases.RfidInventoryProfileTester;

public class RfidInventoryTestcaseSingle
extends TestCase
implements NotificationListener {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.rfid.inventory.profile.testcases.RfidInventoryTestcaseSingle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public RfidInventoryTestcaseSingle(String name) {
        super(name);
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("Notification: ");
        buffer.append(externalKey);
        buffer.append(" data: ");
        Nls.formatData((StringBuffer)buffer, (Object)data, (int)0, (int)100, (int)10);
        System.out.println(buffer.toString());
    }

    public void runTest01(NotificationService notificationService, RfidInventoryProfileTester rfidInventoryProfileTester) {
        boolean reportTags = false;
        rfidInventoryProfileTester.autonomousModeOn();
        HashMap<String, Object> value = new HashMap<String, Object>();
        HashMap tags = new HashMap();
        value.put("reader", "R1");
        value.put("peakRSSI", new Integer(0));
        value.put("antenna", new Integer(1));
        value.put("C1G2PC", new Integer(257));
        value.put("C1G2CRC", new Integer(772));
        if (!reportTags) {
            rfidInventoryProfileTester.notifyTagRead("123456", value, new Integer(100));
        }
        tags.put("123456", value);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        Hashtable data = new Hashtable();
        HashMap<String, Integer> position = new HashMap<String, Integer>();
        position.put("latitude", new Integer(1));
        position.put("longitude", new Integer(2));
        data.put("value", position);
        notificationService.broadcast("Position/Coordinate", data);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        HashMap<String, Object> value1 = new HashMap<String, Object>();
        value1.put("reader", "R1");
        value1.put("peakRSSI", new Integer(-1));
        value1.put("antenna", new Integer(2));
        if (!reportTags) {
            rfidInventoryProfileTester.notifyTagRead("123456", value1, new Integer(101));
        }
        tags.put("123456", value1);
        HashMap<String, Object> value2 = new HashMap<String, Object>();
        value2.put("reader", "R1");
        value2.put("peakRSSI", new Integer(-2));
        value2.put("antenna", new Integer(2));
        value2.put("userdata", "user data 2");
        value2.put("C1G2PC", new Integer(257));
        value2.put("C1G2CRC", new Integer(772));
        if (!reportTags) {
            rfidInventoryProfileTester.notifyTagRead("123456", value2, new Integer(102));
        }
        tags.put("123456", value2);
        HashMap<String, Object> value3 = new HashMap<String, Object>();
        value3.put("reader", "R1");
        value3.put("peakRSSI", new Integer(-3));
        value3.put("antenna", new Integer(3));
        value3.put("C1G2PC", new Integer(257));
        value3.put("C1G2CRC", new Integer(772));
        if (!reportTags) {
            rfidInventoryProfileTester.notifyTagRead("123456", value3, new Integer(103));
        }
        tags.put("123456", value3);
        HashMap<String, Object> value4 = new HashMap<String, Object>();
        value4.put("reader", "R1");
        value4.put("peakRSSI", new Integer(-4));
        value4.put("antenna", new Integer(3));
        value4.put("C1G2PC", new Integer(257));
        value4.put("C1G2CRC", new Integer(772));
        if (!reportTags) {
            rfidInventoryProfileTester.notifyTagRead("456789", new HashMap(value4), new Integer(103));
        }
        tags.put("456789", new HashMap(value4));
        if (reportTags) {
            rfidInventoryProfileTester.notifyTagRead(tags, new Integer(104));
        }
        rfidInventoryProfileTester.autonomousModeOff();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void test01() {
        NotificationService notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        RfidInventoryProfileTester rfidInventoryProfileTester = new RfidInventoryProfileTester(1);
        rfidInventoryProfileTester.setNotificationService(notificationService);
        this.runTest01(notificationService, rfidInventoryProfileTester);
        notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        rfidInventoryProfileTester = new RfidInventoryProfileTester(10);
        rfidInventoryProfileTester.setNotificationService(notificationService);
        this.runTest01(notificationService, rfidInventoryProfileTester);
        notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        rfidInventoryProfileTester = new RfidInventoryProfileTester();
        rfidInventoryProfileTester.setNotificationService(notificationService);
        this.runTest01(notificationService, rfidInventoryProfileTester);
    }
}

