/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Iterator;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.TestAction;
import org.eclipse.soda.dk.testmanager.action.TestRunListener;
import org.eclipse.soda.dk.testmanager.action.TestTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.osgi.framework.InvalidSyntaxException;

public class SequentialTestAction
extends TestAction {
    public SequentialTestAction(String id) {
        super(id);
    }

    public void execute(TestScriptService testScript) throws InterruptedException {
        Iterator iterator = this.getTestTemplatesAndActions().iterator();
        while (iterator.hasNext() && !testScript.getDistributedTestSession().isInterrupted()) {
            this.executeTemplateOrAction(testScript, iterator.next());
        }
    }

    protected void execute(TestScriptService testScript, TestTemplate template) throws InvalidSyntaxException, IOException, InterruptedException {
        String controllerId = template.getControllerId();
        String runId = template.getId();
        String filter = template.getFilter();
        String className = template.getClassName();
        String matchType = template.getMatchType();
        Dictionary properties = template.getProperties();
        TestSessionService testSession = this.getTestSession(testScript, controllerId);
        TestRunListener runListener = new TestRunListener(testScript.getTestStatistics());
        String actionId = template.getParentAction().getId();
        if (testSession != null) {
            if ("multiple".equals(matchType)) {
                Object[] parms = new Object[]{this.getMatchDescription(filter, className)};
                testScript.getScriptListener().scriptActionInfo(actionId, Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7160)), (Object[])parms));
                testSession.runMultipleTests(actionId, runId, filter, className, properties, (TestRunListenerService)runListener);
            } else if (matchType == null || "single".equals(matchType)) {
                Object[] parms = new Object[]{this.getMatchDescription(filter, className)};
                testScript.getScriptListener().scriptActionInfo(actionId, Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7161)), (Object[])parms));
                testSession.runSingleTest(actionId, runId, filter, className, properties, (TestRunListenerService)runListener);
            } else {
                Object[] parms1 = new Object[]{this.getDescription()};
                Object[] parms2 = new Object[]{matchType};
                testScript.getScriptListener().scriptActionError(actionId, Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7188)), (Object[])parms1), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7193)), (Object[])parms2));
            }
        }
    }

    protected String getName() {
        return TestManager.DefaultResourceBundle.getString(Integer.toString(7157));
    }
}

