/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.ControllerQueue;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.osgi.service.log.LogService;

public class Controller
extends ControllerQueue
implements ControllerService,
Runnable {
    public static final int MESSAGE_STATUS_UNKNOWN = 0;
    public static final int MESSAGE_STATUS_OK = 1;
    public static final int MESSAGE_STATUS_ERROR = 2;
    private static final long serialVersionUID = -8946351256395220870L;
    public static final Integer TRANSPORT_STARTED_NO_OUTPUT = EscObject.createInteger((int)-5);
    public static final Integer TRANSPORT_STARTED_VALUE = EscObject.createInteger((int)5);
    private final Object messageReceived = new Object();
    private int queueSizeProblem = 2048;
    private boolean running = false;
    private Thread thread;
    private Transport transport;

    public Controller(Transport transport, int priority) {
        this.transport = transport;
        this.thread = new Thread((Runnable)this, transport.getOutputName());
        this.thread.setDaemon(true);
        this.thread.setPriority(priority);
    }

    protected void enqueueRestartTransport() {
        this.enqueue(EscObject.getCurrentTimestamp(), TRANSPORT_STARTED_VALUE);
    }

    protected void enqueueRestartTransportNoOutput() {
        this.enqueue(EscObject.getCurrentTimestamp(), TRANSPORT_STARTED_NO_OUTPUT);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        if (data == null) {
            this.enqueue(timestamp, source);
        } else {
            this.enqueue(timestamp, new Object[]{source, data});
        }
    }

    public void errorOccurredSend(Object source, Object timestamp, Object data) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.errorOccurred((Object)this, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.transport.handleError(exception, 2022);
            }
        }
    }

    public int getQueueSizeProblem() {
        return this.queueSizeProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        block12: {
            try {
                Object object = this.messageReceived;
                synchronized (object) {
                    this.messageReceived.notifyAll();
                }
                if (this.transport.getState() < 5) {
                    this.transport.startupMessageReceived(this.transport, timestamp, message);
                    if (EscObject.getTraceLevel() >= 5) {
                        this.transport.report(null, 2025, message, this.transport.getHistory());
                    }
                } else if (this.transport.getTransportListener() != null) {
                    if (this.transport.getInterestMask().isInterested(message)) {
                        this.enqueue(timestamp, message);
                    } else if (EscObject.getTraceLevel() >= 5) {
                        this.transport.report(null, 2026, message);
                    }
                }
            }
            catch (RuntimeException exception) {
                if (!this.transport.isLogging(1)) break block12;
                this.transport.handleError(exception, 2019);
            }
        }
    }

    public void restartTransport() {
        int count = this.size();
        if (count > 0) {
            int index = 0;
            while (index < count) {
                Object[] objects = new Object[2];
                this.getFirst(objects);
                if (objects[0] != null && (objects[1] instanceof Boolean || objects[1] instanceof Integer)) {
                    return;
                }
                ++index;
            }
        }
        this.enqueueRestartTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int messageStatus = 0;
        while (this.running) {
            Object[] objects;
            block47: {
                block48: {
                    block49: {
                        objects = new Object[2];
                        this.getFirst(objects);
                        if (objects[0] != null) break block47;
                        int inputMessageCount = this.transport.getInputMessageCount();
                        try {
                            Controller controller = this;
                            synchronized (controller) {
                                this.getFirst(objects);
                                if (objects[0] == null) {
                                    this.wait(this.transport.getNoActivityTimeout());
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        if (!this.running) {
                            return;
                        }
                        this.getFirst(objects);
                        if (objects[0] != null) break block47;
                        if (!this.running) break block48;
                        int inputMessageCountNew = this.transport.getInputMessageCount();
                        if (inputMessageCountNew != inputMessageCount) break block49;
                        int status = this.transport.noActivityProcessing();
                        switch (status) {
                            case 0: {
                                if (messageStatus != 2) {
                                    this.transport.report(null, 2037, Controller.createNumber((long)this.transport.getNoActivityTimeout()), this.transport.getHistory());
                                    messageStatus = 2;
                                    if (this.transport.getState() == 5) {
                                        this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                        break;
                                    }
                                }
                                break block48;
                            }
                            case 1: {
                                if (inputMessageCountNew == inputMessageCount) {
                                    Object object = this.messageReceived;
                                    synchronized (object) {
                                        try {
                                            this.messageReceived.wait(this.transport.getRetryTime());
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                                messageStatus = 2;
                                inputMessageCountNew = this.transport.getInputMessageCount();
                                if (inputMessageCountNew == inputMessageCount) {
                                    this.restartTransport();
                                    break;
                                }
                                if (this.transport.getState() == 5) {
                                    this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                    break;
                                }
                                break block48;
                            }
                            case 2: {
                                messageStatus = 2;
                                this.restartTransport();
                            }
                        }
                        break block48;
                    }
                    messageStatus = 1;
                }
                this.getFirst(objects);
            }
            while (objects[0] != null) {
                if (!this.running) {
                    return;
                }
                Object timestamp = objects[0];
                Object object = objects[1];
                if (object instanceof MessageService) {
                    MessageService message = (MessageService)objects[1];
                    if (timestamp == null) {
                        this.transport.send(message);
                    } else {
                        TransportListener listener = this.transport.getTransportListener();
                        messageStatus = 1;
                        if (listener != null) {
                            try {
                                listener.messageReceived((TransportService)this.transport, timestamp, message);
                            }
                            catch (RuntimeException exception) {
                                this.handleError(exception, 1);
                            }
                            if (EscObject.getTraceLevel() >= 5 && this.transport.isLogging(this.transport.getErrorSeverity(2023, null))) {
                                this.transport.report(null, 2023, message, this.transport.getHistory());
                            }
                        }
                    }
                } else if (object instanceof Boolean) {
                    boolean output = (Boolean)object;
                    this.startProcessing(output);
                } else if (object instanceof String) {
                    LogService logService = this.transport.getLogService();
                    logService.log(4, object.toString());
                } else if (object instanceof Integer) {
                    int data0 = (Integer)object;
                    boolean output = data0 >= 0;
                    this.dequeueFirst();
                    object = null;
                    this.transport.restartProcessing(output);
                } else if (object instanceof int[]) {
                    int[] intData = (int[])object;
                    int newState = intData[0];
                    int oldState = intData[1];
                    this.transportChangedSend(this.transport, timestamp, newState, oldState);
                } else {
                    TransportListener listener = this.transport.getTransportListener();
                    if (listener != null) {
                        if (object instanceof TransportService) {
                            this.errorOccurredSend(object, timestamp, null);
                        } else if (object instanceof Object[]) {
                            Object[] objectsData = (Object[])object;
                            Object source = objectsData[0];
                            Object data = objectsData[1];
                            this.errorOccurredSend(source, timestamp, data);
                        }
                    }
                }
                if (object != null) {
                    this.dequeueFirst();
                }
                this.getFirst(objects);
            }
        }
    }

    public void setQueueSizeProblem(int queueSizeProblem) {
        this.queueSizeProblem = queueSizeProblem;
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    public void start(boolean output) {
        if (output) {
            this.enqueue(EscObject.getCurrentTimestamp(), Boolean.TRUE);
        } else {
            this.enqueue(EscObject.getCurrentTimestamp(), Boolean.FALSE);
        }
    }

    /*
     * Exception decompiling
     */
    public void startProcessing(boolean output) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(10000L);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (InterruptedException interruptedException) {}
            this.thread = null;
        }
    }

    public void stop(boolean output) {
    }

    public void trace(String debugMessage) {
        this.enqueue(EscObject.getCurrentTimestamp(), debugMessage);
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        if (Thread.currentThread() == this.thread) {
            this.transportChangedSend(transportService, timestamp, newState, oldState);
        } else {
            this.enqueue(timestamp, new int[]{newState, oldState});
        }
    }

    public void transportChangedSend(TransportService source, Object timestamp, int newState, int oldState) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.transportChanged(source, timestamp, newState, oldState);
            }
            catch (RuntimeException exception) {
                this.transport.handleError(exception, 2018);
            }
        }
        if (newState == 0) {
            this.stop();
        }
    }
}

