/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;

public class ControllerQueue
extends EscObject {
    protected Object[] elementsData;
    protected Object[] elementsTimestamp;
    private int head = 0;
    private int length;
    protected int maxQueueSize = 0;
    private int size = 0;
    private int tail = 0;

    public ControllerQueue() {
        this(64);
    }

    public ControllerQueue(int size) {
        this.elementsTimestamp = new Object[size];
        this.elementsData = new Object[size];
        this.length = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(long time, Object[] object) {
        ControllerQueue controllerQueue = this;
        synchronized (controllerQueue) {
            if (this.size == 0) {
                try {
                    ((Object)((Object)this)).wait(time);
                }
                catch (InterruptedException interruptedException) {
                    object[0] = null;
                    object[1] = null;
                    return;
                }
            }
            if (this.size > 0) {
                object[0] = this.elementsTimestamp[this.head];
                object[1] = this.elementsData[this.head];
                this.elementsTimestamp[this.head] = null;
                this.elementsData[this.head] = null;
                ++this.head;
                if (this.head >= this.length) {
                    this.head -= this.length;
                }
                --this.size;
                return;
            }
        }
        object[0] = null;
        object[1] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeueFirst() {
        ControllerQueue controllerQueue = this;
        synchronized (controllerQueue) {
            if (this.size > 0) {
                this.elementsTimestamp[this.head] = null;
                this.elementsData[this.head] = null;
                ++this.head;
                if (this.head >= this.length) {
                    this.head -= this.length;
                }
                --this.size;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object timestamp, Object data) {
        try {
            ControllerQueue controllerQueue = this;
            synchronized (controllerQueue) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1;
                    this.elementsTimestamp[this.head] = timestamp;
                    this.elementsData[this.head] = data;
                } else {
                    int high;
                    if (this.size >= this.length) {
                        this.handleFull();
                    }
                    if ((high = this.tail - 1) < 0) {
                        high = this.length + high;
                    }
                    this.elementsTimestamp[this.tail] = timestamp;
                    this.elementsData[this.tail] = data;
                    ++this.tail;
                    if (this.tail >= this.length) {
                        this.tail -= this.length;
                    }
                }
                ++this.size;
                if (this.size > this.maxQueueSize) {
                    this.maxQueueSize = this.size;
                }
                ((Object)((Object)this)).notifyAll();
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFirst(Object[] objects) {
        ControllerQueue controllerQueue = this;
        synchronized (controllerQueue) {
            if (this.size > 0) {
                objects[0] = this.elementsTimestamp[this.head];
                objects[1] = this.elementsData[this.head];
                return;
            }
        }
        objects[0] = null;
        objects[1] = null;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getMaxSize() {
        return this.length;
    }

    public synchronized void handleFull() {
        Object[] newElementsTimestamp = new Object[this.size << 1];
        Object[] newElementsData = new Object[this.size << 1];
        if (this.head == 0) {
            System.arraycopy(this.elementsData, 0, newElementsData, 0, this.size);
            System.arraycopy(this.elementsTimestamp, 0, newElementsTimestamp, 0, this.size);
        } else {
            int delta = this.size - this.head;
            System.arraycopy(this.elementsTimestamp, this.head, newElementsTimestamp, 0, delta);
            System.arraycopy(this.elementsTimestamp, 0, newElementsTimestamp, delta, this.size - delta);
            System.arraycopy(this.elementsData, this.head, newElementsData, 0, delta);
            System.arraycopy(this.elementsData, 0, newElementsData, delta, this.size - delta);
            this.head = 0;
        }
        this.tail = this.size;
        this.elementsTimestamp = newElementsTimestamp;
        this.elementsData = newElementsData;
        this.length = this.elementsData.length;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer((this.size << 6) + 2);
        buffer.append('{');
        boolean first = true;
        int count = 0;
        while (count < this.size) {
            Object timestamp;
            int i = this.head + count;
            if (i >= this.length) {
                i -= this.length;
            }
            if ((timestamp = this.elementsTimestamp[i]) != null) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                buffer.append('[');
                buffer.append(timestamp);
                buffer.append(',');
                Object data = this.elementsData[i];
                buffer.append(data);
                buffer.append(']');
            } else {
                buffer.append(", NULL");
            }
            ++count;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

