/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.Controller;
import org.eclipse.soda.dk.transport.HistoryQueue;
import org.eclipse.soda.dk.transport.TransportListeners;
import org.eclipse.soda.dk.transport.TransportResourceBundle;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Transport
extends EscObject
implements TransportService,
ConfigurationService {
    public static final int NO_ACTIVITY_STATUS_UNKNOWN = 0;
    public static final int NO_ACTIVITY_STATUS_MESSAGE_SENT = 1;
    public static final int NO_ACTIVITY_STATUS_ERROR = 2;
    private static final int ACTIVE_MASK = 65536;
    private static final int ACTIVE_RESET = -65537;
    private static final int ACTIVE_SET = 65536;
    protected static final int BAD_CHECKSUM_RESOURCE = 2007;
    protected static final int CLONE_EXCEPTION_RESOURCE = 3;
    protected static final int CLOSE_EXCEPTION_RESOURCE = 2017;
    protected static final int CONFIGURATION_ERROR_RESOURCE = 2038;
    public static final int CONFIGURATION_MISMATCH_RESOURCE = 2027;
    protected static final int CONNECTION_IN_USE_EXCEPTION_RESOURCE = 2029;
    public static final char CR = '\r';
    public static final long NO_ACTIVITY_TIMEOUT_DEFAULT = 10000L;
    public static final long DEFAULT_NO_ACTIVITY_TIMEOUT = 10000L;
    public static final long RETRY_TIME_DEFAULT = 1000L;
    public static final long DEFAULT_RETRY_TIME = 1000L;
    public static final int TRANSMIT_RETRIES_DEFAULT = 0;
    private static final int ECHO_MASK = 0x100000;
    private static final int ECHO_RESET = -1048577;
    private static final int ECHO_SET = 0x100000;
    public static final int ERROR_OCCURRED_EXCEPTION_RESOURCE = 2022;
    public static final int ERROR_ON_BUS_RESOURCE = 2020;
    protected static final int EXCEPTION_NO_RESPONSE_RESOURCE = 2039;
    protected static final int INTERRUPT_BEFORE_WRITE_RESOURCE = 2035;
    protected static final int INVALID_MESSAGE_RESOURCE = 2006;
    protected static final int INVALID_SEQUENCE_RESOURCE = 2033;
    public static final char LF = '\n';
    public static final int MESSAGE_FILTERED_RESOURCE = 2026;
    public static final int MESSAGE_RECEIVED_EXCEPTION_RESOURCE = 2019;
    public static final int MESSAGE_RECEIVED_RESOURCE = 2023;
    public static final int MESSAGE_SENT_RESOURCE = 2024;
    protected static final int NACK_RECEIVED_RESOURCE = 2036;
    protected static final int NO_ACTIVITY_RESOURCE = 2037;
    protected static final int PROCESS_INPUT_EXCEPTION_RESOURCE = 2015;
    protected static final int QUEUE_TOO_BIG_RESOURCE = 2034;
    private static final int RECEIVING_DATA = 262144;
    private static final int RECEIVING_DATA_RESET = -262145;
    private static final int RECEIVING_DATA_SET = 458752;
    private static final int RECEIVING_GOOD_DATA = 524288;
    private static final int RECEIVING_GOOD_DATA_RESET = -524289;
    private static final int RECEIVING_GOOD_DATA_SET = 983040;
    private static final int RECEIVING_INPUT = 131072;
    private static final int RECEIVING_INPUT_RESET = -131073;
    private static final int RECEIVING_INPUT_SET = 196608;
    public static final int RECONNECT_RESOURCE = 2028;
    protected static final int RUN_EXCEPTION_RESOURCE = 2013;
    protected static final int SEND_EXCEPTION_RESOURCE = 2012;
    protected static final int SEND_NOT_STARTED_EXCEPTION_RESOURCE = 2014;
    protected static final int SHUTDOWN_EXCEPTION_RESOURCE = 2011;
    protected static final int STARTUP_EXCEPTION_RESOURCE = 2010;
    public static final int STARTUP_MESSAGE_RECEIVED_RESOURCE = 2025;
    public static final String[] STATE_STRINGS = new String[]{"DEAD", "CREATED", "ALIVE", "CONNECTED", "ACTIVE", "STARTED"};
    protected static final int TRANSPORT_ACTIVE_STATE_RESOURCE = 2004;
    protected static final int TRANSPORT_ALIVE_STATE_RESOURCE = 2002;
    protected static final int TRANSPORT_CHANGED_EXCEPTION_RESOURCE = 2018;
    protected static final int TRANSPORT_CONNECTED_STATE_RESOURCE = 2003;
    protected static final int TRANSPORT_CREATED_STATE_RESOURCE = 2001;
    protected static final int TRANSPORT_DEAD_STATE_RESOURCE = 2000;
    public static final int TRANSPORT_ERROR_RESOURCE = 2016;
    protected static final int TRANSPORT_STARTED_STATE_RESOURCE = 2005;
    public static final int TRANSPORT_STARTUP_EXCEPTION_RESOURCE = 2009;
    protected static final int[] TRANSPORT_STATE_RESOURCE_TABLE = new int[]{2000, 2001, 2002, 2003, 2004, 2005};
    public static final int UNABLE_TO_CONNECTION_TO_BUS_RESOURCE = 2021;
    protected static final int UNKNOWN_ERROR = 0;
    protected static final int WRITE_EXCEPTION_RESOURCE = 2030;
    protected static final int WRITE_INTERRUPT_PENDING_RESOURCE = 2032;
    protected static final int WRITE_INTERRUPT_RESOURCE = 2031;
    private static ResourceBundle DefaultResourceBundle;
    private ConfigurationService configurationService = null;
    private ControllerService controller;
    protected int errorCount = 0;
    protected HistoryQueue history = new HistoryQueue();
    private int information;
    protected int inputMessageCount = 0;
    private InterestMasks interestMask = new InterestMasks();
    protected long noActivityTimeout = Transport.getStaticLong((String)"transport.noactivitytimeout", (long)10000L);
    protected NotificationService notificationService = null;
    protected String prefixMetrics = "Transport/Metrics";
    protected String prefixStatus = "Transport/Status";
    protected long retryTime = Transport.getStaticLong((String)"transport.retrytime", (long)1000L);
    private int transmitRetries = Transport.getStaticInt((String)"transport.transmitretries", (int)0);
    protected int sentMessageCount = 0;
    private int state = 1;
    protected final Object stateChanaged = new Object();
    protected long stateChangeCount = 0L;
    private TransportListener transportListener;
    private final Object transportListenerSync = new Object();
    protected int logLevel = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transport.TransportResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public Transport() {
        this(0);
    }

    public Transport(short style) {
        this.setTransportListener(null);
        this.setStyle(style);
    }

    public void addHistory(Object timestamp, Object object) {
        if (this.history != null) {
            this.history.enqueue(timestamp, object);
        }
    }

    public void addInterest(InterestService interest) {
        this.getInterestMask().add(interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransportListener(TransportListener transportListener) {
        Object object = this.transportListenerSync;
        synchronized (object) {
            this.setTransportListener(TransportListeners.add(this.transportListener, transportListener));
        }
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 2006: {
                return true;
            }
            case 2007: {
                return true;
            }
            case 2015: {
                return true;
            }
            case 2017: {
                return true;
            }
            case 2018: {
                return true;
            }
        }
        return super.attemptRecoveryFromError(errorNumber, error);
    }

    public void broadcastMetrics(TransportService source, Object timestamp) {
        NotificationService notificationService = this.getNotificationService();
        if (notificationService != null) {
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("timestamp", timestamp);
            if (Transport.isBackward()) {
                map.put("source", source.toString());
            }
            map.put("inputMessageCount", Transport.createNumber((long)this.getInputMessageCount()));
            map.put("errorCount", Transport.createNumber((long)this.getErrorCount()));
            notificationService.broadcast(this.prefixMetrics, map);
        }
    }

    public void broadcastStatus(TransportService source, Object timestamp, int newState, int oldState) {
        NotificationService notificationService = this.getNotificationService();
        if (notificationService != null) {
            Dictionary configuration;
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("state", Transport.createInteger((int)newState));
            if (oldState != Integer.MIN_VALUE) {
                map.put("stateOld", Transport.createInteger((int)oldState));
            }
            map.put("timestamp", timestamp);
            if (Transport.isBackward()) {
                map.put("source", source.toString());
            }
            if ((configuration = this.getConfigurationInformation()) != null) {
                map.put("configuration", configuration);
            }
            notificationService.broadcast(this.prefixStatus, map);
        }
    }

    public void close() {
    }

    public void configure() throws Exception {
    }

    public void connect() throws Exception {
        this.setState(3);
    }

    public ControllerService createController() {
        return new Controller(this, this.getNotificationPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (this.getState() > 0) {
            Transport transport = this;
            synchronized (transport) {
                this.stop();
                this.setState(0);
                this.setNotificationService(null);
                ControllerService controller = this.getController();
                if (controller != null) {
                    controller.stop();
                    this.setController(null);
                    this.setTransportListener(null);
                    this.setConfigurationInformation(null);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.getState() > 0) {
            this.exit();
        }
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        this.updateErrorCount();
        this.getController().errorOccurred((Object)this, timestamp, data);
    }

    public void fireMessageReceived(Object timestamp, MessageService message) {
        this.updateInputMessageCount();
        Object currentTimestamp = timestamp != null ? timestamp : Transport.getCurrentTimestamp();
        this.getController().messageReceived((TransportService)this, currentTimestamp, message);
        this.addHistory(currentTimestamp, message);
    }

    public void fireTransportChanged(TransportService source, Object timestamp, int newState, int oldState) {
        ControllerService controllerService = this.getController();
        if (controllerService != null) {
            controllerService.transportChanged((TransportService)this, timestamp, newState, oldState);
        }
        this.broadcastStatus(source, timestamp, newState, oldState);
        if (oldState == 5) {
            this.broadcastMetrics(source, timestamp);
        }
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        if (this.configurationService == null) {
            return null;
        }
        return this.getConfigurationInformation().get(propertyName);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public ConnectionService getConnection() {
        return null;
    }

    public ControllerService getController() {
        return this.controller;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 2005: {
                return 3;
            }
            case 2027: 
            case 2028: 
            case 2029: 
            case 2031: 
            case 2032: 
            case 2035: {
                return 2;
            }
            case 0: 
            case 3: 
            case 2006: 
            case 2007: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: 
            case 2013: 
            case 2015: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2030: 
            case 2034: {
                return 1;
            }
            case 2: 
            case 2037: {
                return 3;
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2014: 
            case 2025: 
            case 2026: {
                return 4;
            }
            case 2023: 
            case 2024: {
                return 5;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public HistoryQueue getHistory() {
        return this.history;
    }

    protected int getInformation() {
        return this.information;
    }

    public int getInputMessageCount() {
        return this.inputMessageCount;
    }

    public InterestMasks getInterestMask() {
        return this.interestMask;
    }

    public String getKey() {
        String outputName = ((Object)((Object)this)).getClass().getName();
        int index = outputName.lastIndexOf(46);
        if (index > 0) {
            return outputName.substring(index + 1);
        }
        return outputName;
    }

    public Object getLogDetails4() {
        return String.valueOf(this.getConnection());
    }

    public Object getLogDetails5() {
        return String.valueOf((Object)this);
    }

    public int getLogLevel() {
        if (this.logLevel == 0) {
            return super.getLogLevel();
        }
        return this.logLevel;
    }

    public long getNoActivityTimeout() {
        return this.noActivityTimeout;
    }

    public int getNotificationPriority() {
        return this.getPriority() - 1;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public String getPrefix() {
        return this.getString("prefix", "");
    }

    public int getPriority() {
        int priority = this.getInformation() & 0xF;
        if (priority == 0) {
            return 7;
        }
        return priority;
    }

    public Dictionary getProperties() {
        if (this.configurationService == null) {
            return EscConfiguration.getConfiguration().getProperties();
        }
        return this.configurationService.getProperties();
    }

    public String getQualifiedKey() {
        return this.getKey();
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(TransportResourceBundle.getKey(resourceId));
        }
        catch (RuntimeException runtimeException) {
            return super.getResource(resourceId);
        }
    }

    public long getRetryTime() {
        return this.retryTime;
    }

    public int getSentMessageCount() {
        return this.sentMessageCount;
    }

    public int getState() {
        return this.state;
    }

    public long getStateChangeCount() {
        return this.stateChangeCount;
    }

    public String getString(String key, String defaultString) {
        if (this.configurationService != null) {
            return this.configurationService.getString(key, super.getString(key, defaultString));
        }
        return super.getString(key, defaultString);
    }

    public short getStyle() {
        return (short)this.getInformation();
    }

    public int getTransmitRetries() {
        return this.transmitRetries;
    }

    protected TransportListener getTransportListener() {
        return this.transportListener;
    }

    protected void handleError(Throwable error, int resourceId, Object[] objects) {
        if (this.hasListeners()) {
            if (error != null) {
                this.fireErrorOccurred(Transport.getCurrentTimestamp(), error);
            } else {
                this.fireErrorOccurred(Transport.getCurrentTimestamp(), this.createException(resourceId, objects));
            }
        }
        super.handleError(error, resourceId, objects);
    }

    public boolean hasListeners() {
        return this.getTransportListener() != null;
    }

    public boolean isActive() {
        return this.getState() >= 4;
    }

    public boolean isEcho() {
        return (this.getInformation() & 0x100000) != 0;
    }

    public boolean isReceivingData() {
        return (this.getInformation() & 0x40000) != 0;
    }

    public boolean isReceivingGoodData() {
        return (this.getInformation() & 0x80000) != 0;
    }

    public boolean isReceivingInput() {
        return (this.getInformation() & 0x20000) != 0;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public void log(int severity, String message, Throwable exception) {
        if (Transport.shouldLog((int)severity)) {
            ControllerService controllerService;
            if (severity == 5 && (controllerService = this.getController()) != null) {
                controllerService.trace(message);
                return;
            }
            super.log(severity, message, exception);
        }
    }

    public int noActivityProcessing() {
        int state = this.getState();
        if (state == 5) {
            MessageService message;
            block4: {
                try {
                    message = this.noActivityProcessingMessage();
                    if (message != null) break block4;
                    this.broadcastMetrics(this, EscObject.getCurrentTimestamp());
                    return 0;
                }
                catch (Exception exception) {
                    return 2;
                }
            }
            this.write(message);
            this.broadcastMetrics(this, EscObject.getCurrentTimestamp());
            return 1;
        }
        return 0;
    }

    public MessageService noActivityProcessingMessage() {
        return null;
    }

    public String prependPrefix(String topic) {
        return this.prependPrefix(this.getPrefix(), topic);
    }

    public String prependPrefix(String topicPrefix, String topic) {
        if (topicPrefix.length() == 0) {
            return topic;
        }
        StringBuffer result = new StringBuffer(topicPrefix.length() + topic.length() + 1);
        result.append(topicPrefix);
        result.append('/');
        result.append(topic);
        return result.toString();
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    protected int read(byte[] bytes, int offset, int length) throws IOException {
        return 0;
    }

    public void removeInterest(InterestService interest) {
        this.getInterestMask().remove(interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransportListener(TransportListener transportListener) {
        Object object = this.transportListenerSync;
        synchronized (object) {
            this.setTransportListener(TransportListeners.remove(this.transportListener, transportListener));
        }
    }

    public void restart() {
        this.getController().restartTransport();
    }

    public void restartProcessing(boolean output) {
        this.stop();
        if (output || Transport.isTrace()) {
            this.report(null, 2028, this.getHistory());
        }
        this.start();
    }

    public void send(byte[] sendBytes) throws IOException {
        try {
            this.write(sendBytes);
        }
        catch (Exception exception) {
            this.handleError(exception, 2012, new Message(sendBytes), this.getHistory());
        }
    }

    public void send(MessageService message) {
        try {
            boolean isStarted = this.isStarted();
            if (isStarted) {
                this.updateSentMessageCount();
                if (Transport.getTraceLevel() >= 5) {
                    this.report(null, 2024, message, this.getHistory());
                }
                this.write(message);
            } else {
                this.handleError(new IllegalStateException(), 2014, message);
            }
        }
        catch (Exception exception) {
            this.handleError(exception, 2012, message, this.getHistory());
            this.restart();
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.setInformation(this.getInformation() | 0x10000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFEFFFF);
        }
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        if (configurationInformation != null) {
            this.configurationService = new EscConfiguration(configurationInformation);
            this.prefixStatus = this.prependPrefix("Transport/Status");
            this.prefixMetrics = this.prependPrefix("Transport/Metrics");
            this.setLogLevel(this.getInt("loglevel", 0));
        } else {
            this.configurationService = null;
        }
    }

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    public void setEcho(boolean echo) {
        if (echo) {
            this.setInformation(this.getInformation() | 0x100000);
        } else {
            this.setInformation(this.getInformation() & 0xFFEFFFFF);
        }
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setHistory(HistoryQueue history) {
        this.history = history;
    }

    protected void setInformation(int information) {
        this.information = information;
    }

    public void setInputMessageCount(int inputMessageCount) {
        this.inputMessageCount = inputMessageCount;
    }

    public void setInterestMask(InterestMasks interestMask) {
        this.interestMask = interestMask;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setNoActivityTimeout(long noActivityTimeout) {
        this.noActivityTimeout = noActivityTimeout;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setReceivingData() {
        this.setInformation(this.getInformation() | 0x70000);
    }

    public void setReceivingData(boolean receivingData) {
        if (receivingData) {
            this.setInformation(this.getInformation() | 0x70000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFBFFFF);
        }
    }

    public void setReceivingGoodData() {
        this.setInformation(this.getInformation() | 0xF0000);
    }

    public void setReceivingGoodData(boolean receivingGoodData) {
        if (receivingGoodData) {
            this.setInformation(this.getInformation() | 0xF0000);
        } else {
            this.setInformation(this.getInformation() & 0xFFF7FFFF);
        }
    }

    public void setReceivingInput() {
        this.setInformation(this.getInformation() | 0x30000);
    }

    public void setReceivingInput(boolean receivingInput) {
        if (receivingInput) {
            this.setInformation(this.getInformation() | 0x30000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFDFFFF);
        }
    }

    public void setRetryTime(long retryTime) {
        this.retryTime = retryTime;
    }

    public void setSentMessageCount(int sentMessageCount) {
        this.sentMessageCount = sentMessageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setState(int state) {
        if (this.state != state) {
            if (this.state > 0) {
                int oldState = this.state;
                this.state = state;
                Object object = this.stateChanaged;
                synchronized (object) {
                    this.stateChanaged.notifyAll();
                }
                ++this.stateChangeCount;
                this.fireTransportChanged(this, Transport.getCurrentTimestamp(), state, oldState);
                this.report(null, TRANSPORT_STATE_RESOURCE_TABLE[state], STATE_STRINGS[oldState], this.getConfigurationInformation());
                return;
            }
            Object object = this.stateChanaged;
            synchronized (object) {
                this.stateChanaged.notifyAll();
                return;
            }
        }
        Object object = this.stateChanaged;
        synchronized (object) {
            this.stateChanaged.notifyAll();
            return;
        }
    }

    public void setStateChangeCount(long stateChangeCount) {
        this.stateChangeCount = stateChangeCount;
    }

    public void setStyle(short style) {
        this.setInformation(this.getInformation() & 0xFFFF0000 | style);
    }

    public void setTransmitRetries(int transmitRetries) {
        this.transmitRetries = transmitRetries;
    }

    protected void setTransportListener(TransportListener transportListener) {
        this.transportListener = transportListener;
    }

    public void setup() {
        ControllerService controller = this.getController();
        if (controller == null) {
            this.setController(this.createController());
            this.getController().start();
        }
    }

    public void setupCustom() {
    }

    public void shutdown(boolean output) {
        block2: {
            try {
                this.close();
            }
            catch (RuntimeException exception) {
                if (!output && !EscObject.isTrace()) break block2;
                this.handleError(exception, 2011);
            }
        }
        this.setState(1);
    }

    public void start() {
        if (this.getState() < 5) {
            this.setup();
            this.setupCustom();
            this.start(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean output) {
        Transport transport = this;
        synchronized (transport) {
            this.setState(2);
            this.getController().start(output);
        }
    }

    public int startup(boolean output) throws Exception {
        return 5;
    }

    public void startupMessageReceived(TransportService source, Object timestamp, MessageService message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Transport transport = this;
        synchronized (transport) {
            int state = this.getState();
            if (state >= 2) {
                try {
                    if (state == 5) {
                        this.setState(4);
                    }
                    this.shutdown(true);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException((Throwable)exception);
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        buffer.append('=');
        buffer.append(STATE_STRINGS[this.state]);
        this.toStringInfo(buffer);
        buffer.append(",statechangecount=");
        buffer.append(this.getStateChangeCount());
        return buffer.toString();
    }

    public void updateErrorCount() {
        ++this.errorCount;
    }

    public int updateInputMessageCount() {
        return this.inputMessageCount++;
    }

    public void updateSentMessageCount() {
        ++this.sentMessageCount;
    }

    public int waitStateChange() {
        return this.waitStateChange(this.getRetryTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitStateChange(long timeout) {
        try {
            Object object = this.stateChanaged;
            synchronized (object) {
                this.stateChanaged.wait(timeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        return this.getState();
    }

    public void write(byte[] bytes) throws Exception {
    }

    protected void write(MessageService message) throws Exception {
        this.write(message.getBytes());
    }

    public void writeAndReport(byte[] bytes) {
        try {
            this.write(bytes);
        }
        catch (Exception exception) {
            this.handleError(exception, 2030, new Message(bytes), this.getHistory());
        }
    }

    public void writeAndReport(MessageService message) {
        try {
            this.write(message);
        }
        catch (Exception exception) {
            this.handleError(exception, 2030, message, this.getHistory());
        }
    }
}

