/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.udp.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.udp.connection.service.UdpConnectionService;

public class UdpConnection
extends Connection
implements ConnectionService,
UdpConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.udp.connection.UdpConnection";
    protected static final char[] TOSTRING_NAME = "UdpConnection[".toCharArray();
    protected DatagramSocket datagramSocket;
    protected String targetAddress = "";
    protected int targetPortNumber = -1;

    public UdpConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public UdpConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public UdpConnection(String localHost, int localPort, String targetHost, int targetPort) {
        this(localHost, localPort, targetHost, targetPort, -1, -1);
    }

    public UdpConnection(String localHost, int localPort, String targetHost, int targetPort, int sendBufferSize, int receiveBufferSize) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("localhost", localHost);
        table.put("localport", UdpConnection.createInteger((int)localPort));
        table.put("remotehost", targetHost);
        table.put("remoteport", UdpConnection.createInteger((int)targetPort));
        table.put("readsize", UdpConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", UdpConnection.createInteger((int)sendBufferSize));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        super.close();
        Exception exception = null;
        try {
            this.datagramSocket.close();
        }
        catch (Exception e) {
            exception = e;
        }
        this.report(exception, 1002, this.toString());
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    private void initDatagramSocket() throws IOException {
        int localPortNumber = this.getInt("localport", 0);
        String localAddress = this.getString("localhost", "0.0.0.0");
        int receiveBufferSize = this.getInt("readsize", -1);
        int sendBufferSize = this.getInt("writesize", -1);
        this.datagramSocket = new DatagramSocket(localPortNumber, InetAddress.getByName(localAddress));
        if (receiveBufferSize > 0) {
            this.datagramSocket.setReceiveBufferSize(receiveBufferSize);
        }
        if (sendBufferSize > 0) {
            this.datagramSocket.setSendBufferSize(sendBufferSize);
        }
    }

    public synchronized void open() throws IOException {
        if (this.datagramSocket == null) {
            this.initDatagramSocket();
        }
        super.open();
        this.targetAddress = this.getString("remotehost", "remotehost");
        this.targetPortNumber = this.getInt("remoteport", -1);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(bytes, offset, length);
        this.datagramSocket.receive(datagramPacket);
        return 0;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        buffer.append(this.getString("remotehost", "remotehost"));
        buffer.append(':');
        buffer.append(this.getInt("remoteport", -1));
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(bytes, offset, length);
        InetAddress inetAddress = InetAddress.getByName(this.targetAddress);
        datagramPacket.setAddress(inetAddress);
        datagramPacket.setPort(this.targetPortNumber);
        this.datagramSocket.send(datagramPacket);
    }
}

