/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.log.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.soda.sat.core.log.internal.ILogReaderAggregator;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class LogReaderAggregator
implements ILogReaderAggregator {
    private volatile boolean started;
    private volatile LogService consoleLog;
    private LogListener logListener;
    private List listeners;
    private List readers;

    public LogReaderAggregator() {
        this.setStarted(false);
        this.setListeners(new ArrayList(5));
        this.setReaders(new ArrayList(3));
        this.addConsoleLogListener();
    }

    private void addConsoleLogListener() {
        boolean state = Boolean.getBoolean("org.eclipse.soda.sat.core.log.to.console");
        this.setLogToConsole(state);
        LogListener listener = this.createConsoleLogListener();
        this.addLogListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(LogListener listener) {
        List listeners;
        Assertion.checkArgumentIsNotNull((Object)listener, (String)"listener");
        List list = listeners = this.getListeners();
        synchronized (list) {
            boolean exists = listeners.contains(listener);
            if (exists) {
                return;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogReaderService(LogReaderService reader) {
        Assertion.checkArgumentIsNotNull((Object)reader, (String)"reader");
        LogReaderAggregator logReaderAggregator = this;
        synchronized (logReaderAggregator) {
            List readers;
            List list = readers = this.getReaders();
            synchronized (list) {
                boolean exists = readers.contains(reader);
                if (exists) {
                    return;
                }
                readers.add(reader);
            }
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.hookLogReaderService(reader);
        }
    }

    private void basicPrintOn(StringBuffer buffer) {
        String value = super.toString();
        buffer.append((Object)value);
    }

    private void collectLogEntries(boolean inOrder, List entries, LogReaderService reader) {
        if (!inOrder) {
            this.collectLogEntries(entries, reader);
        } else {
            this.collectLogEntriesInOrder(entries, reader);
        }
    }

    private void collectLogEntries(List entries, LogReaderService reader) {
        Enumeration enumeration = reader.getLog();
        while (enumeration.hasMoreElements()) {
            LogEntry entry = (LogEntry)enumeration.nextElement();
            entries.add(entry);
        }
    }

    private void collectLogEntriesInOrder(List entries, LogReaderService reader) {
        Enumeration enumeration = reader.getLog();
        ArrayList<LogEntry> list = new ArrayList<LogEntry>(100);
        while (enumeration.hasMoreElements()) {
            LogEntry entry = (LogEntry)enumeration.nextElement();
            list.add(entry);
        }
        int size = list.size();
        int i = size - 1;
        while (i >= 0) {
            LogEntry entry = (LogEntry)list.get(i);
            entries.add(entry);
            --i;
        }
    }

    private int compare(boolean inOrder, LogEntry leftEntry, LogEntry rightEntry) {
        int comparison = inOrder ? this.compare(leftEntry, rightEntry) : this.compare(rightEntry, leftEntry);
        return comparison;
    }

    private int compare(LogEntry leftEntry, LogEntry rightEntry) {
        long leftEntryTime = leftEntry.getTime();
        long rightEntryTime = rightEntry.getTime();
        long comparison = leftEntryTime - rightEntryTime;
        int result = (int)comparison;
        return result;
    }

    private LogListener createConsoleLogListener() {
        return new LogListener(){

            public void logged(LogEntry entry) {
                LogReaderAggregator.this.logToConsole(entry);
            }
        };
    }

    private Comparator createLogEntryComparator(final boolean inOrder) {
        return new Comparator(){

            public int compare(Object left, Object right) {
                LogEntry leftEntry = (LogEntry)left;
                LogEntry rightEntry = (LogEntry)right;
                return LogReaderAggregator.this.compare(inOrder, leftEntry, rightEntry);
            }
        };
    }

    private LogListener createLogListener() {
        return new LogListener(){

            public void logged(LogEntry entry) {
                LogReaderAggregator.this.handleLogEntry(entry);
            }
        };
    }

    private void drain(LogReaderService reader) {
        LogEntry entry;
        Enumeration enumeration = reader.getLog();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(100);
        while (enumeration.hasMoreElements()) {
            entry = (LogEntry)enumeration.nextElement();
            entries.add(entry);
        }
        int size = entries.size();
        int i = size - 1;
        while (i >= 0) {
            entry = (LogEntry)entries.get(i);
            this.handleLogEntry(entry);
            --i;
        }
    }

    private LogService getConsoleLog() {
        return this.consoleLog;
    }

    private List getListeners() {
        return this.listeners;
    }

    public Enumeration getLog() {
        return this.getLog(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration getLog(boolean inOrder) {
        Vector entries;
        List readers;
        List list = readers = this.getReaders();
        synchronized (list) {
            int size = readers.size();
            int capacity = size * 100;
            entries = new Vector(capacity);
            Iterator iterator = readers.iterator();
            while (iterator.hasNext()) {
                LogReaderService reader = (LogReaderService)iterator.next();
                this.collectLogEntries(inOrder, entries, reader);
            }
        }
        Enumeration elements = entries.elements();
        Comparator comparator = this.createLogEntryComparator(inOrder);
        Collections.sort(entries, comparator);
        return elements;
    }

    public Enumeration getLogInOrder() {
        return this.getLog(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogListener getLogListener() {
        LogReaderAggregator logReaderAggregator = this;
        synchronized (logReaderAggregator) {
            if (this.logListener == null) {
                LogListener listener = this.createLogListener();
                this.setLogListener(listener);
            }
            return this.logListener;
        }
    }

    private List getReaders() {
        return this.readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLogEntry(LogEntry entry) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                LogListener listener = (LogListener)iterator.next();
                listener.logged(entry);
            }
        }
    }

    private void hookLogReaderService(LogReaderService reader) {
        LogListener listener = this.getLogListener();
        reader.addLogListener(listener);
        this.drain(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hookLogReaderServices() {
        List readers;
        List list = readers = this.getReaders();
        synchronized (list) {
            Iterator iterator = readers.iterator();
            while (iterator.hasNext()) {
                LogReaderService reader = (LogReaderService)iterator.next();
                this.hookLogReaderService(reader);
            }
        }
    }

    public boolean isLoggingToConsole() {
        LogService object = this.getConsoleLog();
        boolean state = object != null;
        return state;
    }

    private boolean isStarted() {
        return this.started;
    }

    private void logToConsole(LogEntry entry) {
        LogService log = this.getConsoleLog();
        if (log == null) {
            return;
        }
        ServiceReference reference = entry.getServiceReference();
        int level = entry.getLevel();
        String message = entry.getMessage();
        Throwable throwable = entry.getException();
        log.log(reference, level, message, throwable);
    }

    private void printConsoleLogOn(StringBuffer buffer) {
        LogService object = this.getConsoleLog();
        buffer.append(", consoleLog=");
        buffer.append(object);
    }

    private void printListenersOn(StringBuffer buffer) {
        List list = this.getListeners();
        int count = list.size();
        buffer.append(", listeners=");
        buffer.append(count);
    }

    private void printLogListenerOn(StringBuffer buffer) {
        LogListener object = this.getLogListener();
        buffer.append(", logListener=");
        buffer.append(object);
    }

    private void printOn(StringBuffer buffer) {
        this.basicPrintOn(buffer);
        this.printStartedOn(buffer);
        this.printLogListenerOn(buffer);
        this.printListenersOn(buffer);
        this.printReadersOn(buffer);
        this.printConsoleLogOn(buffer);
    }

    private void printReadersOn(StringBuffer buffer) {
        List list = this.getReaders();
        int count = list.size();
        buffer.append(", readers=");
        buffer.append(count);
    }

    private void printStartedOn(StringBuffer buffer) {
        boolean started = this.isStarted();
        buffer.append(", started=");
        buffer.append(started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(LogListener listener) {
        List listeners;
        Assertion.checkArgumentIsNotNull((Object)listener, (String)"listener");
        List list = listeners = this.getListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogReaderService(LogReaderService reader) {
        Assertion.checkArgumentIsNotNull((Object)reader, (String)"reader");
        LogReaderAggregator logReaderAggregator = this;
        synchronized (logReaderAggregator) {
            List readers;
            List list = readers = this.getReaders();
            synchronized (list) {
                boolean removed = readers.remove(reader);
                if (!removed) {
                    return;
                }
            }
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.unhookLogReaderService(reader);
        }
    }

    private void setConsoleLog(LogService consoleLog) {
        this.consoleLog = consoleLog;
    }

    private void setListeners(List listeners) {
        this.listeners = listeners;
    }

    private void setLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogToConsole(boolean logToConsole) {
        LogReaderAggregator logReaderAggregator = this;
        synchronized (logReaderAggregator) {
            LogService log;
            boolean state = this.isLoggingToConsole();
            if (logToConsole) {
                if (state) {
                    return;
                }
                FactoryUtility utility = FactoryUtility.getInstance();
                log = utility.createConsoleLog();
            } else {
                if (!state) {
                    return;
                }
                log = null;
            }
            this.setConsoleLog(log);
        }
    }

    private void setReaders(List readers) {
        this.readers = readers;
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LogReaderAggregator logReaderAggregator = this;
        synchronized (logReaderAggregator) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setStarted(true);
            this.hookLogReaderServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LogReaderAggregator logReaderAggregator = this;
        synchronized (logReaderAggregator) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.setStarted(false);
            this.unhookLogReaderServices();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(500);
        this.printOn(buffer);
        String value = buffer.toString();
        return value;
    }

    private void unhookLogReaderService(LogReaderService reader) {
        LogListener listener = this.getLogListener();
        reader.removeLogListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unhookLogReaderServices() {
        List readers;
        List list = readers = this.getReaders();
        synchronized (list) {
            Iterator iterator = readers.iterator();
            while (iterator.hasNext()) {
                LogReaderService reader = (LogReaderService)iterator.next();
                this.unhookLogReaderService(reader);
            }
        }
    }
}

