/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ConsoleLog
implements LogService {
    private static final String LOG_LEVEL_DEBUG_KEY = "Common.LogLevelDebug";
    private static final String LOG_LEVEL_ERROR_KEY = "Common.LogLevelError";
    private static final String LOG_LEVEL_INFO_KEY = "Common.LogLevelInfo";
    private static final String LOG_LEVEL_UNKNOWN_KEY = "Common.Unknown";
    private static final String LOG_LEVEL_WARNING_KEY = "Common.LogLevelWarning";
    private static final String LOG_LEVEL_DEBUG_VALUE = Messages.getString("Common.LogLevelDebug");
    private static final String LOG_LEVEL_ERROR_VALUE = Messages.getString("Common.LogLevelError");
    private static final String LOG_LEVEL_INFO_VALUE = Messages.getString("Common.LogLevelInfo");
    private static final String LOG_LEVEL_UNKNOWN_VALUE = Messages.getString("Common.Unknown");
    private static final String LOG_LEVEL_WARNING_VALUE = Messages.getString("Common.LogLevelWarning");
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private StringBuffer buffer;

    public ConsoleLog() {
        this.setBuffer(new StringBuffer(1024));
    }

    private String formatLogMessage(ServiceReference reference, int level, String message) {
        StringBuffer buffer = this.getBuffer();
        int count = buffer.length();
        buffer.delete(0, count);
        String prefix = this.getPrefix(level);
        buffer.append(prefix);
        buffer.append(' ');
        buffer.append(message);
        this.printServiceReferenceOn(buffer, reference);
        buffer.append(LINE_SEPARATOR);
        String logMessage = buffer.toString();
        return logMessage;
    }

    private StringBuffer getBuffer() {
        return this.buffer;
    }

    private String getLevelText(int level) {
        String text;
        switch (level) {
            case 1: {
                text = LOG_LEVEL_ERROR_VALUE;
                break;
            }
            case 2: {
                text = LOG_LEVEL_WARNING_VALUE;
                break;
            }
            case 3: {
                text = LOG_LEVEL_INFO_VALUE;
                break;
            }
            case 4: {
                text = LOG_LEVEL_DEBUG_VALUE;
                break;
            }
            default: {
                text = LOG_LEVEL_UNKNOWN_VALUE;
            }
        }
        return text;
    }

    private OutputStream getOutputStream(int level) {
        PrintStream stream = level == 3 || level == 4 ? System.out : System.err;
        return stream;
    }

    private String getPrefix(int level) {
        String levelText = this.getLevelText(level);
        StringBuffer buffer = new StringBuffer(10);
        buffer.append('[');
        buffer.append(levelText);
        buffer.append(']');
        String prefix = buffer.toString();
        return prefix;
    }

    private List getServiceNames(ServiceReference reference) {
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        List names = utility.getServiceNames(reference);
        return names;
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable throwable) {
        this.log(null, level, message, throwable);
    }

    public void log(ServiceReference reference, int level, String message) {
        this.log(reference, level, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference reference, int level, String message, Throwable throwable) {
        OutputStream stream = this.getOutputStream(level);
        ConsoleLog consoleLog = this;
        synchronized (consoleLog) {
            String logMessage = this.formatLogMessage(reference, level, message);
            byte[] bytes = logMessage.getBytes();
            try {
                stream.write(bytes);
                stream.flush();
                if (throwable != null) {
                    PrintStream printStream = new PrintStream(stream);
                    throwable.printStackTrace(printStream);
                    printStream.flush();
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void printServiceReferenceOn(StringBuffer buffer, ServiceReference reference) {
        if (reference == null) {
            return;
        }
        Bundle bundle = reference.getBundle();
        if (bundle != null) {
            String symbolicName = bundle.getSymbolicName();
            long id = bundle.getBundleId();
            buffer.append("bundle");
            buffer.append('=');
            buffer.append(symbolicName);
            buffer.append(' ');
            buffer.append('[');
            buffer.append(id);
            buffer.append(']');
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append("services");
        buffer.append('=');
        buffer.append('[');
        List names = this.getServiceNames(reference);
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            Object name = iterator.next();
            buffer.append(name);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(']');
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

