/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal.logwriter;

import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.logwriter.LogWriter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.logwriter.nls.MessageFormatter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.logwriter.nls.Messages;

public class LogWriterCommandProvider
implements CommandProvider {
    private static final String LOG_LEVEL_IS_KEY = "LogWriterCommandProvider.LogLevelIs";
    private static final String SET_LOG_LEVEL_DESCRIPTION_KEY = "LogWriterCommandProvider.SetLogLevelDescription";
    private static final String START_LOG_WRITER_DESCRIPTION_KEY = "LogWriterCommandProvider.StartLogWriterDescription";
    private static final String STOP_LOG_WRITER_DESCRIPTION_KEY = "LogWriterCommandProvider.StopLogWriterDescription";
    private static final String LOG_LEVEL_IS = Messages.getString("LogWriterCommandProvider.LogLevelIs");
    private static final String SET_LOG_LEVEL_DESCRIPTION = Messages.getString("LogWriterCommandProvider.SetLogLevelDescription");
    private static final String START_LOG_WRITER_DESCRIPTION = Messages.getString("LogWriterCommandProvider.StartLogWriterDescription");
    private static final String STOP_LOG_WRITER_DESCRIPTION = Messages.getString("LogWriterCommandProvider.StopLogWriterDescription");
    public static final String SET_LOG_LEVEL_USAGE = "setll <error | warning | info | debug> - {0}";
    private static final String START_LOG_WRITER_USAGE = "startlw - {0}";
    private static final String STOP_LOG_WRITER_USAGE = "stoplw - {0}";
    private LogWriter writer;

    public LogWriterCommandProvider(LogWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        this.setWriter(writer);
    }

    public void _setll(CommandInterpreter interpreter) {
        LogWriter writer;
        boolean set;
        String argument = interpreter.nextArgument();
        if (argument != null && !(set = (writer = this.getWriter()).setLevel(argument))) {
            return;
        }
        this.displayLogLevel(interpreter);
    }

    public void _startlw(CommandInterpreter interpreter) {
        LogWriter writer = this.getWriter();
        writer.start();
    }

    public void _stoplw(CommandInterpreter interpreter) {
        LogWriter writer = this.getWriter();
        writer.stop();
    }

    private void displayLogLevel(CommandInterpreter interpreter) {
        LogWriter writer = this.getWriter();
        String value = writer.getLevel();
        String message = MessageFormatter.format(LOG_LEVEL_IS, value);
        interpreter.println((Object)message);
    }

    public String getHelp() {
        String setLogLevelHelp = MessageFormatter.format(SET_LOG_LEVEL_USAGE, SET_LOG_LEVEL_DESCRIPTION);
        String startLogWriterHelp = MessageFormatter.format(START_LOG_WRITER_USAGE, START_LOG_WRITER_DESCRIPTION);
        String stopLogWriterHelp = MessageFormatter.format(STOP_LOG_WRITER_USAGE, STOP_LOG_WRITER_DESCRIPTION);
        String decoration = "---";
        char tab = '\t';
        char newLine = '\n';
        StringBuffer buffer = new StringBuffer(150);
        buffer.append(decoration);
        buffer.append("Log Writer");
        buffer.append(decoration);
        buffer.append(newLine);
        buffer.append(tab);
        buffer.append(setLogLevelHelp);
        buffer.append(newLine);
        buffer.append(tab);
        buffer.append(startLogWriterHelp);
        buffer.append(newLine);
        buffer.append(tab);
        buffer.append(stopLogWriterHelp);
        buffer.append(newLine);
        String help = buffer.toString();
        return help;
    }

    private LogWriter getWriter() {
        return this.writer;
    }

    private void setWriter(LogWriter writer) {
        this.writer = writer;
    }
}

