/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.AbstractCommandProvider;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleDependencyCommandProvider
extends AbstractCommandProvider {
    private static final String ALL_DEPENDENDS_DESCRIPTION_KEY = "BundleDependencyCommandProvider.AllDependentsDescription";
    private static final String ALL_DEPENDENTS_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.AllDependentsOfBundle";
    private static final String ALL_PREREQUISITES_DESCRIPTION_KEY = "BundleDependencyCommandProvider.AllPrerequisitesDescription";
    private static final String ALL_PREREQUISITES_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.AllPrerequisitesOfBundle";
    private static final String BUNDLE_LIST_HEADER_KEY = "BundleDependencyCommandProvider.BundleListHeader";
    private static final String CIRC_DESCRIPTION_KEY = "BundleDependencyCommandProvider.CircDescription";
    private static final String CIRCULAR_REFERENCES_OF_KEY = "BundleDependencyCommandProvider.CircularReferencesOf";
    private static final String DEPENDENTS_DESCRIPTION_KEY = "BundleDependencyCommandProvider.DependentsDescription";
    private static final String DEPENDENTS_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.DependentsOfBundle";
    private static final String NONE_KEY = "BundleDependencyCommandProvider.None";
    private static final String PREREQUISITES_DESCRIPTION_KEY = "BundleDependencyCommandProvider.PrerequisitesDescription";
    private static final String PREREQUISITES_OF_BUNDLE_KEY = "BundleDependencyCommandProvider.PrerequisitesOfBundle";
    private static final String SORT_BUNDLES_BY_DESCRIPTION_KEY = "BundleDependencyCommandProvider.SortBundlesByDescription";
    private static final String SORTING_BUNDLES_BY_KEY = "BundleDependencyCommandProvider.SortingBundlesBy";
    private static final String TITLE_KEY = "BundleDependencyCommandProvider.Title";
    private static final String ALL_DEPENDENTS_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.AllDependentsDescription");
    private static final String ALL_DEPENDENTS_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.AllDependentsOfBundle");
    private static final String ALL_PREREQUISITES_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.AllPrerequisitesDescription");
    private static final String ALL_PREREQUISITES_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.AllPrerequisitesOfBundle");
    private static final String BUNDLE_LIST_HEADER = Messages.getString("BundleDependencyCommandProvider.BundleListHeader");
    private static final String CIRC_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.CircDescription");
    private static final String CIRCULAR_REFERENCES_OF = Messages.getString("BundleDependencyCommandProvider.CircularReferencesOf");
    private static final String DEPENDENTS_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.DependentsDescription");
    private static final String DEPENDENTS_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.DependentsOfBundle");
    private static final String NONE = Messages.getString("BundleDependencyCommandProvider.None");
    private static final String PREREQUISITES_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.PrerequisitesDescription");
    private static final String PREREQUISITES_OF_BUNDLE = Messages.getString("BundleDependencyCommandProvider.PrerequisitesOfBundle");
    private static final String SORT_BUNDLES_BY_DESCRIPTION = Messages.getString("BundleDependencyCommandProvider.SortBundlesByDescription");
    private static final String SORTING_BUNDLES_BY = Messages.getString("BundleDependencyCommandProvider.SortingBundlesBy");
    private static final String TITLE = Messages.getString("BundleDependencyCommandProvider.Title");
    private static final String ALL_DEPENDENDENTS_COMMAND_HELP = "adep [id] - {0}";
    private static final String ALL_PREREQUISITES_COMMAND_HELP = "apre [id] - {0}";
    private static final String BUNDLE_LIST_ROW = "{0}\t{1}{2}{3}_{4}";
    private static final String CIRC_COMMAND_HELP = "circ [id] - {0}";
    private static final String DEPENDENTS_COMMAND_HELP = "dep [id] - {0}";
    private static final String PREREQUISITES_COMMAND_HELP = "pre [id] - {0}";
    private static final String SORT_BUNDLES_BY_COMMAND_HELP = "sbb [{0} | {1}] - {2}";
    private static final String SORT_BUNDLES_BY_BUNDLE_ID = "bid";
    private static final String SORT_BUNDLES_BY_BUNDLE_SYMBOLIC_NAME = "bsn";
    private static final char IS_REGISTERED_AS_UNINSTALLABLE_FLAG = '*';
    private BundleDependencyService model;
    private Comparator bundleComparator;
    private String sortBundlesBy;

    public BundleDependencyCommandProvider(BundleContext bundleContext, BundleDependencyService bundleDependencyService) {
        super(bundleContext);
        this.setModel(bundleDependencyService);
        this.setBundleComparator(this.createBundleComparator());
        this.setSortBundlesBy(SORT_BUNDLES_BY_BUNDLE_ID);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _adep(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        try {
            List bundles = this.getBundles();
            this.appendAllDependentsOfBundles(bundles);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _apre(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        try {
            List bundles = this.getBundles();
            this.appendAllPrerequisitesOfBundles(bundles);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _circ(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        try {
            List bundles = this.getBundles();
            this.appendCircularReferences(bundles);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _dep(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        try {
            List bundles = this.getBundles();
            this.appendDependentsOfBundles(bundles);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _pre(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        try {
            List bundles = this.getBundles();
            this.appendPrerequisitesOfBundles(bundles);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _sbb(CommandInterpreter interpreter) throws Exception {
        block8: {
            block7: {
                this.setInterpreter(interpreter);
                try {
                    String argument = this.getNextArgument();
                    if (argument != null) {
                        if (argument.equalsIgnoreCase(SORT_BUNDLES_BY_BUNDLE_ID)) {
                            this.setSortBundlesBy(argument);
                        } else {
                            if (!argument.equalsIgnoreCase(SORT_BUNDLES_BY_BUNDLE_SYMBOLIC_NAME)) {
                                String help = this.getSortBundlesByCommandHelpLine();
                                this.appendLine(help);
                                Object var5_5 = null;
                                break block7;
                            }
                            this.setSortBundlesBy(argument);
                        }
                    }
                    String sortBundlesBy = this.getSortBundlesBy();
                    String line = MessageFormatter.format(SORTING_BUNDLES_BY, sortBundlesBy);
                    this.appendLine(line);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.flushBuffer();
                    throw throwable;
                }
            }
            this.flushBuffer();
            return;
        }
        Object var5_7 = null;
        this.flushBuffer();
    }

    private void appendAllDependentsOfBundles(List bundles) {
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            String bundleSymbolicName = bundle.getSymbolicName();
            String message = MessageFormatter.format(ALL_DEPENDENTS_OF_BUNDLE, bundleSymbolicName);
            this.appendLine(message);
            List list = this.getAllDependentsOf(bundle);
            this.appendBundles(list);
        }
    }

    private void appendAllPrerequisitesOfBundles(List bundles) {
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            String bundleSymbolicName = bundle.getSymbolicName();
            String message = MessageFormatter.format(ALL_PREREQUISITES_OF_BUNDLE, bundleSymbolicName);
            this.appendLine(message);
            List list = this.getAllPrerequisitesOf(bundle);
            this.appendBundles(list);
        }
    }

    private void appendBundles(List list) {
        boolean empty = list.isEmpty();
        if (empty) {
            this.appendIndent();
            this.appendLine(NONE);
        } else {
            this.appendNewLine();
            this.appendLine(BUNDLE_LIST_HEADER);
            this.sortBundles(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Bundle bundle = (Bundle)iterator.next();
                String id = this.toBundleIdString(bundle);
                String state = this.toBundleStateString(bundle);
                String padding = this.createBundleStatePadding(bundle, state);
                String name = bundle.getSymbolicName();
                String version = this.getBundleVersion(bundle);
                Object[] values = new Object[]{id, state, padding, name, version};
                String message = MessageFormatter.format(BUNDLE_LIST_ROW, values);
                this.appendLine(message);
            }
        }
        this.appendNewLine();
    }

    private void appendCircularReferences(List list) {
        this.sortBundlesByBundleSymbolicName(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            boolean state = this.hasCircularReferences(bundle);
            if (!state) continue;
            String bundleSymbolicName = bundle.getSymbolicName();
            String message = MessageFormatter.format(CIRCULAR_REFERENCES_OF, bundleSymbolicName);
            this.appendLine(message);
            List prerequisites = this.getPrerequisitesOf(bundle);
            this.appendBundles(prerequisites);
        }
    }

    private void appendDependentsOfBundles(List bundles) {
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            String bundleSymbolicName = bundle.getSymbolicName();
            String message = MessageFormatter.format(DEPENDENTS_OF_BUNDLE, bundleSymbolicName);
            this.appendLine(message);
            List list = this.getDependentsOf(bundle);
            this.appendBundles(list);
        }
    }

    private void appendPrerequisitesOfBundles(List bundles) {
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            String bundleSymbolicName = bundle.getSymbolicName();
            String message = MessageFormatter.format(PREREQUISITES_OF_BUNDLE, bundleSymbolicName);
            this.appendLine(message);
            List list = this.getPrerequisitesOf(bundle);
            this.appendBundles(list);
        }
    }

    private int compareBundles(Bundle leftBundle, Bundle rightBundle) {
        int result;
        String sortBundlesBy = this.getSortBundlesBy();
        if (sortBundlesBy.equalsIgnoreCase(SORT_BUNDLES_BY_BUNDLE_ID)) {
            result = this.compareBundlesById(leftBundle, rightBundle);
        } else if (sortBundlesBy.equalsIgnoreCase(SORT_BUNDLES_BY_BUNDLE_SYMBOLIC_NAME)) {
            result = this.compareBundlesByBundleSymbolicName(leftBundle, rightBundle);
        } else {
            String pattern = "unrecognized bundle sort order: {0}";
            String message = MessageFormatter.format(pattern, sortBundlesBy);
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    private int compareBundlesByBundleSymbolicName(Bundle leftBundle, Bundle rightBundle) {
        String leftBundleSymbolicName = leftBundle.getSymbolicName();
        String rightBundleSymbolicName = rightBundle.getSymbolicName();
        int result = leftBundleSymbolicName.compareTo(rightBundleSymbolicName);
        return result;
    }

    private int compareBundlesById(Bundle leftBundle, Bundle rightBundle) {
        long rightBundleId;
        long leftBundleId = leftBundle.getBundleId();
        if (leftBundleId < (rightBundleId = rightBundle.getBundleId())) {
            return -1;
        }
        if (leftBundleId > rightBundleId) {
            return 1;
        }
        return 0;
    }

    private Comparator createBundleComparator() {
        return new Comparator(){

            public int compare(Object left, Object right) {
                Bundle leftBundle = (Bundle)left;
                Bundle rightBundle = (Bundle)right;
                int result = BundleDependencyCommandProvider.this.compareBundles(leftBundle, rightBundle);
                return result;
            }
        };
    }

    protected String createBundleStatePadding(Bundle bundle, String state) {
        String padding = super.createBundleStatePadding(bundle, state);
        boolean uninstallable = this.isRegisteredAsUninstallable(bundle);
        if (!uninstallable) {
            return padding;
        }
        padding = String.valueOf(padding) + '*';
        return padding;
    }

    private List getAllBundleArguments() {
        List arguments = this.getAllArguments();
        boolean empty = arguments.isEmpty();
        if (empty) {
            return AbstractCommandProvider.EMPTY_LIST;
        }
        int size = arguments.size();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(size);
        Iterator iterator = arguments.iterator();
        while (iterator.hasNext()) {
            String argument = (String)iterator.next();
            Bundle bundle = this.getBundle(argument);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private List getAllBundles() {
        BundleContext context = this.getBundleContext();
        Bundle[] bundles = context.getBundles();
        List<Bundle> list = Arrays.asList(bundles);
        Comparator comparator = this.getBundleComparator();
        Collections.sort(list, comparator);
        return list;
    }

    private String getAllDependentsCommandHelpLine() {
        return MessageFormatter.format(ALL_DEPENDENDENTS_COMMAND_HELP, ALL_DEPENDENTS_DESCRIPTION);
    }

    private List getAllDependentsOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getAllDependentsOf(bundle);
        return list;
    }

    private String getAllPrerequisitesCommandHelpLine() {
        return MessageFormatter.format(ALL_PREREQUISITES_COMMAND_HELP, ALL_PREREQUISITES_DESCRIPTION);
    }

    private List getAllPrerequisitesOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getAllPrerequisitesOf(bundle);
        return list;
    }

    private Comparator getBundleComparator() {
        return this.bundleComparator;
    }

    private List getBundles() {
        List bundles = this.getAllBundleArguments();
        boolean empty = bundles.isEmpty();
        if (empty) {
            bundles = this.getAllBundles();
        }
        return bundles;
    }

    private String getCircCommandHelpLine() {
        return MessageFormatter.format(CIRC_COMMAND_HELP, CIRC_DESCRIPTION);
    }

    protected String[] getCommandHelpLines() {
        return new String[]{this.getAllDependentsCommandHelpLine(), this.getAllPrerequisitesCommandHelpLine(), this.getCircCommandHelpLine(), this.getDependentsCommandHelpLine(), this.getPrerequisitesCommandHelpLine()};
    }

    private String getDependentsCommandHelpLine() {
        return MessageFormatter.format(DEPENDENTS_COMMAND_HELP, DEPENDENTS_DESCRIPTION);
    }

    private List getDependentsOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getDependentsOf(bundle);
        return list;
    }

    private BundleDependencyService getModel() {
        return this.model;
    }

    private String getPrerequisitesCommandHelpLine() {
        return MessageFormatter.format(PREREQUISITES_COMMAND_HELP, PREREQUISITES_DESCRIPTION);
    }

    private List getPrerequisitesOf(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        List list = bds.getPrerequisitesOf(bundle);
        return list;
    }

    private String getSortBundlesBy() {
        return this.sortBundlesBy;
    }

    private String getSortBundlesByCommandHelpLine() {
        Object[] values = new Object[]{SORT_BUNDLES_BY_BUNDLE_ID, SORT_BUNDLES_BY_BUNDLE_SYMBOLIC_NAME, SORT_BUNDLES_BY_DESCRIPTION};
        return MessageFormatter.format(SORT_BUNDLES_BY_COMMAND_HELP, values);
    }

    protected String getTitle() {
        return TITLE;
    }

    private boolean hasCircularReferences(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        boolean result = bds.hasCircularReferences(bundle);
        return result;
    }

    private boolean isRegisteredAsUninstallable(Bundle bundle) {
        BundleDependencyService bds = this.getModel();
        boolean uninstallable = bds.isRegisteredAsUninstallable(bundle);
        return uninstallable;
    }

    private void setBundleComparator(Comparator bundleComparator) {
        this.bundleComparator = bundleComparator;
    }

    private void setModel(BundleDependencyService model) {
        this.model = model;
    }

    private void setSortBundlesBy(String sortBundlesBy) {
        this.sortBundlesBy = sortBundlesBy;
    }

    private void sortBundles(List list) {
        Comparator comparator = this.getBundleComparator();
        Collections.sort(list, comparator);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sortBundlesByBundleSymbolicName(List list) {
        String sortBundlesBy = this.getSortBundlesBy();
        try {
            this.setSortBundlesBy(SORT_BUNDLES_BY_BUNDLE_SYMBOLIC_NAME);
            this.sortBundles(list);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setSortBundlesBy(sortBundlesBy);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.setSortBundlesBy(sortBundlesBy);
            return;
        }
    }
}

