/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import org.eclipse.jdt.core.IType;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesTableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ExportedServicesTableLabelProvider
extends ServicesTableLabelProvider {
    private static final int IMPLEMENTATION_CLASS_COLUMN = 1;
    private static final int FIELD_COLUMN = 2;
    private static final int PROPERTIES_COLUMN = 3;
    private static final int PROXY_COLUMN = 4;

    public Image getColumnImage(Object element, int columnIndex) {
        boolean state;
        Image image = super.getColumnImage(element, columnIndex);
        if (image != null) {
            return image;
        }
        IExportedServiceDetails details = (IExportedServiceDetails)element;
        Activator activator = Activator.getDefault();
        if (columnIndex == 1) {
            IType type = details.getImplementationClass();
            if (type == null) {
                return null;
            }
            image = activator.getImage("type-class");
            return image;
        }
        if (columnIndex == 2) {
            state = details.isStoredInField();
        } else if (columnIndex == 3) {
            state = details.hasProperties();
        } else if (columnIndex == 4) {
            state = details.isProxy();
        } else {
            return null;
        }
        String name = state ? "checkbox-checked" : "checkbox-unchecked";
        image = activator.getImage(name);
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        if (columnIndex == 1) {
            IExportedServiceDetails details = (IExportedServiceDetails)element;
            IType type = details.getImplementationClass();
            if (type != null) {
                text = type.getFullyQualifiedName();
                text = this.toUnqualifiedTypeName(text);
            }
        } else {
            text = super.getColumnText(element, columnIndex);
        }
        return text;
    }
}

