/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ExportedServicesTableLabelProvider;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesCompositeBuilder;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportedServicesCompositeBuilder
extends ServicesCompositeBuilder {
    private static final String ADD_BUTTON_TOOL_TIP_KEY = "ExportedServicesCompositeBuilder.AddButtonToolTip";
    private static final String EDIT_BUTTON_TOOL_TIP_KEY = "ExportedServicesCompositeBuilder.EditButtonToolTip";
    private static final String TITLE_KEY = "ExportedServicesCompositeBuilder.Title";
    private static final String FIELD_KEY = "ExportedServicesCompositeBuilder.Field";
    private static final String FIELD_SHORTCUT_KEY = "ExportedServicesCompositeBuilder.FieldShortcut";
    private static final String IMPLEMENTATION_CLASS_KEY = "ExportedServicesCompositeBuilder.ImplementationClass";
    private static final String PROPERTIES_KEY = "ExportedServicesCompositeBuilder.Properties";
    private static final String PROPERTIES_SHORTCUT_KEY = "ExportedServicesCompositeBuilder.PropertiesShortcut";
    private static final String PROXY_KEY = "ExportedServicesCompositeBuilder.Proxy";
    private static final String PROXY_SHORTCUT_KEY = "ExportedServicesCompositeBuilder.ProxyShortcut";
    private static final String REMOVE_BUTTON_TOOL_TIP_KEY = "ExportedServicesCompositeBuilder.RemoveButtonToolTip";
    private static final String FIELD_COLUMN_ID = "field";
    private static final String IMPLEMENTATION_CLASS_COLUMN_ID = "implementationClass";
    private static final String PROPERTIES_COLUMN_ID = "properties";
    private static final String PROXY_COLUMN_ID = "proxy";
    private static final int IMPLEMENTATION_CLASS_COLUMN_INDEX = 1;
    private static final int IMPLEMENTATION_CLASS_COLUMN_WIDTH = 200;
    private static final char FIELD_SHORTCUT = Messages.getString("ExportedServicesCompositeBuilder.FieldShortcut").charAt(0);
    private static final char PROPERTIES_SHORTCUT = Messages.getString("ExportedServicesCompositeBuilder.PropertiesShortcut").charAt(0);
    private static final char PROXY_SHORTCUT = Messages.getString("ExportedServicesCompositeBuilder.ProxyShortcut").charAt(0);
    private static final String DEFAULT_IMPLEMENTATION_CLASS = new String();
    private static final Integer ZERO_WRAPPER = new Integer(0);

    ExportedServicesCompositeBuilder(ServicesActivatorWizardPage page) {
        super(page);
    }

    @Override
    void addService(IType type) {
        FactoryUtility utility = FactoryUtility.getInstance();
        boolean storedInField = this.getStoreExportedServicesInFields();
        boolean hasProperties = this.getExportServicesWithProperties();
        boolean proxy = this.getCreateExportedProxyServices();
        IJavaProject javaProject = this.getJavaProject();
        IExportedServiceDetails details = utility.createExportedServiceDetails(type, javaProject, storedInField, hasProperties, proxy);
        IActivatorWizardModel model = this.getModel();
        model.addExportedServiceDetails(details);
        super.addService(type);
    }

    @Override
    CellEditor[] createCellEditors(Table table) {
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[1] = this.createComboBoxCellEditor((Composite)table);
        cellEditorArray[2] = this.createCheckboxCellEditor(table);
        cellEditorArray[3] = this.createCheckboxCellEditor(table);
        cellEditorArray[4] = this.createCheckboxCellEditor(table);
        return cellEditorArray;
    }

    @Override
    String[] createColumnProperties() {
        return new String[]{"serviceName", IMPLEMENTATION_CLASS_COLUMN_ID, FIELD_COLUMN_ID, PROPERTIES_COLUMN_ID, PROXY_COLUMN_ID};
    }

    @Override
    void createTableColumns(Table table) {
        super.createTableColumns(table);
        this.createTableColumn(table, IMPLEMENTATION_CLASS_KEY, 200);
        this.createTableColumn(table, FIELD_KEY, 70);
        this.createTableColumn(table, PROPERTIES_KEY, 70);
        this.createTableColumn(table, PROXY_KEY, 70);
    }

    @Override
    ITableLabelProvider createTableLabelProvider() {
        return new ExportedServicesTableLabelProvider();
    }

    @Override
    Object createTableViewerInput() {
        IActivatorWizardModel model = this.getModel();
        List list = model.getExportedServicesDetails();
        return list;
    }

    private void doPopulateComboListWithImplementationClasses(IExportedServiceDetails details) {
        List candidates = details.getCandidateImplementationClasses();
        List<String> list = this.toFullyQualifiedNames(candidates);
        boolean enabled = !list.isEmpty();
        ComboBoxCellEditor editor = this.getImplementationClassComboBoxCellEditor();
        Control control = editor.getControl();
        control.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        list.add(0, DEFAULT_IMPLEMENTATION_CLASS);
        int size = list.size();
        String[] items = new String[size];
        list.toArray(items);
        editor.setItems(items);
    }

    @Override
    boolean editService(IServiceDetails details, IType selectedType) {
        String fullyQualifiedName;
        IActivatorWizardModel model = this.getModel();
        boolean exists = model.containsExportedService(fullyQualifiedName = selectedType.getFullyQualifiedName());
        if (exists) {
            return false;
        }
        IExportedServiceDetails exportedServiceDetails = (IExportedServiceDetails)details;
        model.removeExportedServiceDetails(exportedServiceDetails);
        exportedServiceDetails.setType(selectedType);
        model.addExportedServiceDetails(exportedServiceDetails);
        boolean result = super.editService(details, selectedType);
        return result;
    }

    @Override
    String getAddButtonToolTipKey() {
        return ADD_BUTTON_TOOL_TIP_KEY;
    }

    private boolean getCreateExportedProxyServices() {
        ServicesActivatorWizardPage page = this.getPage();
        boolean state = page.getCreateExportedProxyServices();
        return state;
    }

    @Override
    String getEditButtonToolTipKey() {
        return EDIT_BUTTON_TOOL_TIP_KEY;
    }

    private boolean getExportServicesWithProperties() {
        ServicesActivatorWizardPage page = this.getPage();
        boolean state = page.getExportServicesWithProperties();
        return state;
    }

    @Override
    String getImageKey() {
        return "bundle-exporter";
    }

    private ComboBoxCellEditor getImplementationClassComboBoxCellEditor() {
        TableViewer viewer = this.getTableViewer();
        CellEditor[] editors = viewer.getCellEditors();
        ComboBoxCellEditor editor = (ComboBoxCellEditor)editors[1];
        return editor;
    }

    @Override
    String getRemoveButtonToolTipKey() {
        return REMOVE_BUTTON_TOOL_TIP_KEY;
    }

    private boolean getStoreExportedServicesInFields() {
        ServicesActivatorWizardPage page = this.getPage();
        boolean state = page.getStoreExportedServicesInFields();
        return state;
    }

    @Override
    String getTitleKey() {
        return TITLE_KEY;
    }

    @Override
    boolean handleCanModifyCellEditor(String property) {
        if (property.equals(IMPLEMENTATION_CLASS_COLUMN_ID)) {
            return true;
        }
        if (property.equals(FIELD_COLUMN_ID)) {
            return true;
        }
        if (property.equals(PROPERTIES_COLUMN_ID)) {
            return true;
        }
        return property.equals(PROXY_COLUMN_ID);
    }

    private void handleFieldShortCutKeyPressed() {
        List<?> list = this.getTableViewerSelectionList();
        for (Object object : list) {
            IExportedServiceDetails details = (IExportedServiceDetails)object;
            this.handleModifyFieldCellEditor(details);
            this.refreshTableViewer(details);
        }
    }

    @Override
    Object handleGetValueOfCellEditor(IServiceDetails details, String property) {
        Object value = null;
        IExportedServiceDetails exportedServiceDetails = (IExportedServiceDetails)details;
        if (property.equals(IMPLEMENTATION_CLASS_COLUMN_ID)) {
            value = this.handleGetValueOfImplementationClassCellEditor(exportedServiceDetails);
        } else if (property.equals(FIELD_COLUMN_ID)) {
            value = this.handleGetValueOfFieldCellEditor(exportedServiceDetails);
        } else if (property.equals(PROPERTIES_COLUMN_ID)) {
            value = this.handleGetValueOfPropertiesCellEditor(exportedServiceDetails);
        } else if (property.equals(PROXY_COLUMN_ID)) {
            value = this.handleGetValueOfProxyCellEditor(exportedServiceDetails);
        }
        return value;
    }

    private Object handleGetValueOfFieldCellEditor(IExportedServiceDetails details) {
        boolean state = details.isStoredInField();
        Boolean value = state;
        return value;
    }

    private Object handleGetValueOfImplementationClassCellEditor(IExportedServiceDetails details) {
        Integer value;
        this.populateComboListWithImplementationClasses(details);
        IType type = details.getImplementationClass();
        if (type == null) {
            value = ZERO_WRAPPER;
        } else {
            List list = details.getCandidateImplementationClasses();
            int index = list.indexOf(type);
            value = new Integer(index + 1);
        }
        return value;
    }

    private Object handleGetValueOfPropertiesCellEditor(IExportedServiceDetails details) {
        boolean state = details.hasProperties();
        Boolean value = state;
        return value;
    }

    private Object handleGetValueOfProxyCellEditor(IExportedServiceDetails details) {
        boolean state = details.isProxy();
        Boolean value = state;
        return value;
    }

    @Override
    void handleModifyCellEditor(IServiceDetails details, String property, Object value) {
        IExportedServiceDetails exportedServiceDetails = (IExportedServiceDetails)details;
        if (property.equals(IMPLEMENTATION_CLASS_COLUMN_ID)) {
            Integer wrapper = (Integer)value;
            this.handleModifyImplementationClassCellEditor(exportedServiceDetails, wrapper);
        } else if (property.equals(FIELD_COLUMN_ID)) {
            this.handleModifyFieldCellEditor(exportedServiceDetails);
        } else if (property.equals(PROPERTIES_COLUMN_ID)) {
            this.handleModifyPropertiesCellEditor(exportedServiceDetails);
        } else if (property.equals(PROXY_COLUMN_ID)) {
            this.handleModifyProxyCellEditor(exportedServiceDetails);
        }
    }

    private void handleModifyFieldCellEditor(IExportedServiceDetails details) {
        boolean state = !details.isStoredInField();
        details.setStoredInField(state);
    }

    private void handleModifyImplementationClassCellEditor(IExportedServiceDetails details, Integer wrapper) {
        int index = wrapper;
        ComboBoxCellEditor editor = this.getImplementationClassComboBoxCellEditor();
        String[] items = editor.getItems();
        String name = index <= 0 ? null : items[index];
        IType type = details.getCandidateImplementationClass(name);
        details.setImplementationClass(type);
    }

    private void handleModifyPropertiesCellEditor(IExportedServiceDetails details) {
        boolean state = !details.hasProperties();
        details.setHasProperties(state);
    }

    private void handleModifyProxyCellEditor(IExportedServiceDetails details) {
        boolean state = !details.isProxy();
        details.setProxy(state);
    }

    private void handlePropertiesShortCutKeyPressed() {
        List<?> list = this.getTableViewerSelectionList();
        for (Object object : list) {
            IExportedServiceDetails details = (IExportedServiceDetails)object;
            this.handleModifyPropertiesCellEditor(details);
            this.refreshTableViewer(details);
        }
    }

    private void handleProxyShortCutKeyPressed() {
        List<?> list = this.getTableViewerSelectionList();
        for (Object object : list) {
            IExportedServiceDetails details = (IExportedServiceDetails)object;
            this.handleModifyProxyCellEditor(details);
            this.refreshTableViewer(details);
        }
    }

    @Override
    void handleTableKeyPressed(KeyEvent event, boolean altKeyDown) {
        super.handleTableKeyPressed(event, altKeyDown);
        if (this.isFieldShortcutKeyPressed(event, altKeyDown)) {
            this.handleFieldShortCutKeyPressed();
        } else if (this.isPropertiesShortcutKeyPressed(event, altKeyDown)) {
            this.handlePropertiesShortCutKeyPressed();
        } else if (this.isProxyShortcutKeyPressed(event, altKeyDown)) {
            this.handleProxyShortCutKeyPressed();
        }
    }

    @Override
    void handleTableResized() {
        TableViewer viewer = this.getTableViewer();
        Table table = viewer.getTable();
        int value = this.calculateRemainingHorizontalSpace(table, 2);
        if (value == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        int width = value - column.getWidth();
        column = columns[1];
        column.setWidth(width);
    }

    private boolean isFieldShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        return altKeyDown && event.character == FIELD_SHORTCUT;
    }

    private boolean isPropertiesShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        return altKeyDown && event.character == PROPERTIES_SHORTCUT;
    }

    private boolean isProxyShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        return altKeyDown && event.character == PROXY_SHORTCUT;
    }

    private void populateComboListWithImplementationClasses(final IExportedServiceDetails details) {
        Runnable runnable = new Runnable(){

            public void run() {
                ExportedServicesCompositeBuilder.this.doPopulateComboListWithImplementationClasses(details);
            }
        };
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        BusyIndicator.showWhile((Display)display, (Runnable)runnable);
    }

    @Override
    void removeService(IServiceDetails details) {
        IActivatorWizardModel model = this.getModel();
        IExportedServiceDetails exportedServiceDetails = (IExportedServiceDetails)details;
        model.removeExportedServiceDetails(exportedServiceDetails);
        super.removeService((IServiceDetails)exportedServiceDetails);
    }

    List<String> toFullyQualifiedNames(List<IType> types) {
        int size = types.size();
        ArrayList<String> list = new ArrayList<String>(size);
        for (IType type : types) {
            String name = type.getFullyQualifiedName();
            list.add(name);
        }
        Collections.sort(list);
        return list;
    }
}

