/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JavaUtility {
    public static void addClassPathEntry(IJavaProject javaProject, IClasspathEntry classpathEntry, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        newEntries[entries.length] = classpathEntry;
        if (monitor != null) {
            IPath path = classpathEntry.getPath();
            monitor.setTaskName("Updating classpath: " + path);
        }
        javaProject.setRawClasspath(newEntries, monitor);
    }

    public static IJavaProject createJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    public static IJavaElement getActiveEditorInput() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return null;
        }
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IJavaElement javaElement = (IJavaElement)editorInput.getAdapter(IJavaElement.class);
        return javaElement;
    }

    public static IFile getFile(IPackageFragmentRoot root, String filename) {
        return JavaUtility.getFile(root, null, filename);
    }

    public static IFile getFile(IPackageFragmentRoot root, String folders, String filename) {
        Path path;
        IJavaElement javaProject = root.getAncestor(2);
        if (javaProject == null) {
            return null;
        }
        boolean exists = javaProject.exists();
        if (!exists) {
            return null;
        }
        IResource resource = null;
        try {
            resource = javaProject.getCorrespondingResource();
        }
        catch (JavaModelException exception) {
            JavaUtility.logError(exception);
        }
        if (resource == null) {
            return null;
        }
        if (!(resource instanceof IContainer)) {
            return null;
        }
        IContainer container = (IContainer)resource;
        if (folders != null && (container = container.getFolder((IPath)(path = new Path(folders)))) == null) {
            return null;
        }
        exists = container.exists();
        if (!exists) {
            return null;
        }
        path = new Path(filename);
        IFile file = container.getFile((IPath)path);
        return file;
    }

    public static IPackageFragmentRoot getFirstRoot(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                int kind = root.getKind();
                if (kind == 1) {
                    return root;
                }
                ++n2;
            }
        }
        catch (JavaModelException exception) {
            JavaUtility.logError(exception);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IJavaElement getJavaElementFromAdaptable(Object object) {
        if (!(object instanceof IAdaptable)) {
            return null;
        }
        adaptable = (IAdaptable)object;
        javaElement = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
        if (javaElement != null) {
            return javaElement;
        }
        resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource == null) {
            return null;
        }
        type = resource.getType();
        if (type != 8) ** GOTO lbl15
        return null;
lbl-1000:
        // 1 sources

        {
            resource = resource.getParent();
            javaElement = (IJavaElement)resource.getAdapter(IJavaElement.class);
lbl15:
            // 2 sources

            ** while (javaElement == null && resource.getType() != 4)
        }
lbl16:
        // 1 sources

        if (javaElement != null) {
            return javaElement;
        }
        javaElement = JavaCore.create((IResource)resource);
        return javaElement;
    }

    public static IJavaProject getJavaProject(String projectName) {
        IWorkspaceRoot root = JavaUtility.getWorkspaceRoot();
        IProject project = root.getProject(projectName);
        if (project == null) {
            return null;
        }
        if (!project.exists()) {
            return null;
        }
        IJavaProject javaProject = JavaUtility.createJavaProject(project);
        return javaProject;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root;
    }

    private static void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    private JavaUtility() {
    }
}

