/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soda.sat.plugin.AboutExtension;
import org.eclipse.soda.sat.plugin.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.swt.graphics.Image;

class AboutDataTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String FAILED_TO_CREATE_URL_KEY = "Common.FailedToCreateUrl";

    AboutDataTableLabelProvider() {
    }

    private Image createColumnImage(AboutExtension data) {
        String icon = data.getIconName();
        Image image = null;
        if (icon == null) {
            image = this.getDefaultImage();
        } else {
            URL url = data.getInstallUrl();
            image = this.createColumnImage(url, icon);
        }
        return image;
    }

    private Image createColumnImage(URL url) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        Image image = imageDescriptor.createImage();
        return image;
    }

    private Image createColumnImage(URL url, String icon) {
        URL imageUrl = null;
        try {
            imageUrl = new URL(url, icon);
        }
        catch (MalformedURLException exception) {
            String pattern = Messages.getString(FAILED_TO_CREATE_URL_KEY);
            Object[] values = new Object[]{icon};
            String message = MessageFormat.format(pattern, values);
            this.log(4, message, exception);
        }
        Image image = this.createColumnImage(imageUrl);
        return image;
    }

    private Image getColumnImage(AboutExtension data) {
        Image image = (Image)data.getImage();
        if (image == null) {
            image = this.createColumnImage(data);
            data.setImage((Object)image);
        }
        return image;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            AboutExtension data = (AboutExtension)element;
            image = this.getColumnImage(data);
        }
        return image;
    }

    public String getColumnText(Object element, int index) {
        AboutExtension data = (AboutExtension)element;
        switch (index) {
            case 0: {
                return data.getPluginName();
            }
            case 1: {
                return data.getProviderName();
            }
            case 2: {
                return data.getVersion();
            }
            case 3: {
                return data.getPluginId();
            }
        }
        return "null";
    }

    private Image getDefaultImage() {
        Activator activator = Activator.getDefault();
        Image image = activator.getImage("plugin");
        return image;
    }

    public String getText(Object element) {
        AboutExtension data = (AboutExtension)element;
        String text = data.getPluginName();
        return text;
    }

    private void log(int severity, String message, Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(severity, message, throwable);
    }
}

