/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.build;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.soda.devicekit.generator.build.BuildModel;
import org.eclipse.soda.devicekit.generator.model.BuildPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.CoreUtility;

public class BuildSaver
implements IFileSaver {
    public static final String ADDITIONAL_BUNDLES_KEY = "additional.bundles";
    public static final String BUILD_PROPERTIES = "build.properties";
    public static final String COPYRIGHT_TXT = "copyright.txt";
    private IProject project;

    public static int containsCopyright(String data) {
        int createYear = -1;
        int currentYear = Calendar.getInstance().get(1);
        String oldString = new String(data);
        StringTokenizer tokenizer = new StringTokenizer(oldString, " ,", true);
        String previousToken = "";
        while (tokenizer.hasMoreTokens()) {
            int temp;
            String createYearMaybe;
            String token = tokenizer.nextToken();
            String lcToken = token.toLowerCase();
            if ("copyright".equals(lcToken)) {
                createYear = 0;
            } else if (",".equals(token)) {
                try {
                    createYearMaybe = previousToken;
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("All".equals(token) || "IBM".equals(token)) {
                if (createYear < 1980) {
                    try {
                        createYearMaybe = previousToken;
                        temp = Integer.parseInt(createYearMaybe);
                        if (temp <= currentYear && temp > 1980) {
                            createYear = temp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if ("(c)".equals(token) && createYear < 1980) {
                try {
                    tokenizer.nextToken();
                    createYearMaybe = tokenizer.nextToken();
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (Exception exception) {}
            }
            if (lcToken.endsWith("*/")) break;
            if (" ".equals(token) || ",".equals(token)) continue;
            previousToken = token;
        }
        return createYear;
    }

    public static byte[] readData(InputStream fin) throws Exception {
        int size = fin.available();
        byte[] data = new byte[size];
        int index = 0;
        int sizeLeft = size;
        while (sizeLeft != 0) {
            index += fin.read(data, index, sizeLeft);
            sizeLeft = size - index;
        }
        fin.close();
        return data;
    }

    public BuildSaver(IJavaProject project) {
        this.setProject(project.getProject());
    }

    public BuildSaver(IProject project) {
        this.setProject(project);
    }

    public IProject getProject() {
        return this.project;
    }

    public Object organize(IGeneratorModel object, IProgressMonitor progressMonitor) throws Exception {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processCopyrightFile(IFile file, Map map, IProgressMonitor progressMonitor) {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            block9: {
                try {
                    subMonitor.subTask(file.getFullPath().toString());
                    if (file.exists()) {
                        int createYear;
                        String copyright;
                        InputStream is = file.getContents(true);
                        String data = new String(BuildSaver.readData(is));
                        if (!data.equals(copyright = GeneratorTemplates.getCopyright(map, createYear = BuildSaver.containsCopyright(data)))) {
                            byte[] dataBytes = copyright.getBytes();
                            ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                            file.setContents((InputStream)source, true, true, (IProgressMonitor)subMonitor);
                        }
                        break block9;
                    }
                    String[] copyright = GeneratorTemplates.getCopyrightStrings(map);
                    StringBuffer buffer = new StringBuffer(1024);
                    int i = 0;
                    while (true) {
                        if (i >= copyright.length) {
                            byte[] dataBytes = copyright.toString().getBytes();
                            ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                            file.create((InputStream)source, true, (IProgressMonitor)subMonitor);
                        }
                        buffer.append(copyright[i]);
                        buffer.append("\r\n");
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Object var11_19 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            subMonitor.done();
            throw throwable;
        }
        subMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processPropertiesFile(IFile file, Map map, IProgressMonitor progressMonitor) {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            try {
                subMonitor.subTask(file.getFullPath().toString());
                InputStream is = file.getContents(true);
                String data = new String(BuildSaver.readData(is));
                int createYear = BuildSaver.containsCopyright(data);
                String copyright = GeneratorTemplates.getCopyright(map, createYear);
                StringBuffer buffer = new StringBuffer(4096);
                buffer.append(copyright);
                Properties properties = new Properties();
                InputStream inStream = file.getContents(true);
                properties.load(inStream);
                CoreUtility.outputPropertiesTo(buffer, (Map)properties);
                String newData = buffer.toString();
                if (!data.equals(newData)) {
                    byte[] dataBytes = newData.getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(dataBytes);
                    file.setContents((InputStream)source, true, true, (IProgressMonitor)subMonitor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        subMonitor.done();
    }

    public Object save(IGeneratorModel object, IProgressMonitor progressMonitor) throws Exception {
        SubProgressMonitor subMonitor;
        block19: {
            BuildModel buildModel;
            subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
            try {
                String binIncludes;
                String name;
                if (!(object instanceof BuildModel)) break block19;
                BuildModel buildModel2 = (BuildModel)object;
                subMonitor.subTask(this.project.getName());
                IFile copyrightFile = this.project.getFile(COPYRIGHT_TXT);
                this.processCopyrightFile(copyrightFile, buildModel2.getTemplateVariables(), progressMonitor);
                BuildPropertiesModel propertiesModel = new BuildPropertiesModel();
                IFile file = this.project.getFile(BUILD_PROPERTIES);
                if (file.exists()) {
                    propertiesModel.readProperties(file.getContents(true));
                }
                if ((name = this.project.getName()).endsWith(".test.agent") || name.endsWith(".test") || name.endsWith(".testcase") || name.endsWith(".managed") || name.endsWith(".bundle") || name.endsWith(".factory")) {
                    propertiesModel.getProperties().setProperty(ADDITIONAL_BUNDLES_KEY, "");
                    List list = buildModel2.getAdditionalBundles();
                    if (list != null) {
                        Object[] items = list.toArray();
                        int i = 0;
                        while (i < items.length) {
                            String bundleId = String.valueOf(items[i]);
                            this.updateReferencedProjects(buildModel2, bundleId);
                            ++i;
                        }
                    }
                } else if (name.endsWith(".factory") || name.endsWith(".managed")) {
                    propertiesModel.getProperties().setProperty("bin.includes", ".,META-INF/,OSGI-INF/,OSGI-INF/l10n/,copyright.txt,about.html");
                }
                if ((binIncludes = propertiesModel.getProperties().getProperty("bin.includes")) == null) {
                    binIncludes = ".";
                }
                CoreUtility.createAboutFile((IContainer)this.project, (IProgressMonitor)subMonitor);
                if (binIncludes.indexOf("OSGI-INF/") < 0 && this.project.getFolder("OSGI-INF").exists()) {
                    binIncludes = String.valueOf(binIncludes) + ",OSGI-INF/";
                    propertiesModel.getProperties().setProperty("bin.includes", binIncludes);
                }
                if (binIncludes.indexOf("OSGI-INF/l10n/") < 0 && this.project.getFolder("OSGI-INF/l10n").exists()) {
                    binIncludes = String.valueOf(binIncludes) + ",OSGI-INF/l10n/";
                    propertiesModel.getProperties().setProperty("bin.includes", binIncludes);
                }
                if (binIncludes.indexOf("META-INF/") < 0 && this.project.getFolder("META-INF").exists()) {
                    binIncludes = String.valueOf(binIncludes) + ",META-INF/";
                    propertiesModel.getProperties().setProperty("bin.includes", binIncludes);
                }
                if (binIncludes.indexOf(COPYRIGHT_TXT) < 0) {
                    CoreUtility.createAboutFile((IContainer)this.project, progressMonitor);
                    binIncludes = String.valueOf(binIncludes) + ",copyright.txt";
                    propertiesModel.getProperties().setProperty("bin.includes", binIncludes);
                }
                if (binIncludes.indexOf("about.html") < 0) {
                    CoreUtility.createAboutFile((IContainer)this.project, progressMonitor);
                    binIncludes = String.valueOf(binIncludes) + ",about.html";
                    propertiesModel.getProperties().setProperty("bin.includes", binIncludes);
                }
                if (file.exists()) {
                    buildModel2.merge(propertiesModel.getProperties());
                }
                propertiesModel.setProperties(buildModel2.getBuildProperties());
                String contents = propertiesModel.getContents(buildModel2.getTemplateVariables());
                ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
                if (file.exists()) {
                    if (!DeviceKitUtilities.sameStream(stream, file.getContents(true))) {
                        ((InputStream)stream).reset();
                        file.setContents((InputStream)stream, true, true, (IProgressMonitor)subMonitor);
                    }
                } else {
                    file.create((InputStream)stream, false, (IProgressMonitor)subMonitor);
                }
                buildModel = buildModel2;
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                subMonitor.done();
                throw throwable;
            }
            subMonitor.done();
            return buildModel;
        }
        Object var13_16 = null;
        subMonitor.done();
        return null;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void updateReferencedProjects(BuildModel buildModel, IProject project) {
        try {
            List list;
            BuildPropertiesModel propertiesModel = new BuildPropertiesModel();
            IFile file = project.getFile(BUILD_PROPERTIES);
            if (file.exists()) {
                propertiesModel.readProperties(file.getContents(true));
            }
            if ((list = buildModel.getAdditionalBundles()) != null) {
                int i = 0;
                while (i < list.size()) {
                    String bundleId = String.valueOf(list.get(i));
                    buildModel.addAdditionalBundles(bundleId);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateReferencedProjects(BuildModel buildModel, String projectName) {
        block8: {
            IProject project = CoreUtility.getProject(projectName);
            if (project.exists()) {
                try {
                    BuildPropertiesModel propertiesModel = new BuildPropertiesModel();
                    IFile file = project.getFile(BUILD_PROPERTIES);
                    if (!file.exists()) break block8;
                    propertiesModel.readProperties(file.getContents(true));
                    Object list = propertiesModel.getProperties().get(ADDITIONAL_BUNDLES_KEY);
                    if (list != null) {
                        StringTokenizer tokenizer = new StringTokenizer(String.valueOf(list), ",");
                        while (tokenizer.hasMoreTokens()) {
                            String bundleId = tokenizer.nextToken();
                            buildModel.addAdditionalBundles(bundleId);
                            if (bundleId.endsWith(".transport")) {
                                buildModel.addAdditionalBundles(String.valueOf(bundleId) + ".bundle", true);
                                if (!projectName.equals(bundleId)) {
                                    this.updateReferencedProjects(buildModel, bundleId);
                                }
                            }
                            if (!bundleId.endsWith(".receiver")) continue;
                            buildModel.addAdditionalBundles(String.valueOf(bundleId) + ".bundle", true);
                            if (projectName.equals(bundleId)) continue;
                            this.updateReferencedProjects(buildModel, bundleId);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                buildModel.addAdditionalBundles(project.getName(), true);
            }
        }
    }
}

