/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public class DkProfileTestGenerator
extends DkDeviceTestGenerator {
    public DkProfileTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    public DkProfileTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, int bundleType) {
        this(model, generatedInfo, new HashMap());
        this.setBundleType(bundleType);
    }

    public DkProfileTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void codeGetDefaultDevice(IType test) {
        String returnType = DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE);
        String[] comment = new String[]{"Gets the default AdapterService to be tested.", "", "@return ProfileService The Profile to be tested.", "@throws ClassNotFoundException", "@throws IllegalAccessException", "@throws InstantiationException", "@see org.eclipse.soda.dk.profile.test.ProfileTest#getDefaultProfile()"};
        String contents = this.getGetDefaultDeviceContents();
        String[] exceptions = new String[]{"ClassNotFoundException", "IllegalAccessException", "InstantiationException"};
        this.codeMethod(test, "getDefaultProfile", comment, returnType, 1L, contents, null, exceptions);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE);
    }

    protected String getBASuperClass() {
        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_BUNDLE_ACTIVATOR;
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceFqn(), DeviceKitGenerationConstants.CLASS_RUNNABLE};
    }

    protected String getModelName() {
        List concretes = this.getTargets();
        TagElement concrete = (TagElement)concretes.get(0);
        String name = concrete.getImplementation();
        if (name != null && name.indexOf(46) == -1) {
            String pack = DeviceKitUtilities.getPackageFromClassName(name, this.getPackageBase());
            name = String.valueOf(pack) + '.' + name;
        }
        return name;
    }

    protected String getModelServiceName() {
        List concretes = this.getTargets();
        String service = null;
        TagElement concrete = (TagElement)concretes.get(0);
        service = concrete.getAttribute("service") != null ? concrete.getAttribute("service") : concrete.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    public List getTargets() {
        return this.getMainElement().getAllChildrenWithTagCode(74);
    }

    protected boolean isAbstract() {
        List cons = this.getTargets();
        if (cons.size() > 0) {
            TagElement con = (TagElement)cons.get(0);
            String abs = con.getAttribute("abstract");
            return abs != null && abs.equals("true");
        }
        return false;
    }
}

