/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.BundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandsElement;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ManagedBundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ManagedFactoryBundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProviderElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.VendorElement;
import org.eclipse.soda.devicekit.generator.model.elements.VersionElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MainTagElement
extends TagElement {
    private String version;
    private String vendor;
    private String vendors;
    private String provider;
    private String incubation;
    protected String commandReceived;
    private boolean bundle;
    private boolean managedBundle;
    private boolean managedFactoryBundle;

    public MainTagElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public MainTagElement(Node node, TagElement parent, List references) {
        super(node, parent, references);
    }

    public MainTagElement(Node node, TagElement parent, List references, boolean followReferences) {
        super(node, parent, references, followReferences);
    }

    protected void buildAttributes() {
        NamedNodeMap attributes = this.getNode().getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                if (node.getNodeType() == 2 && "packagebase".equals(node.getNodeName())) {
                    this.setPackageBase(node.getNodeValue());
                }
                ++i;
            }
        }
        super.buildAttributes();
    }

    protected String findType() {
        String type = this.getAttribute("implementation");
        if (type == null) {
            type = this.getId();
        }
        if (type != null && type.indexOf(46) == -1) {
            String base = this.getDefaultPackage();
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(type, base)) + '.' + type;
        }
        return this.getClassNameFull();
    }

    public String getBundleId() {
        String bundleId = this.getAttribute("bundleid");
        if (bundleId != null) {
            return bundleId;
        }
        return this.getId();
    }

    public String getBundleName() {
        String bundle = this.getAttribute("bundle");
        if (this.getAttribute("bundle") != null) {
            return bundle;
        }
        return this.getId();
    }

    public String getExecutionEnvironments() {
        return this.getAttribute("executionenvironments");
    }

    public String getImplementation() {
        String implementation = this.getAttribute("implementation");
        if (implementation != null) {
            return implementation;
        }
        return this.getId();
    }

    public String[] getImplementedInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        List exportedService = this.getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < exportedService.size()) {
            if (((TagElement)exportedService.get(i)).getTextData() != null) {
                result.add(((TagElement)exportedService.get(i)).getTextData());
            }
            ++i;
        }
        String[] interfaces = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            interfaces[i2] = (String)result.get(i2);
            ++i2;
        }
        return interfaces;
    }

    public String getIncubation() {
        return this.incubation;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getSuperClass() {
        if (this.getAttribute("superclass") != null) {
            return this.getAttribute("superclass");
        }
        if (this.hasChildWithTagCode(9) || this.hasChildWithTagCode(97) || this.hasChildWithTagCode(15) || TagElement.collection.getPids().size() > 0) {
            if (this.hasChildWithTagCode(45) || this.hasRateControlChild()) {
                return DeviceKitGenerationConstants.CLASS_DEVICE_THREAD;
            }
            return DeviceKitGenerationConstants.CLASS_DEVICE_TRANSPORT;
        }
        return DeviceKitGenerationConstants.CLASS_DEVICE;
    }

    public int getTagCode() {
        return 0;
    }

    public TagElement getTransportElement() {
        List tsChildren = this.getAllChildrenWithTagCode(15);
        if (tsChildren.size() == 0) {
            tsChildren = this.getAllChildrenWithTagCode(9);
            if (tsChildren.size() == 0) {
                tsChildren = this.getAllChildrenWithTagCode(97);
            }
            if (tsChildren.size() == 0) {
                return null;
            }
            return (TagElement)tsChildren.get(0);
        }
        return (TagElement)tsChildren.get(0);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVendors() {
        if (this.vendors != null) {
            return this.vendors;
        }
        return this.getVendor();
    }

    public String getVersion() {
        return this.version;
    }

    protected void handleBundle(Node node) {
        BundleElement element = new BundleElement(node, this);
        this.addChild(element);
        this.setBundle(true);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("vendor".equals(childNodeName)) {
            this.handleVendor(childNode);
        } else if ("version".equals(childNodeName)) {
            this.handleVersion(childNode);
        } else if ("provider".equals(childNodeName)) {
            this.handleProvider(childNode);
        } else if ("incubation".equals(childNodeName)) {
            this.setIncubation(ParserUtilities.extractData(childNode));
        } else if ("bundle".equals(childNodeName)) {
            this.handleBundle(childNode);
        } else if ("managedbundle".equals(childNodeName)) {
            this.handleManagedBundle(childNode);
        } else if ("managedfactorybundle".equals(childNodeName)) {
            this.handleManagedFactoryBundle(childNode);
        } else if ("customparameter".equals(childNodeName)) {
            this.handleCustomParameter(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleCustomParameter(Node node) {
        this.addChild(new CustomParameterElement(node, this));
    }

    protected void handleManagedBundle(Node node) {
        ManagedBundleElement element = new ManagedBundleElement(node, this);
        this.addChild(element);
        this.setManagedBundle(true);
    }

    protected void handleManagedFactoryBundle(Node node) {
        ManagedFactoryBundleElement element = new ManagedFactoryBundleElement(node, this);
        this.addChild(element);
        this.setManagedFactoryBundle(true);
    }

    protected void handleProvider(Node node) {
        ProviderElement element = new ProviderElement(node, this);
        this.addChild(element);
        this.setProvider(ParserUtilities.extractData(node));
    }

    protected void handleVendor(Node node) {
        VendorElement element = new VendorElement(node, this);
        this.addChild(element);
        this.setVendor(ParserUtilities.extractData(node));
    }

    protected void handleVersion(Node node) {
        VersionElement element = new VersionElement(node, this);
        this.addChild(element);
        this.setVersion(ParserUtilities.extractData(node));
    }

    protected boolean hasRateControlChild() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            switch (((TagElement)children.get(i)).getTagCode()) {
                case 1: 
                case 2: {
                    ControlItem se = (ControlItem)children.get(i);
                    if (se.getRate() == null) break;
                    return true;
                }
                case 19: {
                    CommandsElement ce = (CommandsElement)children.get(i);
                    List commands = ce.getAllChildrenWithTagCode(1);
                    int j = 0;
                    while (j < commands.size()) {
                        if (((ControlItem)commands.get(j)).getRate() != null) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean includeCommandRecevied() {
        if (this.commandReceived != null) {
            this.commandReceived = this.commandReceived.trim();
            return !"0".equals(this.commandReceived) && !"false".equals(this.commandReceived);
        }
        return true;
    }

    public boolean isAbstract() {
        String abs = this.getAttribute("abstract");
        return abs != null && abs.equals("true");
    }

    public boolean isBundle() {
        return this.bundle;
    }

    public boolean isGet() {
        String abs = this.getAttribute("get");
        return abs != null && abs.equals("true");
    }

    public boolean isManagedBundle() {
        return this.managedBundle;
    }

    public boolean isManagedFactoryBundle() {
        return this.managedFactoryBundle;
    }

    protected void setBundle(boolean b) {
        this.bundle = b;
    }

    public void setIncubation(String incubation) {
        this.incubation = incubation;
    }

    protected void setManagedBundle(boolean b) {
        this.managedBundle = b;
    }

    protected void setManagedFactoryBundle(boolean b) {
        this.managedFactoryBundle = b;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setVendor(String vendor) {
        if (this.vendor == null) {
            this.vendor = vendor;
            this.setVendors(vendor);
        } else {
            this.setVendors(String.valueOf(this.getVendors()) + ", " + vendor);
        }
    }

    public void setVendors(String vendors) {
        this.vendors = vendors;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

