/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.LocalPortElement;
import org.eclipse.soda.devicekit.generator.model.elements.MaxChannelsElement;
import org.eclipse.soda.devicekit.generator.model.elements.PortElement;
import org.eclipse.soda.devicekit.generator.model.elements.QueueLengthElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipElement;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class TcpipServerElement
extends TcpipElement
implements IConnectionItem {
    private String port;
    protected String maxChannels;
    protected String queueLength;

    public TcpipServerElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.isMultiplex()) {
            return DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP_SERVER_MULTIPLEX;
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP_SERVER;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        list.add(new ConfigurationField("int", "DEFAULT_PORT", this.getPort()));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(64);
        if (this.isMultiplex()) {
            buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP_SERVER_MULTIPLEX_SERVICE));
        } else {
            buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP_SERVER_SERVICE));
        }
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "tcpipserver";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getMaxChannels() {
        return this.maxChannels;
    }

    public String getPort() {
        if (this.port == null) {
            this.port = "23";
        }
        return this.port;
    }

    public Map getProperties() {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("port", this.getPort());
        return table;
    }

    public String getQueueLength() {
        return this.queueLength;
    }

    public int getTagCode() {
        return 56;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("port".equals(childNodeName)) {
            this.handlePort(childNode);
        } else if ("localport".equals(childNodeName)) {
            this.handleLocalPort(childNode);
        } else if ("maxchannels".equals(childNodeName)) {
            this.handleMaxChannels(childNode);
        } else if ("queuelength".equals(childNodeName)) {
            this.handleQueueLength(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleLocalPort(Node node) {
        this.setPort(ParserUtilities.extractData(node));
        LocalPortElement element = new LocalPortElement(node, this);
        this.addChild(element);
    }

    protected void handleMaxChannels(Node node) {
        this.setMaxChannels(ParserUtilities.extractData(node));
        MaxChannelsElement element = new MaxChannelsElement(node, this);
        this.addChild(element);
    }

    protected void handlePort(Node node) {
        this.setPort(ParserUtilities.extractData(node));
        PortElement element = new PortElement(node, this);
        this.addChild(element);
    }

    protected void handleQueueLength(Node node) {
        this.setQueueLength(ParserUtilities.extractData(node));
        QueueLengthElement element = new QueueLengthElement(node, this);
        this.addChild(element);
    }

    public void setMaxChannels(String maxChannels) {
        this.maxChannels = maxChannels;
    }

    private void setPort(String p) {
        this.port = p;
    }

    public void setQueueLength(String queueLength) {
        this.queueLength = queueLength;
    }
}

