/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.AwtElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.JunitElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MonitorElement;
import org.eclipse.soda.devicekit.generator.model.elements.PlayBackElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReceiverElement;
import org.eclipse.soda.devicekit.generator.model.elements.ServletElement;
import org.eclipse.soda.devicekit.generator.model.elements.SwtElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class TestElement
extends MainTagElement {
    private String fTestCount;
    private String fTestDelay;
    private String fTestExecute;
    private String fTestExecuteRead;
    private String fTestExecuteWrite;
    private String fTestRead;
    private String fTestTrigger;

    public TestElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String[] getImplementedInterfaces() {
        return new String[0];
    }

    public String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT;
    }

    public int getTagCode() {
        return 10;
    }

    public String getTargetClass() {
        List target = this.getAllChildrenWithTagCode(8);
        String result = this.getTargetClass(target, 8);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(9);
        result = this.getTargetClass(target, 9);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(18);
        result = this.getTargetClass(target, 18);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(72);
        result = this.getTargetClass(target, 72);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(74);
        result = this.getTargetClass(target, 74);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(97);
        result = this.getTargetClass(target, 97);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(91);
        result = this.getTargetClass(target, 91);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(36);
        result = this.getTargetClass(target, 36);
        if (result != null) {
            return result;
        }
        return result;
    }

    private String getTargetClass(List target, int targetCode) {
        if (target.size() > 0) {
            TagElement firstElement = (TagElement)target.get(0);
            String implementation = firstElement.getImplementation();
            if (implementation != null) {
                return implementation;
            }
            String idref = firstElement.getAttribute("idref");
            if (idref != null) {
                List devs = this.getParent().getAllChildrenWithTagCode(targetCode);
                int i = 0;
                while (i < devs.size()) {
                    TagElement element = (TagElement)devs.get(i);
                    if (idref.equals(element.getId())) {
                        String className = element.getImplementation();
                        return className;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public String getTestCount() {
        return this.fTestCount;
    }

    public String getTestDelay() {
        return this.fTestDelay;
    }

    public String getTestExecute() {
        if (this.fTestExecute != null && this.fTestExecute.equals("0")) {
            return "false";
        }
        if (this.fTestExecute != null && this.fTestExecute.equals("1")) {
            return "true";
        }
        return this.fTestExecute;
    }

    public String getTestExecuteRead() {
        if (this.fTestExecuteRead != null && this.fTestExecuteRead.equals("0")) {
            return "false";
        }
        if (this.fTestExecuteRead != null && this.fTestExecuteRead.equals("1")) {
            return "true";
        }
        return this.fTestExecuteRead;
    }

    public String getTestExecuteWrite() {
        if (this.fTestExecuteWrite != null && this.fTestExecuteWrite.equals("0")) {
            return "false";
        }
        if (this.fTestExecuteWrite != null && this.fTestExecuteWrite.equals("1")) {
            return "true";
        }
        return this.fTestExecuteWrite;
    }

    public String getTestRead() {
        if (this.fTestRead != null && this.fTestRead.equals("0")) {
            return "false";
        }
        if (this.fTestRead != null && this.fTestRead.equals("1")) {
            return "true";
        }
        return this.fTestRead;
    }

    public String getTestTrigger() {
        if (this.fTestTrigger != null && this.fTestTrigger.equals("0")) {
            return "false";
        }
        if (this.fTestTrigger != null && this.fTestTrigger.equals("1")) {
            return "true";
        }
        return this.fTestTrigger;
    }

    protected void handleAdapter(Node childNode) {
        AdapterElement element = new AdapterElement(childNode, this);
        this.addChild(element);
    }

    protected void handleAgent(Node childNode) {
        AgentElement element = new AgentElement(childNode, this);
        this.addChild(element);
    }

    protected void handleAwt(Node childNode) {
        AwtElement element = new AwtElement(childNode, this);
        this.addChild(element);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("device".equals(childNodeName)) {
            this.handleDevice(childNode);
        } else if ("transport".equals(childNodeName)) {
            this.handleTransport(childNode);
        } else if ("receiver".equals(childNodeName)) {
            this.handleReceiver(childNode);
        } else if ("testcount".equals(childNodeName)) {
            this.setTestCount(ParserUtilities.extractData(childNode));
        } else if ("testdelay".equals(childNodeName)) {
            this.setTestDelay(ParserUtilities.extractData(childNode));
        } else if ("testexecute".equals(childNodeName)) {
            this.setTestExecute(ParserUtilities.extractData(childNode));
        } else if ("testexecuteread".equals(childNodeName)) {
            this.setTestExecuteRead(ParserUtilities.extractData(childNode));
        } else if ("testexecutewrite".equals(childNodeName)) {
            this.setTestExecuteWrite(ParserUtilities.extractData(childNode));
        } else if ("testread".equals(childNodeName)) {
            this.setTestRead(ParserUtilities.extractData(childNode));
        } else if ("testtrigger".equals(childNodeName)) {
            this.setTestTrigger(ParserUtilities.extractData(childNode));
        } else if ("monitor".equals(childNodeName)) {
            this.handleRecord(childNode);
        } else if ("playback".equals(childNodeName)) {
            this.handlePlayBack(childNode);
        } else if ("junit".equals(childNodeName)) {
            this.handleJunit(childNode);
        } else if ("concrete".equals(childNodeName)) {
            this.handleConcrete(childNode);
        } else if ("connection".equals(childNodeName)) {
            this.handleConnection(childNode);
        } else if ("agent".equals(childNodeName)) {
            this.handleAgent(childNode);
        } else if ("adapter".equals(childNodeName)) {
            this.handleAdapter(childNode);
        } else if ("profile".equals(childNodeName)) {
            this.handleProfile(childNode);
        } else if ("testcase".equals(childNodeName)) {
            this.handleTestCase(childNode);
        } else if ("swt".equals(childNodeName)) {
            this.handleSwt(childNode);
        } else if ("awt".equals(childNodeName)) {
            this.handleAwt(childNode);
        } else if ("servlet".equals(childNodeName)) {
            this.handleServlet(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleConcrete(Node childNode) {
        ConcreteElement element = new ConcreteElement(childNode, this);
        this.addChild(element);
    }

    protected void handleConnection(Node childNode) {
        ConnectionElement element = new ConnectionElement(childNode, this);
        this.addChild(element);
    }

    private void handleDevice(Node childNode) {
        DeviceElement element = new DeviceElement(childNode, this);
        this.addChild(element);
    }

    private void handleJunit(Node childNode) {
        JunitElement element = new JunitElement(childNode, this);
        this.addChild(element);
    }

    private void handlePlayBack(Node childNode) {
        PlayBackElement element = new PlayBackElement(childNode, this);
        this.addChild(element);
    }

    protected void handleProfile(Node childNode) {
        ProfileElement element = new ProfileElement(childNode, this);
        this.addChild(element);
    }

    private void handleReceiver(Node childNode) {
        ReceiverElement element = new ReceiverElement(childNode, this);
        this.addChild(element);
    }

    private void handleRecord(Node childNode) {
        MonitorElement element = new MonitorElement(childNode, this);
        this.addChild(element);
    }

    protected void handleServlet(Node childNode) {
        ServletElement element = new ServletElement(childNode, this);
        this.addChild(element);
    }

    protected void handleSwt(Node childNode) {
        SwtElement element = new SwtElement(childNode, this);
        this.addChild(element);
    }

    protected void handleTestCase(Node childNode) {
        TestCaseElement element = new TestCaseElement(childNode, this);
        this.addChild(element);
    }

    private void handleTransport(Node childNode) {
        TransportElement element = new TransportElement(childNode, this);
        this.addChild(element);
    }

    protected void setTestCount(String testCount) {
        this.fTestCount = testCount;
    }

    protected void setTestDelay(String testDelay) {
        this.fTestDelay = testDelay;
    }

    protected void setTestExecute(String testExecute) {
        this.fTestExecute = testExecute;
    }

    protected void setTestExecuteRead(String testExecuteRead) {
        this.fTestExecuteRead = testExecuteRead;
    }

    protected void setTestExecuteWrite(String testExecuteWrite) {
        this.fTestExecuteWrite = testExecuteWrite;
    }

    protected void setTestRead(String testRead) {
        this.fTestRead = testRead;
    }

    protected void setTestTrigger(String testTrigger) {
        this.fTestTrigger = testTrigger;
    }
}

