/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.java;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.soda.devicekit.generator.model.java.JavaKeywords;

public class CodeUtilities
implements Comparator {
    public static final int LOWER = 0;
    public static final int CAP = 1;
    public static final int CAPWORDS = 2;
    public static final String[] NUMER_STRINGS = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    public static final String[] UPPER_NUMER_STRINGS = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};

    public static String betterDescriptionFromProjectName(String projectName, String prefix) {
        String data = projectName.substring(prefix.length() + 1);
        StringBuffer buffer = new StringBuffer(64);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            if (last) {
                if (i > 0) {
                    buffer.append(' ');
                }
                buffer.append(Character.toUpperCase(character));
            } else if (character != '.') {
                buffer.append(character);
            }
            last = character == '.';
            ++i;
        }
        return buffer.toString();
    }

    public static String betterName(String data, boolean caps) {
        if (caps) {
            return CodeUtilities.betterName(data, 1);
        }
        return CodeUtilities.betterName(data, 0);
    }

    public static String betterName(String data, int type) {
        StringBuffer buffer = new StringBuffer(64);
        boolean upperLast = true;
        boolean digitLast = true;
        int charCount = 0;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            if (Character.isLetterOrDigit(character)) {
                boolean blankBreak;
                char nextCharacter = i < data.length() - 1 ? data.charAt(i + 1) : (char)' ';
                boolean nextCharLower = Character.isLowerCase(nextCharacter);
                boolean upper = Character.isUpperCase(character);
                boolean digit = Character.isDigit(character);
                boolean bl = blankBreak = charCount > 0 && (upper && !upperLast || digit && !digitLast || upper && nextCharLower);
                if (blankBreak) {
                    buffer.append(' ');
                }
                if (charCount > 0) {
                    if (type > 0 && upper && !nextCharLower) {
                        buffer.append(Character.toUpperCase(character));
                    } else if (type == 2 && blankBreak) {
                        buffer.append(Character.toUpperCase(character));
                    } else {
                        buffer.append(Character.toLowerCase(character));
                    }
                } else if (type == 0) {
                    buffer.append(Character.toLowerCase(character));
                } else {
                    buffer.append(Character.toUpperCase(character));
                }
                upperLast = upper;
                digitLast = digit;
                ++charCount;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String betterNameFromProjectName(String projectName, String prefix) {
        String data = projectName.substring(prefix.length() + 1);
        StringBuffer buffer = new StringBuffer(64);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            if (last) {
                buffer.append(Character.toUpperCase(character));
            } else if (character != '.') {
                buffer.append(character);
            }
            last = character == '.';
            ++i;
        }
        return buffer.toString();
    }

    public static String betterStaticName(String data, int type) {
        StringBuffer buffer = new StringBuffer(64);
        boolean upperLast = true;
        int charCount = 0;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            if (Character.isLetterOrDigit(character)) {
                boolean blankBreak;
                char nextCharacter = i < data.length() - 1 ? data.charAt(i + 1) : (char)' ';
                boolean nextCharLower = Character.isLowerCase(nextCharacter);
                boolean upper = Character.isUpperCase(character);
                boolean bl = blankBreak = charCount > 0 && (upper && !upperLast || upper && nextCharLower);
                if (blankBreak) {
                    buffer.append(' ');
                }
                if (charCount > 0) {
                    if (type > 0 && upper && !nextCharLower) {
                        buffer.append(Character.toUpperCase(character));
                    } else if (type == 2 && blankBreak) {
                        buffer.append(Character.toUpperCase(character));
                    } else {
                        buffer.append(Character.toLowerCase(character));
                    }
                } else if (type == 0) {
                    buffer.append(Character.toLowerCase(character));
                } else {
                    buffer.append(Character.toUpperCase(character));
                }
                upperLast = upper;
                ++charCount;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String fieldName(String key) {
        return CodeUtilities.validIdentifier(key, false);
    }

    public static String fieldReference(String key, boolean lazy) {
        StringBuffer buffer = new StringBuffer(128);
        CodeUtilities.fieldReference(key, lazy, buffer);
        return buffer.toString();
    }

    public static void fieldReference(String key, boolean lazy, StringBuffer buffer) {
        if (lazy) {
            buffer.append("get");
            buffer.append(CodeUtilities.methodName(key));
            buffer.append("()");
        } else {
            buffer.append("this.");
            buffer.append(CodeUtilities.fieldName(key));
        }
    }

    public static boolean isJavaKeyword(String segment) {
        String[] keywords = JavaKeywords.keywords;
        int i = 0;
        while (i < keywords.length) {
            if (segment.equalsIgnoreCase(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String methodName(String key) {
        return CodeUtilities.validIdentifier(key, true);
    }

    public static String staticFieldName(String key) {
        return CodeUtilities.validIdentifier(key, true);
    }

    public static String staticFieldName(String key, boolean allUpper) {
        if (allUpper) {
            return CodeUtilities.validStaticIdentifier(key);
        }
        return CodeUtilities.validIdentifier(key, true);
    }

    public static String validIdentifier(String key, boolean upperCase) {
        String result;
        char[] characters = key.toCharArray();
        StringBuffer buffer = new StringBuffer(characters.length + 1);
        if (characters.length > 0) {
            char character = characters[0];
            if (Character.isLetter(character)) {
                if (upperCase) {
                    buffer.append(Character.toUpperCase(character));
                } else {
                    buffer.append(Character.toLowerCase(character));
                }
            } else {
                if (characters.length == 1) {
                    if (upperCase) {
                        return UPPER_NUMER_STRINGS[character - 48];
                    }
                    return NUMER_STRINGS[character - 48];
                }
                if (upperCase) {
                    buffer.append('A');
                } else {
                    buffer.append('a');
                }
                buffer.append(character);
            }
            int i = 1;
            while (i < characters.length) {
                character = characters[i];
                if (Character.isJavaIdentifierPart(character)) {
                    buffer.append(character);
                } else {
                    buffer.append('_');
                }
                ++i;
            }
        }
        if (!JavaConventions.validateIdentifier((String)(result = buffer.toString()), (String)"1.3", (String)"1.3").isOK()) {
            buffer.append('_');
        }
        return buffer.toString();
    }

    public static String validStaticIdentifier(String key) {
        String result;
        String upperKey = key.toUpperCase();
        if (key.equals(upperKey)) {
            return key;
        }
        char[] characters = key.toCharArray();
        StringBuffer buffer = new StringBuffer(characters.length + 1);
        if (characters.length > 0) {
            char character = characters[0];
            if (!Character.isLetter(character)) {
                buffer.append('A');
            }
            String betterName = CodeUtilities.betterStaticName(key, 2).replace(' ', '_').toUpperCase();
            buffer.append(betterName);
        }
        if (!JavaConventions.validateIdentifier((String)(result = buffer.toString()), (String)"1.3", (String)"1.3").isOK()) {
            buffer.append('_');
        }
        return buffer.toString();
    }

    public int compare(Object arg0, Object arg1) {
        String s0 = CodeUtilities.betterName(String.valueOf(arg0), false);
        String s1 = CodeUtilities.betterName(String.valueOf(arg1), false);
        StringTokenizer st0 = new StringTokenizer(s0, " ");
        StringTokenizer st1 = new StringTokenizer(s1, " ");
        int st0Count = st0.countTokens();
        int st1Count = st1.countTokens();
        int min = Math.min(st0Count, st1Count);
        int i = 0;
        while (i < min) {
            String token1;
            String token0 = st0.nextToken();
            int result = token0.compareTo(token1 = st1.nextToken());
            if (result != 0) {
                try {
                    long i0 = Long.parseLong(token0);
                    long i1 = Long.parseLong(token1);
                    return (int)(i0 - i1);
                }
                catch (NumberFormatException numberFormatException) {
                    return result;
                }
            }
            ++i;
        }
        return st0Count - st1Count;
    }
}

