/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.preference.jre.DeviceKitJREConstants;

public class JREPreferenceUtil {
    private static String[] executionEnvironments;

    public static String[] convertEEStringToArray(String executionEnvironments) {
        if (executionEnvironments == null || executionEnvironments.equals(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_NONE) || executionEnvironments.equals("")) {
            return new String[0];
        }
        return executionEnvironments.split(",");
    }

    private static void fillExecutionEnvironments() {
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        ArrayList<IExecutionEnvironment> fEnvironments = new ArrayList<IExecutionEnvironment>();
        int i = 0;
        while (i < environments.length) {
            fEnvironments.add(environments[i]);
            ++i;
        }
        Collections.sort(fEnvironments, new Comparator(){

            public int compare(Object o1, Object o2) {
                IExecutionEnvironment left = (IExecutionEnvironment)o1;
                IExecutionEnvironment right = (IExecutionEnvironment)o2;
                return left.getId().compareToIgnoreCase(right.getId());
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        executionEnvironments = new String[fEnvironments.size()];
        Iterator iter = fEnvironments.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            IExecutionEnvironment env = (IExecutionEnvironment)iter.next();
            JREPreferenceUtil.executionEnvironments[i2] = env.getId();
            ++i2;
        }
    }

    public static String[] getAllExecutionEnvironments() {
        if (DeviceKitPlugin.getDefault() == null) {
            return new String[0];
        }
        if (executionEnvironments == null) {
            JREPreferenceUtil.fillExecutionEnvironments();
        }
        return executionEnvironments;
    }

    public static String[] getDefaultExecutionEnvironments(String type) {
        String defaultExecutionEnvironments = JREPreferenceUtil.getDefaultString(DeviceKitJREConstants.getExecutionEnvironmentsKey((String)type));
        return JREPreferenceUtil.convertEEStringToArray(defaultExecutionEnvironments);
    }

    public static String getDefaultJreInClasspath(String type) {
        return JREPreferenceUtil.getDefaultString(DeviceKitJREConstants.getJREInClasspathKey((String)type));
    }

    private static String getDefaultString(String key) {
        return DeviceKitPreferenceInitializer.getDefaultString((String)key);
    }

    public static String[] getExecutionEnvironments(String type) {
        String executionEnvironments = JREPreferenceUtil.getExecutionEnvironmentsString(type);
        return JREPreferenceUtil.convertEEStringToArray(executionEnvironments);
    }

    public static String[] getExecutionEnvironmentsByProjectName(String name) {
        String executionEnvironments = JREPreferenceUtil.getExecutionEnvironmentsStringByProjectName(name);
        return JREPreferenceUtil.convertEEStringToArray(executionEnvironments);
    }

    public static String getExecutionEnvironmentsString(String type) {
        if (DeviceKitPlugin.getDefault() == null) {
            return "";
        }
        String executionEnvironments = JREPreferenceUtil.getPreferenceString(DeviceKitJREConstants.getExecutionEnvironmentsKey((String)type));
        if (executionEnvironments.equals(DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_NONE)) {
            return "";
        }
        return executionEnvironments;
    }

    public static String getExecutionEnvironmentsStringByProjectName(String name) {
        if (name.endsWith(".test")) {
            return JREPreferenceUtil.getExecutionEnvironmentsString(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_TEST);
        }
        if (name.endsWith(".test.agent")) {
            return JREPreferenceUtil.getExecutionEnvironmentsString(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_TESTAGENT);
        }
        return JREPreferenceUtil.getExecutionEnvironmentsString(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_DEFAULT);
    }

    public static String getJREClasspathEntryLastSegment(IJavaProject jProject) throws Exception {
        return JavaRuntime.computeJREEntry((IJavaProject)jProject).getPath().lastSegment().replace('%', '/');
    }

    public static String getJreInClasspath(String type) {
        if (DeviceKitPlugin.getDefault() != null) {
            String jre = JREPreferenceUtil.getPreferenceString(DeviceKitJREConstants.getJREInClasspathKey((String)type));
            return jre;
        }
        return "";
    }

    public static String getJreInClasspathByProjectName(String name) {
        if (name.endsWith(".test")) {
            return JREPreferenceUtil.getJreInClasspath(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_TEST);
        }
        if (name.endsWith(".test.agent")) {
            return JREPreferenceUtil.getJreInClasspath(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_TESTAGENT);
        }
        return JREPreferenceUtil.getJreInClasspath(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_DEFAULT);
    }

    public static String getJRERuntimePath(String jre) {
        if (DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE.equals(jre)) {
            return jre;
        }
        IExecutionEnvironment ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(jre);
        if (ee == null) {
            ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(DeviceKitJREConstants.JRE_IN_CLASSPATH_DEFAULT);
        }
        if (ee != null) {
            return JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee).toString();
        }
        return DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE;
    }

    private static String getPreferenceString(String key) {
        String value = DeviceKitPreferenceInitializer.getPreferenceString((String)key);
        if (value.equals("")) {
            return JREPreferenceUtil.getDefaultString(key);
        }
        return value;
    }

    public static boolean isWorkspaceDefaultJRE(String jre) {
        return DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE.equals(jre);
    }

    public static void processExecutionEnvironmentsInManifest(IJavaProject jProject, ManifestModel manifestModel) throws Exception {
        String name = jProject.getProject().getName();
        String JREinClasspath = JREPreferenceUtil.getJREClasspathEntryLastSegment(jProject);
        String preferredJREinClasspath = JREPreferenceUtil.getJreInClasspathByProjectName(name);
        String preferredExecutionEnvironments = JREPreferenceUtil.getExecutionEnvironmentsStringByProjectName(name);
        if (!JREinClasspath.equals(DeviceKitJREConstants.WORKSPACE_DEFAULT_JRE)) {
            if (JREinClasspath.equals(preferredJREinClasspath)) {
                manifestModel.setBundleRequiredExecutionEnvironments(preferredExecutionEnvironments);
            } else {
                manifestModel.setBundleRequiredExecutionEnvironments(JREinClasspath);
            }
        }
    }

    public static void saveExecutionEnvironments(String type, String[] executionEnvironments) {
        if (executionEnvironments.length == 0) {
            DeviceKitPreferenceInitializer.setPreference((String)DeviceKitJREConstants.getExecutionEnvironmentsKey((String)type), (String[])new String[]{DeviceKitJREConstants.EXECUTION_ENVIRONMENTS_NONE});
        } else {
            DeviceKitPreferenceInitializer.setPreference((String)DeviceKitJREConstants.getExecutionEnvironmentsKey((String)type), (String[])executionEnvironments);
        }
    }

    public static void saveJreInClasspath(String type, String value) {
        DeviceKitPreferenceInitializer.setPreference((String)DeviceKitJREConstants.getJREInClasspathKey((String)type), (String)value);
    }
}

