/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.ui.preference.CommonPreferencePage;
import org.eclipse.soda.devicekit.ui.preference.PreferenceMessages;
import org.eclipse.soda.devicekit.util.VersionValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DeviceKitPreferencePage
extends CommonPreferencePage
implements IWorkbenchPreferencePage,
IWizardPage {
    private Composite contents = null;
    private Map controls = new HashMap();

    public DeviceKitPreferencePage() {
        super("Device");
        if (DeviceKitPlugin.getDefault() != null) {
            this.setPreferenceStore(DeviceKitPlugin.getDefault().getPreferenceStore());
        }
    }

    public Button createCheckBox(Composite contents, String fieldName) {
        GridData data;
        String labelString = this.getResourceString(String.valueOf(fieldName) + ".title");
        if (labelString != null && labelString.length() > 0 && !labelString.startsWith("!")) {
            Label label = new Label(contents, 16384);
            label.setText("");
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
            label = new Label(contents, 16384);
            label.setText(labelString);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
        }
        Button button = new Button(contents, 32);
        button.setText(this.getResourceString(fieldName));
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        button.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        boolean value = this.getBoolean(fieldName);
        button.setSelection(value);
        return button;
    }

    protected Control createContents(Composite parent) {
        this.contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.contents.setLayout((Layout)layout);
        int i = 0;
        while (i < this.getTextNames().length) {
            this.put(this.getTextNames()[i], (Control)this.createText(this.getContents(), this.getTextNames()[i]));
            ++i;
        }
        i = 0;
        while (i < this.getButtonNames().length) {
            this.put(this.getButtonNames()[i], (Control)this.createCheckBox(this.getContents(), this.getButtonNames()[i]));
            ++i;
        }
        i = 0;
        while (i < this.getListNames().length) {
            this.put(this.getListNames()[i], (Control)this.createList(this.getContents(), this.getListNames()[i]));
            ++i;
        }
        this.createListeners();
        Dialog.applyDialogFont((Control)parent);
        return this.contents;
    }

    public List createList(Composite contents, String fieldName) {
        Label label = new Label(contents, 16384);
        label.setText(this.getResourceString(String.valueOf(fieldName) + ".label"));
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)data);
        List list = new List(contents, 2050);
        String[] items = this.getResourceStringArray(fieldName);
        list.setItems(items);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)data);
        list.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        return list;
    }

    protected void createListeners() {
        Text text = this.getText("version");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceKitPreferencePage.this.isValid();
            }
        });
    }

    public Text createText(Composite contents, String fieldName) {
        Label label;
        String labelString = this.getResourceString(String.valueOf(fieldName) + ".title");
        if (labelString != null && labelString.length() > 0 && !labelString.startsWith("!")) {
            label = new Label(contents, 16384);
            label.setText("");
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
            label = new Label(contents, 16384);
            label.setText(labelString);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
        }
        label = new Label(contents, 16384);
        label.setText(this.getResourceString(fieldName));
        label.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        Text text = new Text(contents, 2052);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        text.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        String value = this.getString(fieldName);
        text.setText(value);
        return text;
    }

    public Control get(String key) {
        return (Control)this.controls.get(key);
    }

    public boolean getBoolean(String fieldName) {
        if (this.getPreferenceStore() != null) {
            return this.getPreferenceStore().getBoolean(fieldName);
        }
        return false;
    }

    public Button getButton(String key) {
        return (Button)this.controls.get(key);
    }

    public String[] getButtonNames() {
        return new String[]{"incubation", "multiplex", "generateold", "generate.java", "generate.manifest", "generate.metadata", "generate.properties", "schema", "create.test", "create.testcase", "create.bundle", "create.managed.bundle", "create.managed.factory.bundle"};
    }

    public boolean getButtonSelection(String key) {
        Button button = this.getButton(key);
        if (button != null) {
            return button.getSelection();
        }
        return false;
    }

    public Composite getContents() {
        return this.contents;
    }

    public String[] getListNames() {
        return new String[0];
    }

    public String getResourceString(String key) {
        return PreferenceMessages.getString(key);
    }

    public String[] getResourceStringArray(String key) {
        String value = this.getResourceString(key);
        StringTokenizer tokenizer = new StringTokenizer(value, ", ");
        int count = tokenizer.countTokens();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public Text getText(String key) {
        return (Text)this.controls.get(key);
    }

    public String[] getTextNames() {
        return new String[]{"packagebase", "provider", "version", "vendor", "vendortwo"};
    }

    public String getTextString(String key) {
        Text text = this.getText(key);
        if (text != null) {
            return text.getText().trim();
        }
        return "";
    }

    public void init(IWorkbench arg0) {
    }

    public boolean isValid() {
        if (!this.validateVersion()) {
            this.setErrorMessage(PreferenceMessages.getString("invalid.version"));
            this.setValid(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        return true;
    }

    protected void performDefaults() {
        String key;
        super.performDefaults();
        int i = 0;
        while (i < this.getTextNames().length) {
            key = this.getTextNames()[i];
            Text text = this.getText(key);
            String string = this.getPreferenceStore().getDefaultString(key);
            text.setText(string);
            ++i;
        }
        i = 0;
        while (i < this.getButtonNames().length) {
            key = this.getButtonNames()[i];
            Button button = this.getButton(key);
            boolean value = this.getPreferenceStore().getDefaultBoolean(key);
            button.setSelection(value);
            ++i;
        }
    }

    public boolean performOk() {
        String key;
        int i = 0;
        while (i < this.getTextNames().length) {
            key = this.getTextNames()[i];
            String string = this.getTextString(key);
            this.getPreferenceStore().setValue(key, string);
            ++i;
        }
        i = 0;
        while (i < this.getButtonNames().length) {
            key = this.getButtonNames()[i];
            boolean value = this.getButtonSelection(key);
            this.getPreferenceStore().setValue(key, value);
            ++i;
        }
        return true;
    }

    public void put(String key, Control control) {
        this.controls.put(key, control);
    }

    protected boolean validateVersion() {
        String version = this.getText("version").getText().trim();
        return VersionValidator.isValidVersion((String)version);
    }
}

