/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.transport;

import org.eclipse.soda.dk.barcode.reader.transport.service.BarcodeReaderTransportService;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.serial.connection.SerialConnection;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class BarcodeReaderTransport
extends ConnectionTransport
implements TransportService,
BarcodeReaderTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.barcode.reader.transport.BarcodeReaderTransport";
    private int messageMinimumSize = 1;

    protected int processInput(byte[] bytes, int length) throws Exception {
        Object timestamp = null;
        if (length >= this.getMessageMinimumSize()) {
            byte[] messageBytes = new byte[length];
            System.arraycopy(bytes, 0, messageBytes, 0, length);
            Message message = new Message(messageBytes);
            if (timestamp == null) {
                timestamp = BarcodeReaderTransport.getCurrentTimestamp();
            }
            this.fireMessageReceived(timestamp, (MessageService)message);
            return length;
        }
        return 0;
    }

    public ConnectionService getDefaultConnection() {
        String type = this.getString("barcodereadertransport.connection", "serial");
        if (type.equals("tcpip")) {
            return this.getDefaultTcpipConnection();
        }
        return this.getDefaultSerialConnection();
    }

    public SerialConnectionService getDefaultSerialConnection() {
        return new SerialConnection(this.getInt("barcodereadertransport.comport", 1), this.getInt("barcodereadertransport.baudrate", 9600), this.getInt("barcodereadertransport.databits", 8), this.getInt("barcodereadertransport.parity", 0), this.getInt("barcodereadertransport.stopbits", 0), this.getInt("barcodereadertransport.hardwareflowcontrol", 0), this.getInt("barcodereadertransport.softwareflowcontrol", 0), this.getInt("barcodereadertransport.readtotaltimeout", 1000), this.getInt("barcodereadertransport.readintervaltimeout", 50), this.getInt("barcodereadertransport.writetotaltimeout", 100));
    }

    public TcpipConnectionService getDefaultTcpipConnection() {
        return new TcpipConnection(this.getString("barcodereadertransport.host", "localhost"), this.getInt("barcodereadertransport.remoteport", 8901), this.getInt("barcodereadertransport.localport", -1), this.getInt("barcodereadertransport.readtimeout", 1000), this.getInt("barcodereadertransport.readsize", -1), this.getInt("barcodereadertransport.writesize", -1), this.getInt("barcodereadertransport.linger", -1));
    }

    public int getMessageMinimumSize() {
        return this.messageMinimumSize;
    }

    public void setMessageMinimumSize(int MessageMinimumSize) {
        this.messageMinimumSize = MessageMinimumSize;
    }

    public void setup() {
        super.setup();
        this.setMessageMinimumSize(this.getInt("barcodereadertransport.MessageMinimumSize", this.getMessageMinimumSize()));
        this.setRetryTime(this.getLong("barcodereadertransport.retrytime", this.getRetryTime()));
        this.setTransmitRetries(this.getInt("barcodereadertransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("barcodereadertransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

