/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.data.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.data.Degree;
import org.eclipse.soda.dk.data.LongitudeData;

public class DegreeTestcase
extends TestCase {
    private Degree degree;
    static /* synthetic */ Class class$0;

    public DegreeTestcase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        System.out.println(9223372036L);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.data.testcase.DegreeTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public LongitudeData getLongitude(String nmeaString) {
        try {
            int lenght = nmeaString.length();
            String data = nmeaString.substring(0, lenght - 1);
            int value = Degree.parseNmeaDegree((String)data);
            if (nmeaString.endsWith("W")) {
                value = -value;
            }
            return new LongitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void test0() {
        this.degree = new Degree("123");
        DegreeTestcase.assertEquals((String)"123", (String)this.degree.toString());
    }

    public void test1() {
        this.degree = new Degree("1.100000");
        DegreeTestcase.assertEquals((String)"1.1", (String)this.degree.toString());
    }

    public void test10() {
        System.out.println("test10: Nmea string: " + Degree.toDegreeString((int)342935527, (String)""));
    }

    public void test11() {
        int degree = Degree.parseMetarDegree((String)"12-34-56N");
        DegreeTestcase.assertEquals((String)"12\u00b034'56\"", (String)Degree.toDegreeString((int)degree, (String)""));
    }

    public void test12() {
        int degree = Degree.parseNmeaDegree((String)"1230");
        DegreeTestcase.assertEquals((String)"12.5", (String)Degree.toString((int)degree));
    }

    public void test13() {
        int degree = Degree.parseNmeaDegree((String)"1230");
        degree = -degree;
        DegreeTestcase.assertEquals((String)"-12.5", (String)Degree.toString((int)degree));
    }

    public void test14() {
        int degree = 439338456;
        degree = -degree;
        DegreeTestcase.assertEquals((String)"122\u00b02'18.456\"", (String)Degree.toDegreeString((int)degree, (String)""));
    }

    public void test15() {
        int bdegree = Degree.parseMetarDegree((String)"12-34-56N");
        System.out.println("test15: Metar answer: " + Degree.toDegreeString((int)bdegree, (String)""));
        DegreeTestcase.assertEquals((String)"12\u00b034'56\"", (String)Degree.toDegreeString((int)bdegree, (String)""));
    }

    public void test16() {
        Degree degree = new Degree("42.24433517456055");
        System.out.println(Degree.toDegreeString((int)degree.getFixedDegree(), (String)""));
        DegreeTestcase.assertEquals((String)"42.24433", (String)degree.toString());
    }

    public void test17() {
        System.gc();
        System.gc();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 200000) {
            new Degree("42.24433517456055");
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("parse time " + (end - start));
    }

    public void test18() {
        System.gc();
        System.gc();
        String x = "";
        Degree degree = new Degree("42.24433517456055");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 200000) {
            x = degree.toString();
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("toString time " + (end - start));
        System.out.println(x);
    }

    public void test19() {
        LongitudeData degree = this.getLongitude("07842.076W");
        System.out.println(Degree.toNmeaString((int)degree.getThousandSeconds(), (String)"W"));
        DegreeTestcase.assertEquals((String)"7842.076W", (String)Degree.toNmeaString((int)degree.getThousandSeconds(), (String)"W"));
    }

    public void test2() {
        this.degree = new Degree(".1");
        DegreeTestcase.assertEquals((String)".1", (String)this.degree.toString());
    }

    public void test3() {
        this.degree = new Degree("123.456");
        DegreeTestcase.assertEquals((String)"123.456", (String)this.degree.toString());
    }

    public void test4() {
        this.degree = new Degree("123.45678");
        DegreeTestcase.assertEquals((String)"123.45678", (String)this.degree.toString());
    }

    public void test5() {
        int degree = Degree.parseNmeaDegree((String)"1230.0");
        DegreeTestcase.assertEquals((String)"12.5", (String)Degree.toString((int)degree));
    }

    public void test6() {
        DegreeTestcase.assertEquals((String)"37\u00b023'39.768\"", (String)Degree.toDegreeString((int)134619768, (String)""));
    }

    public void test7() {
        DegreeTestcase.assertEquals((String)"122\u00b02'18.456\"", (String)Degree.toDegreeString((int)439338456, (String)""));
    }

    public void test8() {
        System.out.println("Nmea string: " + Degree.toDegreeString((int)0, (String)""));
        DegreeTestcase.assertEquals((String)"0\u00b0", (String)Degree.toDegreeString((int)0, (String)""));
    }

    public void test9() {
        System.out.println("Nmea string: " + Degree.toDegreeString((int)1800000, (String)""));
        DegreeTestcase.assertEquals((String)"0\u00b030'", (String)Degree.toDegreeString((int)1800000, (String)""));
    }
}

