/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.data.IntegerFraction;
import org.eclipse.soda.dk.transform.IntegerTranslateTransform;

public class IntegerTranslateTransformTestcase
extends TestCase {
    private IntegerTranslateTransform transform;
    private Object obj;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transform.testcase.IntegerTranslateTransformTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public IntegerTranslateTransformTestcase(String name) {
        super(name);
    }

    public void testDecodeForException() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        IntegerTranslateTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        IntegerTranslateTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testDecodeForTypeFloat() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = this.transform.decode((Object)new Float(1.5));
        IntegerTranslateTransformTestcase.assertTrue((String)("Should Still Equal 2.5 results: " + this.obj), ((double)((Number)this.obj).floatValue() == 2.5 ? 1 : 0) != 0);
    }

    public void testDecodeForTypeInteger() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = this.transform.decode((Object)new Integer(1000));
        IntegerTranslateTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testDecodeTranslateByOne() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = this.transform.decode((Object)new Integer(5));
        IntegerTranslateTransformTestcase.assertTrue((String)"Should Still Equal 6", (this.obj instanceof Integer && (Integer)this.obj == 6 ? 1 : 0) != 0);
    }

    public void testDecodeTranslateByOneTo3Over2() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = this.transform.decode((Object)new IntegerFraction(3, 2));
        IntegerTranslateTransformTestcase.assertTrue((String)("Should Still Equal 2.5 results: " + this.obj), ((double)((Number)this.obj).floatValue() == 2.5 ? 1 : 0) != 0);
    }

    public void testDecodeTranslateByZero() {
        this.transform = new IntegerTranslateTransform(0);
        this.obj = this.transform.decode((Object)new Integer(5));
        IntegerTranslateTransformTestcase.assertTrue((String)"Should Still Equal 5", (this.obj instanceof Integer && (Integer)this.obj == 5 ? 1 : 0) != 0);
    }

    public void testEncodeForException() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        IntegerTranslateTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        IntegerTranslateTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testEncodeForTypeInteger() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = this.transform.encode((Object)new Integer(1000));
        IntegerTranslateTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testEncodeTranslateByOne() {
        this.transform = new IntegerTranslateTransform(1);
        this.obj = this.transform.encode((Object)new Integer(5));
        IntegerTranslateTransformTestcase.assertTrue((String)"Should Still Equal 4", (this.obj instanceof Integer && (Integer)this.obj == 4 ? 1 : 0) != 0);
    }

    public void testEncodeTranslateByZero() {
        this.transform = new IntegerTranslateTransform(0);
        this.obj = this.transform.encode((Object)new Integer(5));
        IntegerTranslateTransformTestcase.assertTrue((String)"Should Still Equal 5", (this.obj instanceof Integer && (Integer)this.obj == 5 ? 1 : 0) != 0);
    }

    public void testTransformConstruction() {
        this.transform = new IntegerTranslateTransform(1);
        IntegerTranslateTransformTestcase.assertTrue((String)"IntegerTranslateTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new IntegerTranslateTransform(-1);
        IntegerTranslateTransformTestcase.assertTrue((String)"IntegerTranslateTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new IntegerTranslateTransform(Integer.MAX_VALUE);
        IntegerTranslateTransformTestcase.assertTrue((String)"IntegerTranslateTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new IntegerTranslateTransform(Integer.MIN_VALUE);
        IntegerTranslateTransformTestcase.assertTrue((String)"IntegerTranslateTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

