/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.List;
import java.util.Vector;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameters;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class ListParameters
extends MapParameters
implements ParameterService {
    public ListParameters(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public ListParameters(String key, ParameterService[] parameters, int offset) {
        super(key, parameters, offset);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        ParameterCursorService tcursor = cursor != null ? cursor : new ParameterCursor();
        int length = this.parameters.length;
        Vector<Object> result = new Vector<Object>(length);
        int index = 0;
        while (index < length) {
            ParameterService parameter = this.parameters[index];
            Object resultValue = parameter.decodeValue(message, tcursor);
            if (!parameter.isConstantParameter() && resultValue != null) {
                result.add(resultValue);
            }
            ++index;
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterCursorService tcursor = cursor != null ? cursor : new ParameterCursor();
        MessageService resultMessage = message;
        if (value instanceof List) {
            int length;
            List values = (List)value;
            int listLength = values.size();
            if (listLength < (length = this.parameters.length)) {
                length = listLength;
            }
            int index = 0;
            while (index < length) {
                resultMessage = this.parameters[index].encodeValue(resultMessage, values.get(index), tcursor);
                ++index;
            }
        }
        return resultMessage;
    }
}

