/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.data.FixedInteger;
import org.eclipse.soda.dk.data.parameter.service.DataParameterService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class Parameter
extends EscObject
implements ParameterService,
DataParameterService {
    public static final int[] MASKS = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    public static final int[] SET_MASKS;
    public static final int[] SET_TOP_MASKS;
    private int information;
    private String key;
    private TransformService transform;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        SET_MASKS = nArray;
        SET_TOP_MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    }

    public static byte[] getBytes(byte[] bytes, int offset, int length) {
        int resultsLength = length + 7 >> 3;
        byte[] results = new byte[resultsLength];
        if (offset % 8 == 0 && length % 8 == 0) {
            System.arraycopy(bytes, offset >> 3, results, 0, resultsLength);
        } else if (length <= 64) {
            long value = Parameter.getLong(bytes, offset, length);
            Parameter.setBits(results, 0, length, value);
        } else {
            int count = (length + 63) / 64;
            int toffset = offset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - (i << 6);
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = Parameter.getLong(bytes, toffset, tlength);
                Parameter.setBits(results, tnewOffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - (i << 6);
                ++i;
            }
        }
        return results;
    }

    public static short getDefaultStyle() {
        return 0;
    }

    public static long getLong(byte[] bytes, int offset, int length) {
        long result = 0L;
        int currentOffset = offset;
        int currentLength = length;
        int index = offset >> 3;
        while (currentLength > 0) {
            int currentBit = currentOffset % 8;
            int shiftAmount = 8 - currentBit;
            int value = bytes[index++] & MASKS[currentBit];
            int shiftEnd = 8 - currentBit - currentLength;
            if (shiftEnd > 0) {
                shiftAmount -= shiftEnd;
                value >>= shiftEnd;
            }
            result = (result << shiftAmount) + (long)value;
            currentOffset += shiftAmount;
            currentLength -= shiftAmount;
        }
        return result;
    }

    public static void setBits(byte[] bytes, int offset, int length, long value) {
        long currentValue = value;
        int currentOffset = offset + length - 1;
        int currentLength = length;
        int index = currentOffset >> 3;
        while (currentLength > 0) {
            int currentBit = currentOffset % 8;
            int shiftAmount = currentBit + 1;
            int tvalue = bytes[index];
            int mask = SET_MASKS[7 - currentBit];
            int startBit = currentBit - currentLength;
            if (startBit >= 0) {
                mask |= SET_TOP_MASKS[startBit];
            }
            tvalue &= mask;
            int newValue = (int)(currentValue & (long)MASKS[7 - currentBit]);
            int extraShift = 8 - shiftAmount;
            if (extraShift > 0) {
                newValue <<= extraShift;
            }
            currentValue >>>= shiftAmount;
            bytes[index--] = (byte)(tvalue | newValue);
            currentOffset -= shiftAmount;
            currentLength -= shiftAmount;
        }
    }

    public static void setBytes(byte[] bytes, int offset, int length, byte[] data) {
        if (offset % 8 == 0 && length % 8 == 0) {
            System.arraycopy(data, 0, bytes, offset >> 3, length >> 3);
        } else if (length <= 64) {
            long value = Parameter.getLong(data, 0, length);
            Parameter.setBits(bytes, offset, length, value);
        } else {
            int count = (length + 63) / 64;
            int toffset = offset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - (i << 6);
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = Parameter.getLong(data, toffset - offset, tlength);
                Parameter.setBits(bytes, toffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - (i << 6);
                ++i;
            }
        }
    }

    public Parameter(String key) {
        this(key, null, Parameter.getDefaultStyle());
    }

    public Parameter(String key, short style) {
        this(key, null, style);
    }

    public Parameter(String key, TransformService transform) {
        this(key, transform, Parameter.getDefaultStyle());
    }

    public Parameter(String key, TransformService transform, short style) {
        this.setKey(key);
        this.setTransform(transform);
        this.setStyle(style);
    }

    public Object decode(Object container) {
        if (container instanceof MessageService) {
            return this.decodeValue((MessageService)container);
        }
        Object returnValue = container;
        if (container instanceof byte[]) {
            returnValue = this.decodeBytes((byte[])container, new ParameterCursor());
        } else if (container instanceof String) {
            returnValue = this.decodeString((String)container, new ParameterCursor());
        }
        return this.decodeEnd(returnValue);
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        return container;
    }

    public Object decodeEnd(Object object) {
        Object returnValue = object;
        switch (this.getTypeStyle()) {
            case 48: {
                if (!(returnValue instanceof Number)) break;
                if (((Number)returnValue).intValue() != 0) {
                    returnValue = Boolean.TRUE;
                    break;
                }
                returnValue = Boolean.FALSE;
                break;
            }
            case 64: 
            case 112: 
            case 144: {
                break;
            }
            case 96: 
            case 128: {
                if (!(returnValue instanceof String)) break;
                String string = (String)returnValue;
                if (string.length() == 0) {
                    returnValue = null;
                    break;
                }
                if (string.indexOf(46, 0) == -1) {
                    if (string.startsWith("0x")) {
                        returnValue = Parameter.createNumber(Long.parseLong(string.substring(2), 16));
                        break;
                    }
                    returnValue = Parameter.createNumber(Long.parseLong(string));
                    break;
                }
                returnValue = new FixedInteger(string);
                break;
            }
            case 192: 
            case 208: {
                if (!(returnValue instanceof String)) break;
                String string = (String)returnValue;
                returnValue = Parameter.createNumber(Long.parseLong(string, 16));
                break;
            }
            case 16: {
                break;
            }
            case 160: {
                if (returnValue instanceof Float || !(returnValue instanceof Number)) break;
                int intValue = ((Number)returnValue).intValue();
                returnValue = new Float(Float.intBitsToFloat(intValue));
                break;
            }
            case 176: {
                if (returnValue instanceof Double || !(returnValue instanceof Number)) break;
                long longValue = ((Number)returnValue).longValue();
                returnValue = new Double(Double.longBitsToDouble(longValue));
            }
        }
        TransformService transform = this.getTransform();
        if (transform != null) {
            returnValue = transform.decode(returnValue);
        }
        return returnValue;
    }

    protected Object decodeMessage(MessageService message, ParameterCursorService cursor) {
        return EscObject.createInteger(message.getByte(0));
    }

    public Object decodeString(String container, ParameterCursorService cursor) {
        return this.decodeBytes(container.getBytes(), cursor);
    }

    public Object decodeValue(MessageService message) {
        return this.decodeValue(message, new ParameterCursor());
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) throws NumberFormatException {
        Object returnValue = this.decodeMessage(message, cursor);
        this.updateCursor(cursor);
        return this.decodeEnd(returnValue);
    }

    public Object encode(Object container, Object data) {
        if (container instanceof MessageService) {
            return this.encodeValue((MessageService)container, data);
        }
        Object returnValue = container;
        if (container instanceof byte[]) {
            returnValue = this.encodeBytes((byte[])container, data, new ParameterCursor());
        } else if (container instanceof String) {
            returnValue = this.encodeString((String)container, data, new ParameterCursor());
        }
        return returnValue;
    }

    public Object encodeBegin(Object value) {
        Object encodeValue = value;
        TransformService transform = this.getTransform();
        if (transform != null) {
            encodeValue = transform.encode(encodeValue);
        }
        switch (this.getTypeStyle()) {
            case 48: {
                if (!(encodeValue instanceof Boolean)) break;
                encodeValue = (Boolean)encodeValue != false ? EscObject.INTEGER_TABLE[1] : EscObject.INTEGER_TABLE[0];
                break;
            }
            case 64: 
            case 96: 
            case 112: 
            case 128: {
                if (encodeValue instanceof byte[] || encodeValue instanceof String || encodeValue == null) break;
                StringBuffer buffer = new StringBuffer(64);
                Nls.formatData(buffer, encodeValue);
                encodeValue = buffer.toString();
                break;
            }
            case 144: {
                if (encodeValue instanceof String || encodeValue == null) break;
                encodeValue = String.valueOf(String.valueOf(encodeValue)) + '\u0000';
                break;
            }
            case 192: 
            case 208: {
                if (!(encodeValue instanceof Number)) break;
                encodeValue = Long.toHexString(((Number)encodeValue).longValue());
                break;
            }
            case 16: {
                break;
            }
            case 80: {
                if (!(encodeValue instanceof Byte[])) break;
                Byte[] encodeValueBytes = (Byte[])encodeValue;
                int length = encodeValueBytes.length;
                byte[] newEncodeValue = new byte[length];
                int i = 0;
                while (i < length) {
                    newEncodeValue[i] = encodeValueBytes[i];
                    ++i;
                }
                encodeValue = newEncodeValue;
            }
        }
        return encodeValue;
    }

    public Object encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        return container;
    }

    public MessageService encodeMessage(MessageService message, Object value, int offset, ParameterCursorService cursor) {
        if (value instanceof Number) {
            message.setByte(0, ((Number)value).byteValue());
        }
        return message;
    }

    public Object encodeString(String container, Object data, ParameterCursorService cursor) {
        return this.encodeBytes(container.getBytes(), data, cursor);
    }

    public MessageService encodeValue(MessageService message, Object value) {
        return this.encodeValue(message, value, new ParameterCursor());
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        Object encodeValue = this.encodeBegin(value);
        MessageService result = this.encodeMessage(message, encodeValue, 0, cursor);
        this.updateCursor(cursor);
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Parameter) {
            return this.getKey().equals(((Parameter)object).getKey());
        }
        return super.equals(object);
    }

    public String getKey() {
        return this.key;
    }

    public short getStyle() {
        return (short)this.information;
    }

    public TransformService getTransform() {
        return this.transform;
    }

    public short getTypeStyle() {
        return (short)(this.getStyle() & 0xF0);
    }

    public boolean isArray() {
        return (this.getStyle() & 8) == 8;
    }

    public boolean isConstantParameter() {
        return false;
    }

    public boolean isInsert() {
        return (this.getStyle() & 4) == 4;
    }

    public boolean isLittleEndian() {
        return (this.getStyle() & 2) == 2;
    }

    public boolean isUnsigned() {
        return (this.getStyle() & 1) == 1;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setStyle(short style) {
        this.information = this.information & 0xFFFF0000 | style;
    }

    protected void setTransform(TransformService transform) {
        this.transform = transform;
    }

    protected void updateCursor(ParameterCursorService cursor) {
    }
}

