/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.segment;

import org.eclipse.soda.dk.filter.SimpleFilter;
import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.parameter.BaseKeyParameter;
import org.eclipse.soda.dk.parameter.service.LengthBlockService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.parameter.service.SegmentService;

public class SimpleSegment
extends BaseKeyParameter
implements SegmentService {
    public static final String SEGMENT_NAME = "Segment";
    private byte[] bytes;
    private FilterService filter;
    private ParameterService parameter;

    public SimpleSegment() {
        this(SEGMENT_NAME, null, null, null);
    }

    public SimpleSegment(byte[] bytes, FilterService filter, ParameterService parameter) {
        this(SEGMENT_NAME, bytes, filter, parameter);
    }

    public SimpleSegment(String key) {
        this(key, null, null, null);
    }

    public SimpleSegment(String key, byte[] bytes, FilterService filter, ParameterService parameter) {
        super(key);
        this.setBytes(bytes);
        if (filter == null) {
            if (bytes != null) {
                this.setFilter(new SimpleFilter(0, bytes.length));
            }
        } else {
            this.setFilter(filter);
        }
        this.setParameter(parameter);
    }

    public boolean checkMatches(MessageService message, ParameterCursorService cursor) {
        byte[] container = message.getBytes();
        if (this.bytes == null) {
            return true;
        }
        FilterService filter = this.getFilter();
        int offset = this.getOffsetAbsolute(cursor);
        if (filter == null) {
            throw new IllegalArgumentException("filter==null");
        }
        if (offset == 0) {
            return filter.matches(container, this.getBytes());
        }
        int length = this.getBytes().length << 3;
        try {
            byte[] messageBytes = SimpleSegment.getBytes(container, offset, length);
            boolean results = filter.matches(messageBytes, this.getBytes());
            return results;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        boolean matches = this.checkMatches(message, cursor);
        if (matches && this.parameter != null) {
            return this.parameter.decodeValue(message, cursor);
        }
        this.getDidNotMatch(message, null, cursor);
        return null;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterCursorService tcursor = this.createCursorChild(cursor);
        MessageService results = this.parameter.encodeValue(message, value, tcursor);
        LengthBlockService lengthService = tcursor.getLengthBlock();
        if (lengthService != null) {
            int end = tcursor.getOffsetAbsolute();
            int start = cursor.getOffsetAbsolute();
            tcursor.setLength(end - start);
            results = lengthService.encodeValue(results, value, tcursor);
        }
        cursor.setOffsetAbsolute(this.getOffsetAbsolute(tcursor));
        return results;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void getDidNotMatch(MessageService message, byte[] compareBytes, ParameterCursorService cursor) {
        StringBuffer buffer = new StringBuffer(1024);
        String key = this.getKey();
        if (key != null) {
            buffer.append("key=");
            buffer.append(key);
            buffer.append(',');
        }
        buffer.append("bytes=");
        buffer.append(Nls.formatData(this.getBytes()));
        if (compareBytes != null) {
            buffer.append("\n,compareBytes=");
            buffer.append(Nls.formatData(compareBytes));
        }
        int offset = this.getOffsetValue(cursor);
        buffer.append("\n,offset=");
        buffer.append(offset);
        if (offset % 8 == 0) {
            buffer.append(",index=");
            buffer.append(offset >> 3);
        }
        buffer.append(",length=");
        buffer.append(this.getLength(cursor));
        buffer.append(",filter=");
        buffer.append(Nls.formatData(this.getFilter()));
        buffer.append(",message=");
        buffer.append(Nls.formatData(message));
        throw new IllegalArgumentException(buffer.toString());
    }

    public FilterService getFilter() {
        return this.filter;
    }

    public ParameterService getParameter() {
        return this.parameter;
    }

    public boolean needsCursor() {
        return true;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setFilter(FilterService filter) {
        this.filter = filter;
    }

    public void setParameter(ParameterService parameter) {
        this.parameter = parameter;
    }
}

