/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.configuration.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.configuration.servlet.DeviceConfigurationServletContext;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class DeviceConfigurationServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = 1440058116897573040L;
    private int colorValue = 0xFFFFFF;
    private ConfigurationAdmin configurationAdmin = null;
    private MetaTypeService metaTypeService = null;

    public static Object CheckType(Object ConvertedValue, int card, int type) throws NumberFormatException {
        if (card < 0) {
            int poscard = -card;
            if (type == 1) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                return new Vector<String>(Arrays.asList(ss));
            }
            if (type == 3) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Integer> intv = new Vector<Integer>(poscard);
                int i = 0;
                while (i < ss.length) {
                    intv.add(new Integer(ss[i]));
                    ++i;
                }
                return intv;
            }
            if (type == 6) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Byte> bytev = new Vector<Byte>(poscard);
                int i = 0;
                while (i < ss.length) {
                    bytev.add(new Byte((byte)Integer.parseInt(ss[i], 16)));
                    ++i;
                }
                return bytev;
            }
            if (type == 11) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Boolean> boolv = new Vector<Boolean>(poscard);
                int i = 0;
                while (i < ss.length) {
                    boolv.add(Boolean.valueOf(ss[i]));
                    ++i;
                }
                return boolv;
            }
            if (type == 5) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Character> charv = new Vector<Character>(poscard);
                int i = 0;
                while (i < ss.length) {
                    charv.add(new Character(ss[i].charAt(0)));
                    ++i;
                }
                return charv;
            }
            if (type == 7) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Double> doublev = new Vector<Double>(poscard);
                int i = 0;
                while (i < ss.length) {
                    doublev.add(new Double(ss[i]));
                    ++i;
                }
                return doublev;
            }
            if (type == 2) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Long> longv = new Vector<Long>(poscard);
                int i = 0;
                while (i < ss.length) {
                    longv.add(new Long(ss[i]));
                    ++i;
                }
                return longv;
            }
            if (type == 4) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Short> shortv = new Vector<Short>(poscard);
                int i = 0;
                while (i < ss.length) {
                    shortv.add(new Short(ss[i]));
                    ++i;
                }
                return shortv;
            }
            if (type == 8) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", poscard);
                Vector<Float> floatv = new Vector<Float>(poscard);
                int i = 0;
                while (i < ss.length) {
                    floatv.add(new Float(ss[i]));
                    ++i;
                }
                return floatv;
            }
        } else if (card == 0) {
            if (type == 1) {
                return ConvertedValue;
            }
            if (type == 3) {
                return new Integer(ConvertedValue.toString());
            }
            if (type == 6) {
                return new Byte((byte)Integer.parseInt(ConvertedValue.toString(), 16));
            }
            if (type == 11) {
                return Boolean.valueOf(ConvertedValue.toString());
            }
            if (type == 5) {
                return new Character(ConvertedValue.toString().charAt(0));
            }
            if (type == 7) {
                return new Double(ConvertedValue.toString());
            }
            if (type == 2) {
                return new Long(ConvertedValue.toString());
            }
            if (type == 4) {
                return new Short(ConvertedValue.toString());
            }
            if (type == 8) {
                return new Float(ConvertedValue.toString());
            }
        } else if (card > 0) {
            if (type == 6) {
                return DeviceConfigurationServlet.SplitStringtobyteArray(DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card), card);
            }
            if (type == 1) {
                return DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
            }
            if (type == 3) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                int[] intarr = new int[card];
                int i = 0;
                while (i < ss.length) {
                    intarr[i] = Integer.parseInt(ss[i]);
                    ++i;
                }
                return intarr;
            }
            if (type == 11) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                boolean[] boolarr = new boolean[card];
                int i = 0;
                while (i < ss.length) {
                    boolarr[i] = Boolean.valueOf(ss[i]);
                    ++i;
                }
                return boolarr;
            }
            if (type == 5) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                char[] chararr = new char[card];
                int i = 0;
                while (i < ss.length) {
                    chararr[i] = ss[i].charAt(0);
                    ++i;
                }
                return chararr;
            }
            if (type == 7) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                double[] doublearr = new double[card];
                int i = 0;
                while (i < ss.length) {
                    doublearr[i] = Double.parseDouble(ss[i]);
                    ++i;
                }
                return doublearr;
            }
            if (type == 2) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                long[] longarr = new long[card];
                int i = 0;
                while (i < ss.length) {
                    longarr[i] = Long.parseLong(ss[i]);
                    ++i;
                }
                return longarr;
            }
            if (type == 4) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                short[] shortarr = new short[card];
                int i = 0;
                while (i < ss.length) {
                    shortarr[i] = Short.parseShort(ss[i]);
                    ++i;
                }
                return shortarr;
            }
            if (type == 8) {
                String[] ss = DeviceConfigurationServlet.SplitString(ConvertedValue.toString(), ",", card);
                float[] floatarr = new float[card];
                int i = 0;
                while (i < ss.length) {
                    floatarr[i] = Float.parseFloat(ss[i]);
                    ++i;
                }
                return floatarr;
            }
        }
        return ConvertedValue;
    }

    public static String[] SplitString(String s, String delimiter, int length) throws NumberFormatException {
        String stemp = s;
        String[] SplitString = new String[length];
        if (stemp == null || stemp.equals("")) {
            SplitString = new String[]{};
        } else if (delimiter == null || delimiter.equals("")) {
            SplitString = new String[]{stemp};
        } else {
            ArrayList<String> c = new ArrayList<String>();
            int i = stemp.indexOf(delimiter);
            while (i > -1) {
                String temp = stemp.substring(0, i).trim();
                c.add(temp);
                stemp = stemp.substring(i + 1);
                i = stemp.indexOf(delimiter);
            }
            c.add(stemp.trim());
            SplitString = c.toArray(new String[0]);
        }
        return SplitString;
    }

    public static byte[] SplitStringtobyteArray(String[] SplitString, int length) throws NumberFormatException {
        byte[] b = new byte[length];
        int i = 0;
        while (i < SplitString.length) {
            int j = Integer.parseInt(SplitString[i], 16);
            if (j < 0 || j > 255) {
                throw new NumberFormatException("Value out of range. Value:\"" + SplitString[i] + "\" Radix:" + 16);
            }
            b[i] = (byte)j;
            ++i;
        }
        return b;
    }

    private Object ArraytoString(Object value, int type) {
        if (type == 6) {
            byte[] newValue = (byte[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                int ix = newValue[i] >> 4 & 0xF;
                multi.append("0123456789abcdef".charAt(ix));
                ix = newValue[i] & 0xF;
                multi.append("0123456789abcdef".charAt(ix));
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 1) {
            Object[] newValue = (String[])value;
            return this.ObjArrtoString(newValue);
        }
        if (type == 3) {
            int[] newValue = (int[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 11) {
            boolean[] newValue = (boolean[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 5) {
            char[] newValue = (char[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 7) {
            double[] newValue = (double[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 2) {
            long[] newValue = (long[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 4) {
            short[] newValue = (short[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 8) {
            float[] newValue = (float[])value;
            StringBuffer multi = new StringBuffer(newValue.length << 1);
            int i = 0;
            while (i < newValue.length) {
                multi.append(newValue[i]);
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        return value;
    }

    public boolean changeConfiguration(Hashtable table, Hashtable oldTable) {
        block13: {
            ConfigurationAdmin configurationAdmin = this.getConfigurationAdmin();
            if (configurationAdmin != null) {
                Object factoryPid = oldTable.get("service.factoryPid");
                Object pid = oldTable.get("service.pid");
                Object SubmitType = oldTable.get("submit_type");
                Object BundleLocation = oldTable.get("bundle.location");
                if (oldTable.get("NumOfConf") != null && oldTable.get("NumOfConf").toString().length() <= 0) {
                    oldTable.put("NumOfConf", "1");
                }
                Object NumofConf = oldTable.get("NumOfConf");
                boolean SaveNew = false;
                if (SubmitType != null && "New".equals(SubmitType.toString())) {
                    SaveNew = true;
                }
                if (pid != null && pid.toString().length() > 0 && !SaveNew) {
                    try {
                        Configuration configuration = null;
                        configuration = BundleLocation != null ? configurationAdmin.getConfiguration(pid.toString(), BundleLocation.toString()) : configurationAdmin.getConfiguration(pid.toString());
                        if (configuration == null) break block13;
                        if (SubmitType != null && "Delete".equals(SubmitType.toString())) {
                            configuration.delete();
                            break block13;
                        }
                        configuration.update((Dictionary)table);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (factoryPid != null) {
                    try {
                        table.remove("service.pid");
                        table.remove("service.factoryPid");
                        int k = 0;
                        while (k < Integer.parseInt(NumofConf.toString())) {
                            Configuration configuration = configurationAdmin.createFactoryConfiguration(factoryPid.toString(), null);
                            if (configuration != null) {
                                configuration.update((Dictionary)table);
                            }
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return true;
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceConfigurationServletContext context = new DeviceConfigurationServletContext(request, response, this.getServletAlias());
        context.saveMetaData(this.getBundles(), this.getMetaTypeService());
        return context;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeviceServletContext context = this.createContext(request, response);
        this.setup(context);
        context.begin();
        Hashtable<String, String> table = new Hashtable<String, String>();
        Hashtable<String, String> extraTable = new Hashtable<String, String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            String value = request.getParameter(key);
            if (key.startsWith("_")) {
                extraTable.put(key, value);
                continue;
            }
            table.put(key, value);
        }
        Hashtable newTable = this.validateConfiguration(context, table);
        if (newTable != null) {
            this.changeConfiguration(newTable, table);
            context.template("updatebegin");
            this.processRequest(context);
        }
        context.template("end");
    }

    public int getColorValue() {
        return this.colorValue;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public Hashtable getConfigurationAttributes(AttributeDefinition[] attributeDefinitions) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        int i = 0;
        while (i < attributeDefinitions.length) {
            AttributeDefinition attributeDefinition = attributeDefinitions[i];
            String id = attributeDefinition.getID();
            String value = "";
            String[] defaultValue = attributeDefinition.getDefaultValue();
            if (defaultValue != null && defaultValue.length > 0) {
                value = defaultValue[0];
            }
            table.put(id, value);
            ++i;
        }
        return table;
    }

    public MetaTypeService getMetaTypeService() {
        return this.metaTypeService;
    }

    private String ObjArrtoString(Object[] newValue) {
        StringBuffer multi = new StringBuffer(newValue.length * 2);
        int i = 0;
        while (i < newValue.length) {
            multi.append(newValue[i]);
            if (i < newValue.length - 1) {
                multi.append(", ");
            }
            ++i;
        }
        return multi.toString();
    }

    public void processConfigurationAdmin(DeviceConfigurationServletContext context, Map factoryMetadata) {
        try {
            Configuration[] configurations;
            this.resetColorValue();
            ConfigurationAdmin configurationAdmin = this.getConfigurationAdmin();
            if (configurationAdmin != null && (configurations = configurationAdmin.listConfigurations(null)) != null) {
                Dictionary properties;
                Configuration configuration;
                context.sort(configurations);
                String lastId = "";
                int i = 0;
                while (i < configurations.length) {
                    configuration = configurations[i];
                    properties = configuration.getProperties();
                    String id = (String)properties.get("ID");
                    if (id == null) break;
                    if (!id.equals(lastId)) {
                        context.addEntity("Id", context.formatData(id));
                        context.template("idref");
                        lastId = id;
                    }
                    ++i;
                }
                lastId = null;
                i = 0;
                while (i < configurations.length) {
                    configuration = configurations[i];
                    properties = configuration.getProperties();
                    String name = "";
                    String factoryPid = configuration.getFactoryPid();
                    String pid = configuration.getPid();
                    AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{};
                    if (factoryPid != null) {
                        name = factoryPid;
                        context.addEntity("FactoryPid", context.formatData(factoryPid));
                    } else {
                        context.addEntity("FactoryPid", "");
                        name = pid;
                    }
                    Object object = factoryMetadata.get(name);
                    if (object == null) {
                        object = context.getPidMetadata().get(name);
                    }
                    if (object instanceof ObjectClassDefinition) {
                        ArrayList<String> keyList = null;
                        if (properties != null) {
                            keyList = new ArrayList(properties.size());
                            Enumeration enumeration = properties.keys();
                            while (enumeration.hasMoreElements()) {
                                keyList.add(enumeration.nextElement().toString());
                            }
                        } else {
                            keyList = new ArrayList<String>();
                        }
                        String id = null;
                        if (properties != null) {
                            id = (String)properties.get("ID");
                        }
                        if (id == null) {
                            id = "";
                        }
                        context.addEntity("Id", context.formatData(id));
                        context.addEntity("Color", Integer.toHexString(this.getColorValue()));
                        if (lastId != null) {
                            if (!lastId.equals(id)) {
                                context.template("idend");
                                if (id.length() > 0) {
                                    this.updateColorValue();
                                    context.addEntity("Color", Integer.toHexString(this.getColorValue()));
                                    context.template("idbegin");
                                }
                            }
                        } else if (id.length() > 0) {
                            context.template("idbegin");
                        }
                        lastId = id;
                        context.addEntity("Id", context.formatData(id));
                        context.addEntity("Name", name);
                        context.addEntity("Pid", context.formatData(pid));
                        ObjectClassDefinition objectClassDefinition = (ObjectClassDefinition)object;
                        String objectName = objectClassDefinition.getName();
                        context.addEntity("ObjectName", context.formatData(objectName));
                        String objectDescription = objectClassDefinition.getDescription();
                        context.addEntity("ObjectDescription", context.formatData(objectDescription));
                        context.template("configurationbegin");
                        attributeDefinitions = objectClassDefinition.getAttributeDefinitions(1);
                        int k = 0;
                        while (k < attributeDefinitions.length) {
                            keyList.remove(attributeDefinitions[k].getID());
                            ++k;
                        }
                        this.processConfigurationAttributes(context, properties, attributeDefinitions, true);
                        attributeDefinitions = objectClassDefinition.getAttributeDefinitions(2);
                        k = 0;
                        while (k < attributeDefinitions.length) {
                            keyList.remove(attributeDefinitions[k].getID());
                            ++k;
                        }
                        this.processConfigurationAttributes(context, properties, attributeDefinitions, false);
                        k = 0;
                        while (k < keyList.size()) {
                            Object key = keyList.get(k);
                            String value = properties != null ? properties.get(key) : "";
                            context.addEntity("Key", context.formatData(key));
                            context.addEntity("Value", context.formatData(value));
                            context.template("configurationignoreentry");
                            ++k;
                        }
                        context.template("configurationend");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AttributeDefinition processConfigurationAttributes(DeviceServletContext context, Dictionary properties, AttributeDefinition[] attributeDefinitions, boolean required) {
        AttributeDefinition specialAttributeDefinition = null;
        int i = 0;
        while (i < attributeDefinitions.length) {
            AttributeDefinition attributeDefinition = attributeDefinitions[i];
            String id = attributeDefinition.getID();
            Object value = "";
            if (properties != null) {
                value = properties.get(id);
                if (value == null) {
                    value = "";
                } else if (attributeDefinition.getCardinality() > 0) {
                    value = this.ArraytoString(value, attributeDefinition.getType());
                } else if (attributeDefinition.getCardinality() < 0) {
                    value = this.VectortoString((List)value, attributeDefinition.getType());
                } else if (attributeDefinition.getType() == 6) {
                    byte newValue = (byte)Integer.parseInt(value.toString());
                    StringBuffer multi = new StringBuffer(2);
                    int ix = newValue >> 4 & 0xF;
                    multi.append("0123456789abcdef".charAt(ix));
                    ix = newValue & 0xF;
                    multi.append("0123456789abcdef".charAt(ix));
                    value = multi.toString();
                }
            } else {
                String[] defaultValue = attributeDefinition.getDefaultValue();
                if (defaultValue != null && defaultValue.length > 0) {
                    value = defaultValue[0];
                }
            }
            if ("connection".equals(id) && "factory".equals(value)) {
                specialAttributeDefinition = attributeDefinition;
            }
            String name = context.formatData((Object)attributeDefinition.getName());
            context.addEntity("Name", (Object)name);
            context.addEntity("Required", (Object)String.valueOf(required));
            String Type = String.valueOf(attributeDefinition.getType());
            String Card = String.valueOf(attributeDefinition.getCardinality());
            context.addEntity("Type", (Object)Type);
            context.addEntity("Card", (Object)Card);
            if (required) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("<b>");
                buffer.append(name);
                buffer.append("</b>");
                context.addEntity("Label", (Object)buffer.toString());
            } else {
                context.addEntity("Label", (Object)name);
            }
            context.addEntity("Description", (Object)attributeDefinition.getDescription());
            context.addEntity("Key", (Object)context.formatData((Object)id));
            context.addEntity("Value", (Object)context.formatData(value));
            String[] labels = attributeDefinition.getOptionLabels();
            String[] values = attributeDefinition.getOptionValues();
            if (labels != null && values != null) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("<select name=\"");
                buffer.append(context.formatData((Object)id));
                buffer.append("\" title=\"");
                buffer.append(attributeDefinition.getDescription());
                buffer.append("\">");
                int k = 0;
                while (k < values.length) {
                    String label = labels[k];
                    String svalue = values[k];
                    if (svalue.equals(value.toString())) {
                        buffer.append("<option selected value=\"");
                    } else {
                        buffer.append("<option value=\"");
                    }
                    buffer.append(svalue);
                    buffer.append("\">");
                    buffer.append(label);
                    buffer.append("</option>");
                    ++k;
                }
                buffer.append("</select>");
                context.addEntity("ValueField", (Object)buffer.toString());
                context.template("configurationentry2");
            } else {
                context.template("configurationentry");
            }
            ++i;
        }
        return specialAttributeDefinition;
    }

    public void processRequest(DeviceServletContext context) {
        this.processConfigurationAdmin((DeviceConfigurationServletContext)context, context.getFactoryMetadata());
    }

    public void resetColorValue() {
        this.colorValue = 0xFFFFFF;
    }

    public void setColorValue(int colorValue) {
        this.colorValue = colorValue;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setMetaTypeService(MetaTypeService metaTypeService) {
        this.metaTypeService = metaTypeService;
    }

    public void updateColorValue() {
        this.colorValue -= 526344;
        if (this.colorValue == 0x808080) {
            this.colorValue = 0xFFFFFF;
        }
    }

    public Hashtable validateConfiguration(DeviceServletContext context, Hashtable table) {
        Hashtable result = new Hashtable();
        boolean status = true;
        Object factoryPid = table.get("service.factoryPid");
        Object pid = table.get("service.pid");
        Object object = null;
        String id = String.valueOf(pid);
        if (factoryPid != null) {
            id = String.valueOf(factoryPid);
            object = context.getFactoryMetadata().get(id);
        } else {
            object = context.getPidMetadata().get(id);
        }
        if (object instanceof ObjectClassDefinition) {
            ObjectClassDefinition objectClassDefinition = object;
            AttributeDefinition[] attributeDefinitions = objectClassDefinition.getAttributeDefinitions(-1);
            int i = 0;
            while (i < attributeDefinitions.length) {
                AttributeDefinition attributeDefinition = attributeDefinitions[i];
                String aid = attributeDefinition.getID();
                Object value = table.get(aid);
                if (value != null) {
                    String message = attributeDefinition.validate(value.toString());
                    if (message != null && message.length() > 0) {
                        if (status) {
                            context.template("errorbegin");
                        }
                        context.addEntity("Name", (Object)context.formatData((Object)attributeDefinition.getName()));
                        context.addEntity("Value", (Object)context.formatData(value));
                        context.addEntity("Message", (Object)message);
                        context.template("errorentry");
                        status = false;
                    } else {
                        int card = attributeDefinition.getCardinality();
                        int type = attributeDefinition.getType();
                        value = DeviceConfigurationServlet.CheckType(value, card, type);
                        result.put(aid, value);
                    }
                }
                ++i;
            }
        }
        if (status) {
            return result;
        }
        context.template("errorend");
        return null;
    }

    private Object VectortoString(List value, int type) {
        if (type == 6) {
            byte[] newValue = new byte[value.size()];
            StringBuffer multi = new StringBuffer(newValue.length * 2);
            int i = 0;
            while (i < newValue.length) {
                newValue[i] = (byte)Integer.parseInt(value.get(i).toString());
                int ix = newValue[i] >> 4 & 0xF;
                multi.append("0123456789abcdef".charAt(ix));
                ix = newValue[i] & 0xF;
                multi.append("0123456789abcdef".charAt(ix));
                if (i < newValue.length - 1) {
                    multi.append(", ");
                }
                ++i;
            }
            return multi.toString();
        }
        if (type == 1) {
            Object[] newValue = new String[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 3) {
            Object[] newValue = new Integer[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 11) {
            Object[] newValue = new Boolean[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 5) {
            Object[] newValue = new Character[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 7) {
            Object[] newValue = new Double[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 2) {
            Object[] newValue = new Long[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 4) {
            Object[] newValue = new Short[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        if (type == 8) {
            Object[] newValue = new Float[value.size()];
            newValue = value.toArray(newValue);
            return this.ObjArrtoString(newValue);
        }
        return value;
    }
}

