/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.util.Dictionary;

public class NotificationQueue {
    protected Object[] elementsData;
    protected Object[] elementsTopic;
    int length;
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    public NotificationQueue() {
        this(8);
    }

    public NotificationQueue(int size) {
        this.elementsTopic = new Object[size];
        this.elementsData = new Object[size];
        this.length = size;
    }

    public void broadcast(String topic, Dictionary data) {
        this.enqueue(topic, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        NotificationQueue notificationQueue = this;
        synchronized (notificationQueue) {
            this.elementsData = new Object[this.length][2];
            this.head = 0;
            this.tail = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(long time, Object[] object) {
        NotificationQueue notificationQueue = this;
        synchronized (notificationQueue) {
            if (this.size == 0) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    object[0] = null;
                    object[1] = null;
                    return;
                }
            }
            if (this.size > 0) {
                object[0] = this.elementsTopic[this.head];
                object[1] = this.elementsData[this.head];
                this.elementsTopic[this.head] = null;
                this.elementsData[this.head] = null;
                ++this.head;
                if (this.head >= this.length) {
                    this.head -= this.length;
                }
                --this.size;
                return;
            }
        }
        object[0] = null;
        object[1] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(String topic, Object data) {
        try {
            NotificationQueue notificationQueue = this;
            synchronized (notificationQueue) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1;
                    this.elementsTopic[this.head] = topic;
                    this.elementsData[this.head] = data;
                } else {
                    int high;
                    if (this.size >= this.length) {
                        this.handleFull();
                    }
                    if ((high = this.tail - 1) < 0) {
                        high = this.length + high;
                    }
                    this.elementsTopic[this.tail] = topic;
                    this.elementsData[this.tail] = data;
                    ++this.tail;
                    if (this.tail >= this.length) {
                        this.tail -= this.length;
                    }
                }
                ++this.size;
                this.notifyAll();
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
            System.out.println(this.toString());
            System.exit(0);
        }
    }

    public int getMaxSize() {
        return this.length;
    }

    public synchronized void handleFull() {
        Object[] newElementsTopic = new Object[this.size << 1];
        Object[] newElementsData = new Object[this.size << 1];
        if (this.head == 0) {
            System.arraycopy(this.elementsTopic, 0, newElementsTopic, 0, this.size);
            System.arraycopy(this.elementsData, 0, newElementsData, 0, this.size);
        } else {
            int delta = this.size - this.head;
            System.arraycopy(this.elementsTopic, this.head, newElementsTopic, 0, delta);
            System.arraycopy(this.elementsTopic, 0, newElementsTopic, delta, this.size - delta);
            System.arraycopy(this.elementsData, this.head, newElementsData, 0, delta);
            System.arraycopy(this.elementsData, 0, newElementsData, delta, this.size - delta);
            this.head = 0;
        }
        this.tail = this.size;
        this.elementsTopic = newElementsTopic;
        this.elementsData = newElementsData;
        this.length = this.elementsData.length;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('{');
        boolean first = true;
        int count = 0;
        while (count < this.size) {
            Object topic;
            int i = this.head + count;
            if (i >= this.length) {
                i -= this.length;
            }
            if ((topic = this.elementsTopic[i]) != null) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                buffer.append(topic);
                buffer.append('=');
                Object data = this.elementsData[i];
                buffer.append(data);
            } else {
                buffer.append(", NULL");
            }
            ++count;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

