/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display;

import java.util.List;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.AbstractDisplayElement;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.IDisplayElement;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.LLRPConfigStore;

public class ReaderDisplay
extends AbstractDisplayElement {
    private String currentProfile;

    public ReaderDisplay(String name, Object paramObj, String currentProfile) {
        super(name, paramObj, 1);
        this.currentProfile = currentProfile;
    }

    public String getCurrentProfile() {
        return this.currentProfile;
    }

    public String getHtml(String servletPath) {
        StringBuffer result = new StringBuffer();
        result.append(ReaderDisplay.getJavaScriptFunction());
        result.append("<table border=\"0\">\n");
        result.append("<tr><td colspen=\"2\" align=\"center\">\n");
        result.append(this.getReaderFormHtml(servletPath));
        result.append("</td></tr>\n");
        List profileNames = this.getLLRPConfigStore().getReaderProfileNamesList(this.getName());
        if (profileNames.size() > 0) {
            result.append("<tr><td valign=\"top\">\n");
            result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
            int i = 0;
            while (i < profileNames.size()) {
                String profileName = (String)profileNames.get(i);
                result.append("<tr>\n");
                if (profileName.equals(this.getCurrentProfile())) {
                    result.append("<td align=\"right\">");
                    result.append("<h5>" + profileName + "</h5>");
                    result.append("</td>\n");
                    result.append("<td valign=\"top\"><h5>&nbsp;>>></h5></td>\n");
                } else {
                    result.append("<td align=\"right\">");
                    result.append("<h5><a href=\"" + servletPath + '?' + "ReaderAction" + '=' + 12);
                    result.append("&Profile=" + profileName + "\">" + profileName + "</h5>");
                    result.append("</td>\n");
                    result.append("<td>&nbsp;</td>\n");
                }
                result.append("</tr>\n");
                ++i;
            }
            result.append("</table>\n");
            result.append("</td>\n");
            result.append("<td>\n");
            result.append("<table frame=\"border\"><tr><td>");
            if (this.getParamentContent() != null) {
                result.append(this.getParamentContent().getHtml(servletPath));
            } else {
                result.append("<td>&nbsp;</td>");
            }
            result.append("</td></tr></table>\n");
            result.append("</td></tr>\n");
        } else {
            result.append("<tr><td>No LLRP profiles available on this reader.</td></tr>\n");
        }
        result.append("</table>\n");
        return result.toString();
    }

    private LLRPConfigStore getLLRPConfigStore() {
        return (LLRPConfigStore)this.getParamObj();
    }

    public IDisplayElement getParamentContent() {
        return this.getLLRPConfigStore().getCurrentDisplayElement();
    }

    private String getReaderFormHtml(String servletPath) {
        StringBuffer result = new StringBuffer();
        result.append("<form method=post id=\"" + this.getName() + "\" action=" + servletPath + ">\n");
        result.append("<table border=\"0\"><tr>\n");
        result.append("<td align=\"right\">Reader:</td>\n");
        result.append("<td align=\"left\">");
        result.append("<table border=\"0\"><tr>\n");
        result.append("<td align=\"left\">");
        List readerPrefixs = this.getLLRPConfigStore().getReaderPrefixs();
        result.append("<select name=\"ReaderId\" ");
        result.append("onchange=\"location.href='" + servletPath + '?' + "ReaderAction" + '=' + 10);
        result.append("&ReaderId=' + this.value\"");
        result.append(">\n");
        int i = 0;
        while (i < readerPrefixs.size()) {
            String readerPrefix = (String)readerPrefixs.get(i);
            result.append("<option value=\"" + readerPrefix + "\" ");
            result.append(readerPrefix.equals(this.getName()) ? "selected=\"selected\">" : ">");
            result.append(String.valueOf(this.getLLRPConfigStore().getReaderId(readerPrefix)) + "</option>\n");
            ++i;
        }
        result.append("</select>\n");
        result.append("</td>\n");
        result.append("<input type=\"hidden\" name=\"ReaderAction\" id=\"ReaderAction\" value=\"\"/>\n");
        result.append("</tr></table>\n");
        result.append("</td>\n");
        result.append("</tr></table>\n");
        result.append("</form>\n");
        return result.toString();
    }

    public void setCurrentProfile(String currentProfile) {
        this.currentProfile = currentProfile;
    }
}

