/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gps.nmea.position.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.gps.nmea.position.profile.service.GpsNmeaPositionProfileService;
import org.eclipse.soda.dk.position.profile.PositionProfile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class GpsNmeaPositionProfile
extends PositionProfile
implements ProfileService,
GpsNmeaPositionProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gps.nmea.position.profile.GpsNmeaPositionProfile";
    protected SignalService gpsNmeaDeviceServiceGPGLL;
    protected SignalService gpsNmeaDeviceServiceGPGGA;
    private AdapterService adapter;

    public GpsNmeaPositionProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.gpsNmeaDeviceServiceGPGLL != null) {
                this.gpsNmeaDeviceServiceGPGLL.removeSignalListener((SignalListener)this);
            }
            if (this.gpsNmeaDeviceServiceGPGGA != null) {
                this.gpsNmeaDeviceServiceGPGGA.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.gpsNmeaDeviceServiceGPGLL = device.getSignal("GPGLL");
            this.initializeSignal(this.gpsNmeaDeviceServiceGPGLL);
            this.gpsNmeaDeviceServiceGPGGA = device.getSignal("GPGGA");
            this.initializeSignal(this.gpsNmeaDeviceServiceGPGGA);
        }
        super.setDevice(device);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.gpsNmeaDeviceServiceGPGLL == source) {
            this.handleGpsNmeaDeviceServiceGPGLL(source, timestamp, data);
            return;
        }
        if (this.gpsNmeaDeviceServiceGPGGA == source) {
            this.handleGpsNmeaDeviceServiceGPGGA(source, timestamp, data);
            return;
        }
        super.signalOccurred(source, timestamp, data);
    }

    public String getDefaultKey() {
        return "GpsNmeaPositionProfile";
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)GpsNmeaPositionProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.gps.nmea.device.GpsNmeaDevice");
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    private void initialize() {
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    protected void handleGpsNmeaDeviceServiceGPGGA(SignalService source, Object timestamp, Object data) {
        this.handleSignal(timestamp, data);
    }

    protected void handleGpsNmeaDeviceServiceGPGLL(SignalService source, Object timestamp, Object data) {
        this.handleSignal(timestamp, data);
    }

    public void handleSignal(Object timestamp, Object data) {
        if (data instanceof Map) {
            Object altitude;
            Object longitude;
            Map map = (Map)data;
            Hashtable coordinateMap = new Hashtable();
            Object latitude = map.get("Latitude");
            if (latitude != null) {
                coordinateMap.put("latitude", latitude);
            }
            if ((longitude = map.get("Longitude")) != null) {
                coordinateMap.put("longitude", longitude);
            }
            if ((altitude = map.get("Altitude")) != null) {
                coordinateMap.put("altitude", altitude);
            }
            this.coordinate.setValue(coordinateMap, timestamp);
        }
    }
}

