/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gps.nmea.transport;

import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaMessage;
import org.eclipse.soda.dk.gps.nmea.transport.service.GpsNmeaTransportService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.serial.connection.SerialConnection;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class GpsNmeaTransport
extends ConnectionTransport
implements TransportService,
GpsNmeaTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaTransport";
    private static final byte[] ASTRAL = "ASTRAL\r\n".getBytes();
    public static final byte[] HEX_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public int processInput(byte[] bytes, int length) throws Exception {
        int index = 0;
        Object timestamp = null;
        try {
            int i = 0;
            while (i < length) {
                if (bytes[i] == 10) {
                    if (timestamp == null) {
                        timestamp = GpsNmeaTransport.getCurrentTimestamp();
                    }
                    byte[] mbytes = new byte[i + 1 - index];
                    System.arraycopy(bytes, index, mbytes, 0, i + 1 - index);
                    GpsNmeaMessage message = new GpsNmeaMessage(mbytes);
                    if (message.isValid()) {
                        this.fireMessageReceived(timestamp, (MessageService)message);
                    } else if (this.isRunning()) {
                        boolean astralMessage = false;
                        if (message.length() == ASTRAL.length) {
                            astralMessage = true;
                            int j = 0;
                            while (j < ASTRAL.length) {
                                if (mbytes[j] != ASTRAL[j]) {
                                    astralMessage = false;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (astralMessage) {
                            try {
                                this.write(ASTRAL);
                            }
                            catch (Exception exception) {
                                this.handleError(exception, 2012, new Message(ASTRAL), this.getHistory());
                            }
                        } else {
                            this.handleError(null, 2006, (Object)message, this.getHistory());
                            this.setReceivingData(false);
                        }
                    }
                    index = i + 1;
                }
                ++i;
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 2015, this.getHistory());
        }
        return index;
    }

    protected void write(MessageService message) throws Exception {
        byte[] obytes = message.getBytes();
        int length = obytes.length;
        byte[] mbytes = new byte[length + 5];
        int index = 0;
        int checksum = 36;
        index = 0;
        while (index < length) {
            mbytes[index] = obytes[index];
            checksum ^= mbytes[index];
            ++index;
        }
        mbytes[index++] = 42;
        mbytes[index++] = HEX_TABLE[(checksum &= 0xFF) >> 4];
        mbytes[index++] = HEX_TABLE[checksum & 0xF];
        mbytes[index++] = 13;
        mbytes[index++] = 10;
        this.write(mbytes);
    }

    public ConnectionService getDefaultConnection() {
        String type = this.getString("gpsnmeatransport.connection", "serial");
        if (type.equals("tcpip")) {
            return this.getDefaultTcpipConnection();
        }
        return this.getDefaultSerialConnection();
    }

    public SerialConnectionService getDefaultSerialConnection() {
        return new SerialConnection(this.getInt("gpsnmeatransport.comport", 1), this.getInt("gpsnmeatransport.baudrate", 4800), this.getInt("gpsnmeatransport.databits", 8), this.getInt("gpsnmeatransport.parity", 0), this.getInt("gpsnmeatransport.stopbits", 0), this.getInt("gpsnmeatransport.hardwareflowcontrol", 0), this.getInt("gpsnmeatransport.softwareflowcontrol", 0), this.getInt("gpsnmeatransport.readtotaltimeout", 1000), this.getInt("gpsnmeatransport.readintervaltimeout", 50), this.getInt("gpsnmeatransport.writetotaltimeout", 100));
    }

    public TcpipConnectionService getDefaultTcpipConnection() {
        return new TcpipConnection(this.getString("gpsnmeatransport.host", "localhost"), this.getInt("gpsnmeatransport.remoteport", 8901), this.getInt("gpsnmeatransport.localport", -1), this.getInt("gpsnmeatransport.readtimeout", 1000), this.getInt("gpsnmeatransport.readsize", -1), this.getInt("gpsnmeatransport.writesize", -1), this.getInt("gpsnmeatransport.linger", -1));
    }

    public void setup() {
        super.setup();
        this.setRetryTime(this.getLong("gpsnmeatransport.retrytime", this.getRetryTime()));
        this.setTransmitRetries(this.getInt("gpsnmeatransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("gpsnmeatransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

