/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.test;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;

public class NotificationTest
extends EscObject
implements NotificationListener {
    private NotificationService notificationService;

    public static void main(String[] args) {
        NotificationTest test = new NotificationTest();
        test.exit();
        System.exit(0);
    }

    public void exit() {
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void notificationReceived(String topic, Dictionary data) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("Notification: ");
        buffer.append(topic);
        buffer.append(" data: ");
        Nls.formatData((StringBuffer)buffer, (Object)data, (int)0, (int)100, (int)10);
        this.log(4, buffer.toString());
    }

    public void setNotificationService(NotificationService notificationService) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        if (this.notificationService != null) {
            data.put("status", "stop");
            this.notificationService.broadcast("NotificationTest", data);
            this.notificationService.unregister((NotificationListener)this);
        }
        this.notificationService = notificationService;
        if (this.notificationService != null) {
            this.notificationService.register("*", (NotificationListener)this);
            data.put("status", "start");
            int i = 0;
            while (i < 1) {
                long start = System.currentTimeMillis();
                this.notificationService.broadcast("NotificationTest", data);
                long end = System.currentTimeMillis();
                long delta = end - start;
                if (delta > 0L) {
                    System.out.println("publish/time " + delta);
                }
                ++i;
            }
        }
    }
}

