/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile;

import java.util.ResourceBundle;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.ProfileListeners;
import org.eclipse.soda.dk.profile.ProfileResourceBundle;
import org.eclipse.soda.dk.profile.service.ProfileListener;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Profile
extends Device
implements ProfileService,
CommandListener,
SignalListener,
MeasurementListener,
DeviceListener {
    private static ResourceBundle DefaultResourceBundle;
    protected DeviceService device;
    protected ProfileListener profileListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.profile.ProfileResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public Profile() {
        super("Profile/Capabilities", "Profile/Status", "Profile/Configuration", "Profile/Metrics");
    }

    protected Profile(String capabilities, String status, String configuration) {
        super(capabilities, status, configuration, "Profile/Metrics");
    }

    protected Profile(String capabilities, String status, String configuration, String metrics) {
        super(capabilities, status, configuration, metrics);
    }

    public void addProfileListener(ProfileListener profileListener) {
        if (profileListener != null) {
            int state = this.getState();
            profileListener.profileChanged((ProfileService)this, Profile.getCurrentTimestamp(), state, state);
        }
        this.setProfileListener(ProfileListeners.add(this.getProfileListener(), profileListener));
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
    }

    public void controlAdded(EscObject container, Object currentTimestamp, ControlService control) {
        ProfileListener profileListener = this.getProfileListener();
        if (profileListener != null) {
            profileListener.controlChanged((ProfileService)this, Profile.getCurrentTimestamp(), control, 1);
        }
    }

    public void controlChanged(DeviceService device, Object timestamp, ControlService control, int code) {
    }

    public void controlRemoved(EscObject container, Object timestamp, ControlService control) {
        ProfileListener profileListener = this.getProfileListener();
        if (profileListener != null) {
            profileListener.controlChanged((ProfileService)this, Profile.getCurrentTimestamp(), control, 0);
        }
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        int mystate = this.getState();
        if (mystate != newState) {
            if (mystate > 1) {
                if (newState == 5) {
                    this.restart();
                } else if (newState > 1) {
                    super.setState(newState);
                } else {
                    super.setState(2);
                }
            }
            this.deviceChangedCustom(source, timestamp, newState, oldState);
        }
    }

    public void deviceChangedCustom(DeviceService source, Object timestamp, int newState, int oldState) {
    }

    public void exit() {
        this.removeListeners(this.getDevice());
        this.setDevice(null);
        super.exit();
    }

    public void fireContainerChanged(Object timestamp, int newState, int oldState) {
        try {
            ProfileListener profileListener = this.getProfileListener();
            if (profileListener != null) {
                profileListener.profileChanged((ProfileService)this, timestamp, newState, oldState);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 3006, this.profileListener);
        }
        this.broadcastStatus(timestamp, newState, oldState);
    }

    public AdapterService getAdapter() {
        return null;
    }

    public Long getAnalogValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return Profile.createLong((long)((Number)value).longValue());
        }
        if (value != null) {
            String valueString = value.toString();
            return new Long(valueString);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public Boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value != null) {
            String valueString = value.toString();
            if (valueString.equals("1") || valueString.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (valueString.equals("0") || valueString.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "Profile";
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public Object getLogDetails6() {
        return String.valueOf(this.getDevice());
    }

    public Long getLongValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return Profile.createLong((long)((Number)value).longValue());
        }
        if (value != null) {
            String valueString = value.toString();
            return Long.valueOf(valueString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public ProfileListener getProfileListener() {
        return this.profileListener;
    }

    public String getResource(int resourceId) {
        try {
            if (resourceId >= 3000 && resourceId < 4000) {
                return DefaultResourceBundle.getString(ProfileResourceBundle.getKey(resourceId + 2000));
            }
            return DefaultResourceBundle.getString(ProfileResourceBundle.getKey(resourceId));
        }
        catch (RuntimeException runtimeException) {
            return super.getResource(resourceId);
        }
    }

    public TransportService getTransport() {
        DeviceService device = this.getDevice();
        if (device != null) {
            return device.getTransport();
        }
        return super.getTransport();
    }

    public void initialize(String capabilities, String status, String configuration) {
        this.capabilities = new Measurement(capabilities);
        this.status = new Measurement(status);
        this.configuration = new Measurement(configuration);
        this.metrics = new MethodMeasurement("Device/Metrics");
        this.put((ControlService)this.configuration);
        this.put((ControlService)this.status);
        this.put((ControlService)this.capabilities);
        this.put((ControlService)this.metrics);
    }

    public void initializeCommand(CommandService command) {
        if (command != null) {
            command.addCommandListener((CommandListener)this);
        }
    }

    public void initializeMeasurement(MeasurementService measurement) {
        if (measurement != null) {
            measurement.addMeasurementListener((MeasurementListener)this);
            measurement.executeRead();
        }
    }

    public void initializeSignal(SignalService signal) {
        if (signal != null) {
            signal.addSignalListener((SignalListener)this);
        }
    }

    public boolean isAdapterNeeded() {
        return this.isDeviceNeeded();
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    public void removeProfileListener(ProfileListener profileListener) {
        this.setProfileListener(ProfileListeners.remove(this.getProfileListener(), profileListener));
    }

    public void setDevice(DeviceService device) {
        if (this == device) {
            throw new RuntimeException(String.valueOf(device));
        }
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
        }
        this.device = device;
        if (this.device != null) {
            this.device.addDeviceListener((DeviceListener)this);
        }
        this.setDeviceCustom(device);
    }

    public void setDeviceCustom(DeviceService device) {
    }

    public void setProfileListener(ProfileListener profileListener) {
        this.profileListener = profileListener;
    }

    public void setState(int state) {
        if (this.isDeviceNeeded()) {
            int deviceState;
            if (state < 2) {
                super.setState(state);
                return;
            }
            DeviceService device = this.getDevice();
            if (device != null && (deviceState = device.getState()) > 2) {
                AdapterService adapter;
                if (this.isAdapterNeeded() && (adapter = this.getAdapter()) != null) {
                    int adapterState = adapter.getState();
                    if (adapterState > 2) {
                        super.setState(deviceState);
                        return;
                    }
                    super.setState(2);
                    return;
                }
                super.setState(deviceState);
                return;
            }
            super.setState(2);
        } else {
            super.setState(state);
        }
    }

    public void setup() {
        super.setup();
        if (this.getDevice() == null) {
            this.setDevice(this.getDefaultDevice());
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
    }
}

