/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.profile.testcases;

import java.util.Dictionary;
import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.rfid.inventory.profile.testcases.RfidInventoryProfileTester;

public class RfidInventoryTestcase
extends TestCase
implements NotificationListener {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.rfid.inventory.profile.testcases.RfidInventoryTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public RfidInventoryTestcase(String name) {
        super(name);
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("Notification: ");
        buffer.append(externalKey);
        buffer.append(" data: ");
        Nls.formatData((StringBuffer)buffer, (Object)data, (int)0, (int)100, (int)10);
        System.out.println(buffer.toString());
    }

    public void test01() {
        NotificationService notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        RfidInventoryProfileTester rfidInventoryProfileTester = new RfidInventoryProfileTester();
        rfidInventoryProfileTester.setNotificationService(notificationService);
        rfidInventoryProfileTester.autonomousModeOn();
        HashMap<String, Integer> value = new HashMap<String, Integer>();
        value.put("peakRSSI", new Integer(0));
        value.put("antenna", new Integer(1));
        rfidInventoryProfileTester.notifyTagRead("123", value);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        HashMap<String, Integer> value1 = new HashMap<String, Integer>();
        value1.put("peakRSSI", new Integer(1));
        value1.put("antenna", new Integer(2));
        rfidInventoryProfileTester.notifyTagRead("123", value1);
        rfidInventoryProfileTester.notifyTagRead("123", value1);
        rfidInventoryProfileTester.notifyTagRead("123", value1);
        rfidInventoryProfileTester.autonomousModeOff();
    }

    public void test02() {
        NotificationService notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        RfidInventoryProfileTester rfidInventoryProfileTester = new RfidInventoryProfileTester();
        rfidInventoryProfileTester.setNotificationService(notificationService);
        rfidInventoryProfileTester.autonomousModeOn();
        HashMap map = new HashMap();
        HashMap<String, Integer> value = new HashMap<String, Integer>();
        value.put("peakRSSI", new Integer(0));
        value.put("antenna", new Integer(1));
        map.put("123", value);
        rfidInventoryProfileTester.notifyTagRead(map);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        HashMap map1 = new HashMap();
        HashMap<String, Integer> value1 = new HashMap<String, Integer>();
        value1.put("peakRSSI", new Integer(1));
        value1.put("antenna", new Integer(2));
        map1.put("123", value1);
        rfidInventoryProfileTester.notifyTagRead(map1);
        rfidInventoryProfileTester.autonomousModeOff();
    }

    public void test03() {
        NotificationService notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        RfidInventoryProfileTester rfidInventoryProfileTester = new RfidInventoryProfileTester();
        rfidInventoryProfileTester.setNotificationService(notificationService);
        rfidInventoryProfileTester.autonomousModeOn();
        HashMap map = new HashMap();
        HashMap<String, Integer> value = new HashMap<String, Integer>();
        value.put("peakRSSI", new Integer(0));
        value.put("antenna", new Integer(1));
        map.put("123", value);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        HashMap<String, Integer> value1 = new HashMap<String, Integer>();
        value1.put("peakRSSI", new Integer(1));
        value1.put("antenna", new Integer(2));
        map.put("1234", value1);
        rfidInventoryProfileTester.notifyTagRead(map);
        rfidInventoryProfileTester.autonomousModeOff();
    }
}

